package com.supwisdom.dlpay.consume.service

import com.supwisdom.dlpay.consume.PersonTransBuilder
import com.supwisdom.dlpay.consume.domain.TAccount
import com.supwisdom.dlpay.consume.domain.TUserdtl
import com.supwisdom.dlpay.framework.domain.TShopacc
import com.supwisdom.dlpay.framework.domain.TSubject
import com.supwisdom.dlpay.framework.domain.TTranstype

interface AccountUtilServcie {

    fun readAccountForUpdate(userid: String, nowait: Boolean): TAccount
    fun readAccount(userid: String): TAccount

    fun readShopAccForUpdate(shopId: Int, nowait: Boolean): TShopacc
    fun readShopAcc(shopId: Int): TShopacc

    fun readSubjectForUpdate(subjno: String, nowait: Boolean): TSubject
    fun readSubject(subjno: String): TSubject

    fun readTranstype(transtype: Int) : TTranstype
}

interface PersonBalancePayService {

    /**
     * 一步完成交易
     */
    fun process(builder: PersonTransBuilder): TUserdtl

    /**
     * 两步交易，交易初始化方法，检查交易参数，记录交易流水
     */
    fun init(builder: PersonTransBuilder): TUserdtl

    /**
     * 两步交易，完成交易过程，包括更新交易状态（成功、失败），更新借贷双方余额
     */
    fun finish(paydtl: TUserdtl, status: String, businessData: Map<String, String>?): TUserdtl

    fun finish(refno: String, status: String, businessData: Map<String, String>?): TUserdtl

    /**
     * 两步交易，交易过程中判断交易状态，并更新交易状态为 wip
     */
    fun wip(paydtl: TUserdtl): TUserdtl

    fun wip(refno: String): TUserdtl


}