package com.supwisdom.dlpay.api.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

@Entity
@Table(name = "TB_PERSON",
    indexes = {@Index(name = "person_name_idx", columnList = "name"),
        @Index(name = "person_idno_uk", unique = true, columnList = "idtype,idno")})
public class TPerson {
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "USERID", nullable = false, length = 32)
  private String userid;

  @Column(name = "NAME", length = 200)
  private String name;

  @Column(name = "SEX", length = 10)
  private String sex;

  @Column(name = "STATUS", nullable = false, length = 10)
  private String status;

  @Column(name = "IDTYPE", length = 20)
  private String idtype;

  @Column(name = "IDNO", length = 30)
  private String idno;

  @Column(name = "COUNTRY", length = 3)
  private String country;

  @Column(name = "NATION", length = 3)
  private String nation;

  @Column(name = "EMAIL", length = 60)
  private String email;

  @Column(name = "TEL", length = 20)
  private String tel;

  @Column(name = "MOBILE", length = 30)
  private String mobile;

  @Column(name = "ADDR", length = 240)
  private String addr;

  @Column(name = "ZIPCODE", length = 10)
  private String zipcode;

  @Column(name = "LASTSAVED", length = 14)
  private String lastsaved;

  public TPerson() {
  }

  public TPerson(String name, String sex, String status, String idtype, String idno, String country, String nation, String email, String tel, String mobile, String addr, String zipcode, String lastsaved) {
    this.name = name;
    this.sex = sex;
    this.status = status;
    this.idtype = idtype;
    this.idno = idno;
    this.country = country;
    this.nation = nation;
    this.email = email;
    this.tel = tel;
    this.mobile = mobile;
    this.addr = addr;
    this.zipcode = zipcode;
    this.lastsaved = lastsaved;
  }



  public String getUserid() {
    return userid;
  }

  public void setUserid(String userid) {
    this.userid = userid;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getSex() {
    return sex;
  }

  public void setSex(String sex) {
    this.sex = sex;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getIdtype() {
    return idtype;
  }

  public void setIdtype(String idtype) {
    this.idtype = idtype;
  }

  public String getIdno() {
    return idno;
  }

  public void setIdno(String idno) {
    this.idno = idno;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public String getNation() {
    return nation;
  }

  public void setNation(String nation) {
    this.nation = nation;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getTel() {
    return tel;
  }

  public void setTel(String tel) {
    this.tel = tel;
  }

  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  public String getAddr() {
    return addr;
  }

  public void setAddr(String addr) {
    this.addr = addr;
  }

  public String getZipcode() {
    return zipcode;
  }

  public void setZipcode(String zipcode) {
    this.zipcode = zipcode;
  }

  public String getLastsaved() {
    return lastsaved;
  }

  public void setLastsaved(String lastsaved) {
    this.lastsaved = lastsaved;
  }
}
