package com.supwisdom.dlpay.app.dao;


import com.supwisdom.dlpay.app.domain.EVisitorDtl;
import com.supwisdom.dlpay.app.domain.EWechatAccount;
import com.supwisdom.dlpay.app.domain.TAppDevFre;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;

import java.util.List;

public interface AppDao {
    public List<TNcDevice> findAllDevByUserId(String userId);

    public List<TNcDevice> findAllDevByUserIdAndDevName(String userId,String devName);

    //获取app远程开门最大流水号
    public String getMaxAppRmtSeqNo();

    //获取用户对指定设备的开门次数
    public int getDevAppFreByUserId(String userId,int devId);

    //修改设备开门次数
    public int updateFreByUserIdAndDevId(String userId,int devId,int frequency);

    //保存AppDevFre对象
    public boolean saveAppDevFre(TAppDevFre bean);



    public boolean saveAccount(EWechatAccount bean);
    public boolean saveVisitor(EVisitorDtl bean);
    public boolean updateAccount(EWechatAccount bean);


    public List<EWechatAccount> getAccountByOpenid(String openid);
}
