package com.supwisdom.dlpay.app.dao.impl;

import com.supwisdom.dlpay.app.dao.AppDao;
import com.supwisdom.dlpay.app.domain.EVisitorDtl;
import com.supwisdom.dlpay.app.domain.EWechatAccount;
import com.supwisdom.dlpay.app.domain.TAppDevFre;
import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.List;

@Repository
public class AppDaoImpl implements AppDao {

    @PersistenceContext
    EntityManager entityManager;


    @Transactional
    @Override
    public List<TNcDevice> findAllDevByUserId(String userId) {
        String sql = "select a.* from t_nc_device a  " +
                " left join tb_app_devfre c on a.deviceid=c.deviceid " +
                " where a.devtype='R' and a.deviceid in  " +
                "    (select b.deviceid from t_nc_cardlist b where b.operflag='A' and b.syncflag='Y' and b.custid=?1 )  " +
                " order by c.frequency desc ";
        Query query = entityManager.createNativeQuery(sql, TNcDevice.class);
        query.setParameter(1, userId);
        List<TNcDevice> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list;
        }
        return null;
    }

    @Transactional
    @Override
    public List<TNcDevice> findAllDevByUserIdAndDevName(String userId, String devName) {
        String sql = "select a.* from t_nc_device a  " +
                " left join tb_app_devfre c on a.deviceid=c.deviceid " +
                " where a.devtype='R' and a.devname like ?2 and a.deviceid in  " +
                "    (select b.deviceid from t_nc_cardlist b where b.operflag='A' and b.syncflag='Y' and b.custid=?1 )  " +
                " order by c.frequency desc ";
        Query query = entityManager.createNativeQuery(sql, TNcDevice.class);
        query.setParameter(1, userId);
        query.setParameter(2, "%"+devName+"%");
        List<TNcDevice> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list;
        }
        return null;
    }

    @Transactional
    @Override
    public String getMaxAppRmtSeqNo() {
        String sql = "select max(doorseqno) from t_doordtl where doorseqno like 'AR%' ";
        Query query = entityManager.createNativeQuery(sql);
        List list = query.getResultList();
        if (list!=null && list.size()>0 && list.get(0)!=null){
            return list.get(0).toString();
        }
        return null;
    }

    @Transactional
    @Override
    public int getDevAppFreByUserId(String userId, int devId) {
        String sql = " select frequency from tb_app_devfre where custid=?1 and deviceid=?2 ";
        Query query = entityManager.createNativeQuery(sql);
        query.setParameter(1, userId);
        query.setParameter(2, devId);
        List list = query.getResultList();
        if (list!=null && list.size()>0 && list.get(0)!=null){
            return (int)list.get(0);
        }
        return 0;
    }

    @Transactional
    @Override
    public int updateFreByUserIdAndDevId(String userId, int devId,int frequency) {
        String sql = "update tb_app_devfre set frequency=?1 where custid=?2 and deviceid=?3 ";
        Query query = entityManager.createNativeQuery(sql);
        query.setParameter(1, frequency);
        query.setParameter(2, userId);
        query.setParameter( 3, devId);
        int i = query.executeUpdate();
        return i;
    }

    @Transactional
    @Override
    public boolean saveAppDevFre(TAppDevFre bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }
    @Transactional
    @Override
    public boolean saveAccount(EWechatAccount bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }
    @Transactional
    @Override
    public boolean saveVisitor(EVisitorDtl bean) {

        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }
    @Transactional
    @Override
    public boolean updateAccount(EWechatAccount bean) {
        boolean flag = false;
        try {
            entityManager.merge(bean);
            flag = true;
        } catch (Exception e) {
            throw  e;
        }
        return flag;
    }
    @Transactional
    @Override
    public List<EWechatAccount> getAccountByOpenid(String openid) {
        String sql = "select a.* from e_wechat_account a where a.openid =? and a.status='1'";

        Query query = entityManager.createNativeQuery(sql, EWechatAccount.class);
        query.setParameter(1, openid);
        List<EWechatAccount> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list;
        }
        return null;
    }
}
