package com.supwisdom.dlpay.app.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Created by shuwei on 17/6/12.
 */
@Entity
@Table(name = "E_WECHAT_ACCOUNT")
public class EWechatAccount implements Serializable {

    private String wxid;
    private String userid;
    private Double appkey;
    private String openid;
    private String stuempno;
    private String status;
    private String binddate;
    private String nickname;
    private String sex;
    private String province;
    private String city;
    private String country;
    private String headimgurl;
    private String privilege;
    private String unionid;
    private String cardcode;

    @Id
    @Column(name = "WXID", unique = true,  nullable = false, length = 32)
    @GeneratedValue(strategy = GenerationType.AUTO)
    public String getWxid() {
        return wxid;
    }

    public void setWxid(String wxid) {
        this.wxid = wxid;
    }
    @Column(name = "USERID", length = 32)
    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }
    @Column(name = "APPKEY",  length = 32)
    public Double getAppkey() {
        return appkey;
    }

    public void setAppkey(Double appkey) {
        this.appkey = appkey;
    }
    @Column(name = "OPENID",length = 128)
    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }
    @Column(name = "STUEMPNO", length = 40)
    public String getStuempno() {
        return stuempno;
    }

    public void setStuempno(String stuempno) {
        this.stuempno = stuempno;
    }
    @Column(name = "STATUS", length = 1)
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
    @Column(name = "BINDDATE", length = 14)
    public String getBinddate() {
        return binddate;
    }

    public void setBinddate(String binddate) {
        this.binddate = binddate;
    }
    @Column(name = "NICKNAME", length = 100)
    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }
    @Column(name = "SEX", length = 1)
    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }
    @Column(name = "PROVINCE", length = 60)
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }
    @Column(name = "CITY", length = 60)
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }
    @Column(name = "COUNTRY", length = 60)
    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }
    @Column(name = "HEADIMGURL", length = 200)
    public String getHeadimgurl() {
        return headimgurl;
    }

    public void setHeadimgurl(String headimgurl) {
        this.headimgurl = headimgurl;
    }
    @Column(name = "PRIVILEGE", length = 40)
    public String getPrivilege() {
        return privilege;
    }

    public void setPrivilege(String privilege) {
        this.privilege = privilege;
    }
    @Column(name = "UNIONID", length = 128)
    public String getUnionid() {
        return unionid;
    }

    public void setUnionid(String unionid) {
        this.unionid = unionid;
    }

    @Column(name = "CARDCODE", length = 40)
    public String getCardcode() {
        return cardcode;
    }

    public void setCardcode(String cardcode) {
        this.cardcode = cardcode;
    }

    @Override
    public String toString() {
        return "EWechatAccount{" +
                "wxid='" + wxid + '\'' +
                ", userid='" + userid + '\'' +
                ", appkey=" + appkey +
                ", openid='" + openid + '\'' +
                ", stuempno='" + stuempno + '\'' +
                ", status='" + status + '\'' +
                ", binddate='" + binddate + '\'' +
                ", nickname='" + nickname + '\'' +
                ", sex='" + sex + '\'' +
                ", province='" + province + '\'' +
                ", city='" + city + '\'' +
                ", country='" + country + '\'' +
                ", headimgurl='" + headimgurl + '\'' +
                ", privilege='" + privilege + '\'' +
                ", unionid='" + unionid + '\'' +
                ", cardcode='" + cardcode + '\'' +
                '}';
    }
}
