package com.supwisdom.dlpay.atte.controller;

import com.supwisdom.dlpay.atte.bean.AttedtlSearchBean;
import com.supwisdom.dlpay.atte.domain.TAtteClass;
import com.supwisdom.dlpay.atte.domain.TAtteDtl;
import com.supwisdom.dlpay.atte.domain.TSeaCusttype;
import com.supwisdom.dlpay.atte.domain.TSeason;
import com.supwisdom.dlpay.atte.service.AtteClassService;
import com.supwisdom.dlpay.atte.service.CustseaService;
import com.supwisdom.dlpay.atte.service.SeasonService;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.domain.TCustomer;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.ncmgr.domain.TNcTime;
import com.supwisdom.dlpay.ncmgr.domain.TNcTimegrp;
import com.supwisdom.dlpay.ncmgr.domain.TNcWeektime;
import com.supwisdom.dlpay.ncmgr.service.NcService;
import com.supwisdom.dlpay.system.domain.TCustType;
import com.supwisdom.dlpay.system.domain.TDept;
import com.supwisdom.dlpay.system.domain.TDictionaryId;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Controller
@RequestMapping("/atte")
public class CustAtteController {

    private static Logger log= LoggerFactory.getLogger(CustAtteController.class);

    @Autowired
    SeasonService seasonService;
    @Autowired
    NcService ncService;
    @Autowired
    CustseaService custseaService;
    @Autowired
    private SystemService systemService;
    @Autowired
    AtteClassService atteClassService;

    @GetMapping("/rule/index")
    public String seasonindex(){
        return "atte/role/index";
    }
    /**
     *  查询规则列表
     */
    @ResponseBody
    @RequestMapping(value="/rule/list")
    public Map loadseasonlist(HttpServletRequest request,
                              HttpServletResponse response,
                              @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                              @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                              @RequestParam(value = "season", required = true, defaultValue = "") String season,
                              @AuthenticationPrincipal TOperator operUser) {

            Map map=new HashMap();
            try {
                Pagination page=null;
                String opertype=operUser.getOpertype();
                String deptcode=operUser.getDeptcode();
                if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                    page=seasonService.getSeasonWithPage(season,null,pageNo,pageSize);
                }else {

                    if(StringUtil.isEmpty(deptcode)){
                        deptcode="-1";
                    }
                    page=seasonService.getSeasonWithPage(season,deptcode,pageNo,pageSize);
                }
                List<TNcWeektime> weeklist=ncService.findAllNcWeekTime();
                map.put("PageResult",page);
                map.put("weeklist",weeklist);
                List<TCustType> custtypelist=systemService.findAllCusttype();
                map.put("custtypelist",custtypelist);
                List<TDept> deptlist=systemService.findAllDept();
                map.put("deptlist",deptlist);
                map.put("operator",operUser);
                for(TDept dept:deptlist){
                    if(dept.getDeptcode().equals(operUser.getDeptcode())){
                        map.put("dept",dept);
                    }
                }
            }catch (Exception e) {
                e.printStackTrace();
                log.error("查询考勤规则失败：" + e.getMessage());
            }
        return map;
    }
    /**
     *  获取规则信息
     */
    @ResponseBody
    @RequestMapping("/loadSeasonForUpdate")
    public Map loadSeasonForUpdate( @RequestParam(value = "sid") int id){
        Map map=new HashMap();
        try {
            TSeason season=seasonService.getSeasonById(id);
            map.put("season",season);
            List<TNcWeektime> list=ncService.findAllNcWeekTime();
            map.put("weekgrp",list);
        }catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     *  添加考勤规则
     */
    @ResponseBody
    @RequestMapping(value="/addSeason",method = {RequestMethod.POST})
    public Map addSeason(@RequestBody TSeason postData,
                         HttpServletRequest request, HttpServletResponse response) {
            Map map=new HashMap();
        try {
            TSeason season=seasonService.findBySeason(postData.getSeason());
             if(season==null){
                 int id=seasonService.getMaxSeasonId()+1;
                 TSeason newseason=new TSeason();
                 newseason.setAddtime(DateUtil.getNow());
                 newseason.setUpdatetime(DateUtil.getNow());
                 newseason.setId(id);
                 newseason.setWeekid(postData.getWeekid());
                 newseason.setSeason(postData.getSeason());
                 newseason.setDeptcode(postData.getDeptcode());
                 newseason.setCusttypeid(postData.getCusttypeid());
                 newseason.setStatus(2);
                 seasonService.saveSeason(newseason);
                 map.put("errStr", "");
             }else{
                 map.put("errStr","规则名称已存在");
                 return map;
             }

        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "添加规则失败！");
            log.error("添加规则失败：" + e.getMessage());
        }
        return map;
    }

    /**
     *  修改规则
     */
    @ResponseBody
    @RequestMapping(value = "/updateSeason",method = {RequestMethod.POST})
    public Map updateSeason(@RequestBody TSeason bean,
                            HttpServletRequest request) {
        Map map=new HashMap();

        try {
            if(bean==null){
                map.put("errStr","请选择规则");
                return map;
            }
            TSeason temp=seasonService.findSeasonByIdAndName(bean.getId(),bean.getSeason());
            if(temp!=null){
                map.put("errStr","该规则名称已存在，请从新修改！");
                return map;
            }
            TSeason open=seasonService.getOpenRule(bean.getCusttypeid(),bean.getDeptcode());
                if(open!=null&&open.getId()!=bean.getId()){
                    map.put("errStr","所选部门,人员类别下存在已启用的规则!");
                    return map;
                }
             TSeason season=seasonService.getSeasonById(bean.getId());
                  season.setSeason(bean.getSeason());
                  season.setCusttypeid(bean.getCusttypeid());
                  season.setDeptcode(bean.getDeptcode());
                  season.setUpdatetime(DateUtil.getNow());
                  season.setWeekid(bean.getWeekid());
                seasonService.updateSeason(season);
                  map.put("errStr","");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr","修改规则失败！");
            log.error("修改规则失败信息:",e.getMessage());
        }
        return map;

    }
    /**
     *  启用停用规则
     */
    @ResponseBody
    @RequestMapping(value = "/stoporopenrule",method = {RequestMethod.POST})
    public Map openOrStop(@RequestParam(value = "id") int id,
                            HttpServletRequest request) {
        Map map=new HashMap();

        try {
            seasonService.stoporopen(id);
            map.put("errStr","");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr","启用/停用考勤规则失败！");
            log.error("启用/停用考勤规则:",e.getMessage());
        }
        return map;

    }
    /**
     *  删除考勤规则
     */
    @ResponseBody
    @RequestMapping(value="/deleteSeason",method = {RequestMethod.GET})
    public Map deleteSeason(@RequestParam(value = "id") int id,
                            HttpServletRequest request, HttpServletResponse response) {
        Map map=new HashMap();
        int flag=0;
        String message="";
        try {
            seasonService.deleteSeason(id);
            map.put("errStr","");
        } catch (Exception e) {
            e.printStackTrace();
            log.error("删除考勤规则异常",e.getMessage());
            message=e.getMessage();
            flag=1;
        }
        map.put("flag",flag);
        map.put("message", message);
        return map;
    }
    /**
     *  人员类别绑定时令页面
     */
    @GetMapping("/custsea/index")
    public String  custseaindex(){
        return "atte/custsea/index";
    }

    /**
     *   类别时令列表
     */
    @ResponseBody
    @RequestMapping(value="/custsea/list")
    public Map loadcustsealist(HttpServletRequest request,
                              HttpServletResponse response,
                              @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                              @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                              @RequestParam(value = "custtypename", required = true, defaultValue = "") String custtypename) {
        Map map=new HashMap();

        try {
            Pagination page=null;
            page=custseaService.getCustseaWithPage(custtypename,pageNo,pageSize);
            map.put("PageResult",page);
            List<TSeason> seasonlist=seasonService.findAllSeason();
            map.put("seasonlist",seasonlist);
            List<TCustType> custtypelist=systemService.findAllCusttype();
            map.put("custtypelist",custtypelist);
            List<TDictionaryId> dicts = systemService.findTDictionaryByType(8);
            map.put("dicts", dicts);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("查询客户类别时令列表错误：",e.getMessage());
        }
        return map;

    }
    /**
     *  获取类别时令信息
     */
    @ResponseBody
    @RequestMapping("/loadCustseaForUpdate")
    public Map loadCustseaForUpdate( @RequestParam(value = "custtypeid") int custtypeid){
        Map map=new HashMap();
        try {
            TSeaCusttype custsea=custseaService.getCustseaById(custtypeid);
            map.put("custsea",custsea);
            List<TSeason> seasonlist=seasonService.findAllSeason();
            map.put("seasonlist",seasonlist);
            List<TCustType> custtypelist=systemService.findAllCusttype();
            map.put("custtypelist",custtypelist);
        }catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }
    /**
     *  修改或添加  类别时令
     */
    @ResponseBody
    @RequestMapping(value="/saveOrUpdateCustsea",method = {RequestMethod.GET})
    public Map saveOrUpdateCustsea(@RequestParam(value = "id") int id,
                                   @RequestParam(value = "custtypeid",defaultValue = "0") int custtypeid,
                            HttpServletRequest request, HttpServletResponse response) {
        Map map = new HashMap();

        try {
            if (!custseaService.exist(custtypeid)){
                TSeaCusttype newCustsea=new TSeaCusttype();
                newCustsea.setCusttypeid(custtypeid);
                newCustsea.setId(id);
                newCustsea.setUpdatetime(DateUtil.getNow());
                custseaService.saveCustsea(newCustsea);
            }else{
                TSeaCusttype oldCustsea=custseaService.getCustseaById(custtypeid);
                oldCustsea.setId(id);
                oldCustsea.setUpdatetime(DateUtil.getNow());
                custseaService.updateCustsea(oldCustsea);
            }
            map.put("errStr","");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr",e.getMessage());
        }
        return map;
    }
    /**
     *  分配设备
     */
    @RequestMapping("/assign/index")
    public String assginindex(Model model){
        return "/season/index";
    }
    /**
     *  查询设备
     */
    @ResponseBody
    @RequestMapping(value = "/assign/devlist",method = {RequestMethod.GET})
    public Map getAssignDev( @RequestParam(value = "ruleid") Integer ruleid,
                             @RequestParam(value = "devname") String devname,
                             @RequestParam(value = "devtype") String  devtype,
                             HttpServletRequest request, HttpServletResponse response) {
            Map map=new HashMap();

        try {
            List<TNcDevice> list=custseaService.getAllCanAssign(ruleid,devname,devtype);
            map.put("canassignlist",list);
            List<TNcDevice> list1=custseaService.getAllDevByCusttype(ruleid);
            map.put("hasassignlist",list1);
            map.put("errStr","");
        } catch (Exception e) {
            e.printStackTrace();
        }

        return map ;
    }
    /**
     *  分配设备
     */
    @ResponseBody
    @RequestMapping(value = "/assign/save",method = {RequestMethod.POST})
    public Map saveDevCusttype(@RequestParam(value = "ruleid") String ruleid,
                               @RequestParam(value = "ids") String ids,
                               HttpServletRequest request, HttpServletResponse response) {
        Map map=new HashMap();

        try {

            custseaService.assignDevRule(ids,ruleid);
            map.put("okFlag","1");
        } catch (Exception e) {
            e.printStackTrace();
        }

        return map;
    }
    /**
     *  考勤排班
     */
    @GetMapping("/class/index")
    public String classindex(){
        return "atte/class/index";
    }

    @ResponseBody
    @RequestMapping("/class/list")
    public Map loadClassList(HttpServletRequest request,
                             HttpServletResponse response,
                             @AuthenticationPrincipal TOperator operUser,
                             @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                             @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                             @RequestParam(value = "classname", required = true, defaultValue = "") String classname) {

        Map map=new HashMap();

        try {
            Pagination page=null;
            String opertype=operUser.getOpertype();
            String deptcode=operUser.getDeptcode();
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                page=atteClassService.getClassWithPage(classname,null,pageNo,pageSize);
            }else {

                if(StringUtil.isEmpty(deptcode)){
                    deptcode="-1";
                }
                page=atteClassService.getClassWithPage(classname,deptcode,pageNo,pageSize);
            }
            map.put("PageResult",page);
            map.put("errStr","");
            List<TNcTimegrp> timegrplist = ncService.findAllNcTimeGrp();
            map.put("timelist",timegrplist);
            List<TCustType> custtypelist=systemService.findAllCusttype();
            map.put("custtypelist",custtypelist);
            List<TDept> deptlist=systemService.findAllDept();
            map.put("deptlist",deptlist);
            map.put("operator",operUser);
            for(TDept dept:deptlist){
                if(dept.getDeptcode().equals(operUser.getDeptcode())){
                    map.put("dept",dept);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr",e.getMessage());
        }

        return map;
    }
    /**
     *  获取班次信息
     */
    @ResponseBody
    @RequestMapping("/loadClassForUpdate")
    public Map loadClassForUpdate( @RequestParam(value = "classid") Integer classid){
        Map map=new HashMap();
        try {
            TAtteClass atteclass=atteClassService.getClassById(classid);
            map.put("atteclass",atteclass);
        }catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     *  添加班次
     * @param
     */
    @ResponseBody
    @RequestMapping(value="/addClass",method = {RequestMethod.POST})
    public Map addClass( @RequestParam(value = "classname") String classname,
                                   @RequestParam(value = "workorno") int workorno,
                                  @RequestParam(value = "startdate") String startdate,
                                  @RequestParam(value = "enddate") String enddate,
                         @RequestParam(value = "timegrpid") Integer timegrpid,
                         @RequestParam(value = "deptcode") String deptcode,
                                   HttpServletRequest request, HttpServletResponse response) {
        Map map = new HashMap();
        try {
            TAtteClass old=atteClassService.getClassByName(classname);
            if(old==null){
                if(!atteClassService.canAddClass(deptcode,workorno,startdate,enddate,0)){
                    map.put("errStr","班次时间已存在");
                    return map;
                }
                TAtteClass atteClass=new TAtteClass();
                atteClass.setClassid(1+atteClassService.getMaxClassid());
                atteClass.setClassname(classname);
                atteClass.setStartdate(startdate);
                atteClass.setEnddate(enddate);
                atteClass.setStatus(1);
                atteClass.setTimegrpid(timegrpid);
                atteClass.setUpdatetime(DateUtil.getNow());
                atteClass.setWorkorno(workorno);
                atteClass.setDeptcode(deptcode);
                atteClassService.saveAtteClass(atteClass);
                map.put("errStr","");
            }else{
                map.put("errStr","班次名称已存在");
                return map;
            }

        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr",e.getMessage());
        }
        return map;
    }

    /**
     *   修改班次
     * @param
     */
    @ResponseBody
    @RequestMapping(value = "/updateClass",method = {RequestMethod.POST})
    public Map updateClass(@RequestBody TAtteClass bean,
                           @RequestParam(value = "startdate") String startdate,
                           @RequestParam(value = "enddate") String enddate,
                            HttpServletRequest request) {
        Map map=new HashMap();

        try {
            if(bean==null){
                map.put("errStr","请选择班次！");
                return map;
            }
            TAtteClass old=atteClassService.getClassByName(bean.getClassname());
            if(old.getClassid()!=bean.getClassid()){
                map.put("errStr","班次名称已存在！");
                return map;
            }
            if(atteClassService.canAddClass(bean.getDeptcode(),bean.getWorkorno(),bean.getStartdate(),bean.getEnddate(),bean.getClassid())){
                TAtteClass newclass=atteClassService.getClassById(bean.getClassid());
                newclass.setWorkorno(bean.getWorkorno());
                newclass.setStartdate(startdate);
                newclass.setEnddate(enddate);
                newclass.setTimegrpid(bean.getTimegrpid());
                newclass.setUpdatetime(DateUtil.getNow());
                newclass.setClassname(bean.getClassname());
                newclass.setDeptcode(bean.getDeptcode());
                atteClassService.updateClass(newclass);
            }else{
                map.put("errStr","班次时间存在！");
                return map;
            }

            map.put("errStr","");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr","修改班次失败！");
            log.error("修改班次失败信息:",e.getMessage());
        }
        return map;

    }
    /**
     * 获取排班的人员名单
     *
     * @param perName
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/getCustomerList", method = RequestMethod.POST)
    public Map getCustomerList(@RequestParam(value = "classid", required = false, defaultValue = "0") Integer classid,
                              @RequestParam(value = "perName", required = false, defaultValue = "") String perName,
                                   @RequestParam(value = "custtypeid", required = false, defaultValue = "") String custtypeid,
                                   @RequestParam(value = "deptcode", required = false, defaultValue = "") String deptcode) {
        Map map = new HashMap();
        try {
            TAtteClass atteClass=atteClassService.getClassById(classid);
            List<TCustomerInfo> allcust=atteClassService.getAllCustomer(perName,atteClass.getDeptcode(),custtypeid);
            List<TCustomerInfo> hasclasscust=atteClassService.hasClassCust(classid);
            Boolean countIndex = false;
            if (allcust.size() > 4000) {
                countIndex = true;
            }
            allcust.removeAll(hasclasscust);
            map.put("allcust",allcust);
            map.put("hasclasscust",hasclasscust);
            map.put("countIndex", countIndex);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("名单查询失败--" + e.getMessage());
        }
        return map;
    }

    /**
     *     考勤排班
     * @param
     */
    @ResponseBody
    @RequestMapping("/addCustClass")
    public Map saveCustClass(@RequestParam(value = "idlist") List<String> custids,
                               @RequestParam(value = "classid") Integer classid,
                               HttpServletRequest request, HttpServletResponse response) {
        Map map=new HashMap();

        try {
            if(classid==null){
                map.put("errStr","请选择班次！");
                return map;
            }
            atteClassService.addClassCust(classid,custids);
            map.put("errStr","");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr","添加班次人员异常!");
        }

        return map;
    }
    /**
     *  删除班次
     */
    @ResponseBody
    @RequestMapping(value="/deleteClass",method = {RequestMethod.POST})
    public Map deleteClass(@RequestParam(value = "classid") int classid,
                            HttpServletRequest request, HttpServletResponse response) {
        Map map=new HashMap();
        int flag=0;
        String message="";
        try {
            atteClassService.deleteAtteClass(classid);
            map.put("errStr","");
        } catch (Exception e) {
            e.printStackTrace();
            log.error("删除班次异常",e.getMessage());
            message=e.getMessage();
            flag=1;
        }
        map.put("flag",flag);
        map.put("message", message);
        return map;
    }


    //手动生成考勤名单
    @ResponseBody
    @RequestMapping("/adddtlbyhand")
    public Map adddtl(@RequestParam(value = "startdate") String startdate,
                      @RequestParam(value = "enddate") String enddate,
                      @AuthenticationPrincipal TOperator operUser,
                      HttpServletRequest request, HttpServletResponse response) {
        Map map=new HashMap();
        String opertype=operUser.getOpertype();
        String deptcode=operUser.getDeptcode();
        if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                deptcode=null;
        }else {
            if(StringUtil.isEmpty(deptcode)){
                deptcode="-1";
            }
        }
        atteClassService.addBatchDtl(startdate,enddate,deptcode);
        atteClassService.handleDtl(deptcode,startdate);
        return map;
    }

    /**
     *    考勤流水页面
     * @param
     */
    @GetMapping("/dtl/index")
    public String dtlindex(){
        return "atte/dtl/index";
    }

    /**
     *    考勤流水列表
     * @param
     */
    @ResponseBody
    @RequestMapping(value="/dtl/list",method = {RequestMethod.POST})
    public Map loadattedtllist(HttpServletRequest request,
                               HttpServletResponse response,
                               @AuthenticationPrincipal TOperator operUser,
                               @RequestBody AttedtlSearchBean searchBean,
                               @RequestParam(value = "startdate") String  startdate,
                               @RequestParam(value = "enddate") String  enddate,
                               @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                               @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize
                              ) {
        Map map=new HashMap();

        try {
            String deptcode=operUser.getDeptcode();
            String opertype=operUser.getOpertype();
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                deptcode=null;
            }else {
                if(StringUtil.isEmpty(deptcode)){
                    deptcode="-1";
                }
            }
            searchBean.setDeptcode(deptcode);
            searchBean.setStartdate(startdate);
            searchBean.setEnddate(enddate);
            Pagination page=null;
            page=atteClassService.getDtlWithPage(searchBean,pageNo,pageSize);
            map.put("PageResult",page);
            List<TCustType> custtypelist=systemService.findAllCusttype();
            map.put("custtypelist",custtypelist);
//            List<TNcTime> timelist=ncService.findAllNcTime();
//            map.put("timelist",timelist);
            List<TDept> deptlist=systemService.findAllDept();
            map.put("deptlist",deptlist);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("查询考勤流水信息出错：",e.getMessage());
        }
        return map;

    }



    /**
     *    考勤状态页面
     * @param
     */
    @GetMapping("/timedtl/index")
    public String timedtlindex(){
        return "atte/timedtl/index";
    }

    /**
     *    考勤明细列表
     * @param
     */
    @ResponseBody
    @RequestMapping(value="/timedtl/list",method = {RequestMethod.POST})
    public Map loadtimedtllist(HttpServletRequest request,
                               HttpServletResponse response,
                               @AuthenticationPrincipal TOperator operUser,
                               @RequestBody AttedtlSearchBean searchBean,
                               @RequestParam(value = "startdate") String  startdate,
                               @RequestParam(value = "enddate") String  enddate,
                               @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                               @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize
    ) {
        Map map=new HashMap();

        try {
            String opertype=operUser.getOpertype();
            String deptcode=operUser.getDeptcode();
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                deptcode=null;
            }else {
                if(StringUtil.isEmpty(deptcode)){
                    deptcode="-1";
                }
            }
            searchBean.setDeptcode(deptcode);
            searchBean.setStartdate(startdate);
            searchBean.setEnddate(enddate);
            Pagination page=null;
            page=atteClassService.getAtteDtlInfoWithPage(searchBean,pageNo,pageSize);
            map.put("PageResult",page);
            List<TCustType> custtypelist=systemService.findAllCusttype();
            map.put("custtypelist",custtypelist);
            List<TNcTime> timelist=ncService.findAllNcTime();
            map.put("timelist",timelist);
            List<TDept> deptlist=systemService.findAllDept();
            map.put("deptlist",deptlist);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("查询考勤流水信息出错：",e.getMessage());
        }
        return map;

    }

    /**
     *  修改考勤状态
     * @param
     */
    @ResponseBody
    @RequestMapping(value = "/updatetimeDtl",method = {RequestMethod.POST})
    public Map updateState(@RequestParam(value = "atteno") String atteno,
                           @RequestParam(value = "state") Integer state,
                           @RequestParam(value = "remark",defaultValue = " ") String remark,
                           HttpServletRequest request) {
        Map map=new HashMap();
        try {
            TAtteDtl dtl=atteClassService.getDtlByAtteno(atteno);
            if(dtl==null){
                map.put("errStr","请选择流水");
                return map;
            }
            dtl.setUpdatetime(DateUtil.getNow());
            dtl.setOldstate(dtl.getState());
            dtl.setState(state);
            dtl.setRemark(remark);
            atteClassService.updateAtteDtl(dtl);
            map.put("errStr","");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr","修改考勤流水状态失败！");
            log.error("修改考勤流水状态失败:",e.getMessage());
        }
        return map;

    }



    /**
     *    审核人管理
     * @param
     */
    @GetMapping("/review/index")
    public String reviewindex(){
        return "atte/review/index";
    }

    /**
     *  获取审核人员名单
     * @param
     */
    @ResponseBody
    @RequestMapping(value = "/review/custlist", method = RequestMethod.POST)
    public Map getReviewerList(
                               @RequestParam(value = "perName", required = false, defaultValue = "") String perName,
                               @RequestParam(value = "custtypeid", required = false, defaultValue = "") String custtypeid,
                               @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        try {

            String opertype=operUser.getOpertype();
            String deptcode=operUser.getDeptcode();
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                deptcode=null;
            }else {
                if(StringUtil.isEmpty(deptcode)){
                    deptcode="-1";
                }
            }
            List<TCustomerInfo> allcust=atteClassService.getAllCustomer(perName,deptcode,custtypeid);
            List<TCustomerInfo> reviewlist=atteClassService.getReviewList(deptcode);
            Boolean countIndex = false;
            if (allcust.size() > 4000) {
                countIndex = true;
            }
            allcust.removeAll(reviewlist);
            List<TCustType> custtypelist=systemService.findAllCusttype();
            map.put("custtypelist",custtypelist);
            map.put("allcust",allcust);
            map.put("reviewlist",reviewlist);
            map.put("countIndex", countIndex);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("名单查询失败--" + e.getMessage());
        }
        return map;
    }
    /**
     *     保存审核人员
     * @param
     */
    @ResponseBody
    @RequestMapping(value="/addreview", method = RequestMethod.POST)
    public Map saveReview(@RequestParam(value = "idlist") List<String> custids,
                          @AuthenticationPrincipal TOperator operUser,
                             HttpServletRequest request, HttpServletResponse response) {
        Map map=new HashMap();

        try {
            String opertype=operUser.getOpertype();
            String deptcode=operUser.getDeptcode();
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                deptcode=null;
            }else {
                if(StringUtil.isEmpty(deptcode)){
                    deptcode="-1";
                }
            }
            atteClassService.addReview(deptcode,operUser.getOpercode(),custids);
                map.put("errStr","");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr","保存信息异常!");
        }

        return map;
    }

    /**
     *    辅警干警考勤报表
     * @param
     */
    @GetMapping("/police/index")
    public String policeindex(){
        return "atte/report/p_index";
    }

    /**
     *  辅警干警报表
     */
    @ResponseBody
    @RequestMapping(value="/police/list")
    public Map policerepostlist(HttpServletRequest request,
                              HttpServletResponse response,
                              @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                              @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                                @RequestParam(value = "startdate") String  startdate,
                                @RequestParam(value = "enddate") String  enddate,
                                @RequestBody AttedtlSearchBean searchBean,
                              @AuthenticationPrincipal TOperator operUser) {
        searchBean.setStartdate(startdate);
        searchBean.setEnddate(enddate);
        Map map=new HashMap();
        try {
            Pagination page=null;
            String opertype=operUser.getOpertype();
            String deptcode=operUser.getDeptcode();
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                    deptcode=null;
            }else {
                if(StringUtil.isEmpty(deptcode)){
                    deptcode="-1";
                }
            }
            searchBean.setDeptcode(deptcode);
            page=atteClassService.getPReportWithPage(searchBean,pageNo,pageSize);
            map.put("PageResult",page);
            List<TCustType> custtypelist=systemService.findAllCusttype();
            map.put("custtypelist",custtypelist);
            List<TDept> deptlist=systemService.findAllDept();
            map.put("deptlist",deptlist);
            map.put("operator",operUser);

        }catch (Exception e) {
            e.printStackTrace();
            log.error("查询考勤规则失败：" + e.getMessage());
        }
        return map;
    }


    public static void main(String[] args) {
        String s1=DateUtil.getNow("yyyyMMdd")+"140000";
        String s2=DateUtil.getNow("yyyyMMdd")+"143000";
        long dif=DateUtil.getInterval(s1,s2);
        System.out.println(dif);
        System.out.println((int)(dif/(1000*60)));
    }



}
