package com.supwisdom.dlpay.atte.dao;

import com.supwisdom.dlpay.atte.bean.AtteDtl;
import com.supwisdom.dlpay.atte.bean.AttedtlSearchBean;
import com.supwisdom.dlpay.atte.bean.CustSearchBean;
import com.supwisdom.dlpay.atte.domain.TAtteClass;
import com.supwisdom.dlpay.atte.domain.TAtteDtl;
import com.supwisdom.dlpay.atte.domain.TAtteReview;
import com.supwisdom.dlpay.atte.domain.TClassCust;
import com.supwisdom.dlpay.customer.bean.CustomerSearchBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.system.page.Pagination;

import java.util.List;

public interface AtteClassDao {
    public Pagination getClassWithPage(String classname,String deptcode, int pageNo, int pageSize);

    public TAtteClass getClassById(Integer classid);

    public boolean saveAtteClass(TAtteClass atteClass);

    public TAtteClass getClassByName(String classname);

    public int getMaxClassid();

    public boolean existClass(String deptcode,String startdate, String enddate, int workorno, int exceptid);

    public boolean updateClass(TAtteClass atteClass);

    List<TCustomerInfo> hasClassCust(int classid);

    public TClassCust getByIdAndDate(String custid, String attedate);

    public boolean delClassCustByClassid(Integer classid);

    public boolean addClassCust(TClassCust bean);

    public boolean delClassCust(TClassCust bean);

    //获取考勤流水号
    public String getAtteNo(String attedate);
    //保存流水
    public boolean saveAtteDtl(TAtteDtl dtl);
    //
    //获取排班人员
    public List<TCustomerInfo> getAtteCust(CustSearchBean searchBean);
    //获取考勤明细信息
    public Pagination getAttedtlWithPage(AttedtlSearchBean searchBean,int pageNo,int pageSize);
    //修改明细
    public boolean updateAtteDtl(TAtteDtl dtl);
    //
    public TAtteDtl getDtlByAtteno(String atteno);
    //获取人员信息
    public List<TCustomerInfo> getCustInfo(CustSearchBean searchBean);

    //获取流水
    public Pagination getDtlWithPage(AttedtlSearchBean searchBean,int pageNo,int pageSize);
    //流水
    public List<AtteDtl> getDtlList(AttedtlSearchBean searchBean);
    //删除流水
    public boolean delAtteDtl(String attedate,String deptcode);
    //明细
    public List<TAtteDtl> getDetailList(String custid,String attedate);

    //审核人
    public List<TCustomerInfo> getReviewList(String deptcode);
    //
    public boolean delReview(String deptcode);
    //
    public boolean addReview(TAtteReview reviewer);

    //辅警干警报表
    public Pagination getPReportWithPage(AttedtlSearchBean searchBean,int pageNo,int pageSize);
}
