package com.supwisdom.dlpay.atte.dao.impl;

import com.supwisdom.dlpay.atte.bean.*;
import com.supwisdom.dlpay.atte.dao.AtteClassDao;
import com.supwisdom.dlpay.atte.domain.TAtteClass;
import com.supwisdom.dlpay.atte.domain.TAtteDtl;
import com.supwisdom.dlpay.atte.domain.TAtteReview;
import com.supwisdom.dlpay.atte.domain.TClassCust;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Service
public class AtteClassDaoImpl implements AtteClassDao {
    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public Pagination getClassWithPage(String classname,String deptcode, int pageNo, int pageSize) {
        String sql=" select bean from TAtteClass bean where bean.status=1 ";
        if(!StringUtil.isEmpty(classname)){
            sql+=" and bean.classname like :name ";
        }
        if(!StringUtil.isEmpty(deptcode)){
            sql+=" and bean.deptcode = :dcode ";
        }
        sql+=" order by bean.startdate desc";
        TypedQuery<TAtteClass> query=entityManager.createQuery(sql,TAtteClass.class);
        if(!StringUtil.isEmpty(classname)){
            query.setParameter("name","%"+classname+"%");
        }
        if(!StringUtil.isEmpty(deptcode)){
            query.setParameter("dcode",deptcode);
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TAtteClass> list=query.getResultList();
        page.setList(list);
        int totalCount=getClassCount(classname,deptcode);
        page.setTotalCount(totalCount);
        return page;
    }

    public int getClassCount(String classname,String deptcode){
        String sql=" select count(bean.classid) from TAtteClass bean where bean.status=1 ";
        if(!StringUtil.isEmpty(classname)){
            sql+=" and bean.classname like :name ";
        }
        if(!StringUtil.isEmpty(deptcode)){
            sql+=" and bean.deptcode = :dcode ";
        }
        Query query=entityManager.createQuery(sql);
        if(!StringUtil.isEmpty(classname)){
            query.setParameter("name","%"+classname+"%");
        }
        if(!StringUtil.isEmpty(deptcode)){
            query.setParameter("dcode",deptcode);
        }
         List list=query.getResultList();
        int cnt=0;
        if(list!=null&&list.size()>0){
            cnt=Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public TAtteClass getClassById(Integer classid) {
        String sql="select bean from TAtteClass bean where classid = :cid ";
        if(classid!=null){
            TypedQuery<TAtteClass> query=entityManager.createQuery(sql,TAtteClass.class);
            query.setParameter("cid",classid);
            List<TAtteClass> list=query.getResultList();
            if(list!=null&&list.size()>0){
                return list.get(0);
            }
        }
        return null;
    }
    @Transactional
    @Override
    public boolean saveAtteClass(TAtteClass atteClass) {
        boolean flag=false;

        try {
            entityManager.persist(atteClass);
            flag=true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
    @Transactional
    @Override
    public TAtteClass getClassByName(String classname) {
        String sql=" select bean from TAtteClass bean where bean.status=1 ";
        if(!StringUtil.isEmpty(classname)){
            sql+=" and bean.classname = :name ";
            TypedQuery<TAtteClass> query=entityManager.createQuery(sql,TAtteClass.class);
            query.setParameter("name",classname);
            List<TAtteClass> list=query.getResultList();
            if(list!=null&&list.size()>0){
                return list.get(0);
            }
        }
        return null;
    }
    @Transactional
    @Override
    public int getMaxClassid() {
        String sql=" select max(c.classid) from TAtteClass c";
        Query query=entityManager.createQuery(sql);
        Object object=query.getSingleResult();
        if(object!=null){
            return (int) object;
        }
        return 0;
    }
    @Transactional
    @Override
    public boolean existClass(String deptcode,String startdate, String enddate, int workorno,int exceptid) {
        String sql=" select a from TAtteClass a where a.status=1 and a.deptcode=:dcode and a.workorno= :won and a.classid!=:expid ";
        if(!StringUtil.isEmpty(startdate)&&!StringUtil.isEmpty(enddate)){
            sql+=" and ( (:sdate between a.startdate and a.enddate) or (:edate between a.startdate and a.enddate)  ";
            sql+=" or (:sdate < a.startdate and :edate > a.enddate ) )";
            TypedQuery<TAtteClass> query=entityManager.createQuery(sql,TAtteClass.class);
            query.setParameter("sdate",startdate);
            query.setParameter("edate",enddate);
            query.setParameter("won",workorno);
            query.setParameter("expid",exceptid);
            query.setParameter("dcode",deptcode);
            List<TAtteClass> list=query.getResultList();
            if(list!=null&&list.size()>0){
                return true;
            }
        }
        return false;
    }
    @Transactional
    @Override
    public boolean updateClass(TAtteClass atteClass) {
        boolean flag=false;

        try {
            entityManager.merge(atteClass);
            flag=true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TCustomerInfo> hasClassCust(int classid) {
        String sql = "select a.deptcode,a.custtypeid,a.custid,a.custname,b.cardno,b.bankcardno,b.cardphyid,b.expiredate from T_Customer a left join t_card b on a.custid = b.custid " +
                " where a.status='1' and b.status='normal' and b.transtatus='normal' ";
        sql+= " and exists (select * from t_class_cust t where t.classid = :cid and a.custid=t.custid ) ";
        sql +=" order by b.cardno desc ";
        Query query = entityManager.createNativeQuery(sql, TCustomerInfo.class);
        query.setParameter("cid",classid);
        List<TCustomerInfo> list = query.getResultList();
        return list;
    }
    @Transactional
    @Override
    public TClassCust getByIdAndDate(String custid, String attedate) {
        if(!StringUtil.isEmpty(custid)&&!StringUtil.isEmpty(attedate)){
            String sql=" select bean from TClassCust bean where bean.custid=:cid and bean.attedate = :adate ";
            TypedQuery<TClassCust> query=entityManager.createQuery(sql,TClassCust.class);
            query.setParameter("cid", custid);
            query.setParameter("adate",attedate);
            List<TClassCust> list=query.getResultList();
            if(list!=null&&list.size()>0){
                return list.get(0);
            }
        }
        return null;
    }
    @Transactional
    @Override
    public boolean delClassCustByClassid(Integer classid) {
        if(classid!=null){
            String sql=" delete from TClassCust where classid=:cid ";

            try {
                Query query=entityManager.createQuery(sql);
                query.setParameter("cid",classid);
                query.executeUpdate();
                return true;
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Transactional
    @Override
    public boolean addClassCust(TClassCust bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }
    @Transactional
    @Override
    public boolean delClassCust(TClassCust bean) {
        boolean flag=false;
        try {
            entityManager.remove(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }
    @Transactional
    @Override
    public String getAtteNo(String attedate) {
        String sql=" select to_char(cast(nextval('seq_attedtl') as INTEGER),'FM000000') ";
        Query query=entityManager.createNativeQuery(sql);
        List list=query.getResultList();
        if(list!=null&&list.size()>0){
            String atteno=attedate+list.get(0).toString();
            return atteno;
        }
        return null;
    }
    @Transactional
    @Override
    public boolean saveAtteDtl(TAtteDtl dtl) {
        boolean flag=false;
        try {
            entityManager.persist(dtl);
            flag=true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
    @Transactional
    @Override
    public List<TCustomerInfo> getAtteCust(CustSearchBean searchBean) {
        String sql = "select a.deptcode,a.custtypeid,a.custid,a.custname,b.cardno,b.bankcardno,b.cardphyid,b.expiredate from T_Customer a left join t_card b on a.custid = b.custid " +
                " where a.status='1' and b.status='normal' and b.transtatus='normal' ";
        sql+=" and (EXISTS ( select * from t_atte_rule r where r.status=1 and r.deptcode=a.deptcode and r.custtypeid=cast(a.custtypeid as INTEGER) ) or a.custid in (select custid from t_class_cust where attedate=:adate )  ) ";
        if (!StringUtil.isEmpty(searchBean.getDeptcode())){
            sql +=" and a.deptcode = :dcode ";
        }
        sql +=" order by b.cardno desc ";
        Query query = entityManager.createNativeQuery(sql, TCustomerInfo.class);
        query.setParameter("adate",searchBean.getAttedate());
        if (!StringUtil.isEmpty(searchBean.getDeptcode())){
            query.setParameter("dcode", searchBean.getDeptcode());
        }
        List<TCustomerInfo> list = query.getResultList();
        return list;
    }

    @Override
    public Pagination getAttedtlWithPage(AttedtlSearchBean searchBean, int pageNo, int pageSize) {
        StringBuffer sql=new StringBuffer();
        sql.append(" select t.timeid,t.atteno,t.attedate,t.remark,c.custname,c.custtypeid,b.cardno,t.state,c.deptcode,t.oldstate    from t_atte_dtl t left join t_customer c on t.custid=c.custid ");
            sql.append(" left join t_card b on b.custid=t.custid where c.status='1' and b.status='normal'   ");
            if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
                sql.append(" and t.attedate between :sdate and :edate ");
              }
            if(!StringUtil.isEmpty(searchBean.getCustname())){
                sql.append(" and c.custname like :cname ");
            }
            if(!StringUtil.isEmpty(searchBean.getCardno())){
                sql.append(" and b.cardno like :cno ");
            }
            if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
                sql.append(" and c.custtypeid = :ctypeid ");
            }
            if(!StringUtil.isEmpty(searchBean.getDeptcode())){
                sql.append(" and c.deptcode = :dcode ");
            }
            sql.append(" order by t.atteno desc ");
            Query query=entityManager.createNativeQuery(sql.toString(), AtteDetailInfo.class);
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            query.setParameter("sdate",searchBean.getStartdate());
            query.setParameter("edate",searchBean.getEnddate());
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            query.setParameter("cname","%"+searchBean.getCustname()+"%");
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
            query.setParameter("cno",searchBean.getCardno());
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
           query.setParameter("ctypeid",searchBean.getCusttypeid());
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
            query.setParameter("dcode",searchBean.getDeptcode());
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<AtteDetailInfo> list=query.getResultList();
        page.setList(list);
        int totalCount= getAttedtlCount(searchBean);
        page.setTotalCount(totalCount);
        return page;

    }

    public int getAttedtlCount(AttedtlSearchBean searchBean){
        int result=0;
        StringBuffer sql=new StringBuffer();
        sql.append(" select count(t.atteno)   from t_atte_dtl t left join t_customer c on t.custid=c.custid ");
        sql.append(" left join t_card b on b.custid=t.custid where c.status='1' and b.status='normal'  ");
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            sql.append(" and t.attedate between :sdate and :edate ");
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            sql.append(" and c.custname like :cname ");
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
            sql.append(" and b.cardno like :cno ");
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
            sql.append(" and c.custtypeid = :ctypeid ");
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
            sql.append(" and c.deptcode = :dcode");
        }
        Query query=entityManager.createNativeQuery(sql.toString());
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            query.setParameter("sdate",searchBean.getStartdate());
            query.setParameter("edate",searchBean.getEnddate());
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            query.setParameter("cname","%"+searchBean.getCustname()+"%");
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
            query.setParameter("cno",searchBean.getCardno());
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
            query.setParameter("ctypeid",searchBean.getCusttypeid());
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
            query.setParameter("dcode",searchBean.getDeptcode());
        }
        Object object=query.getSingleResult();
        if(object!=null){
            result= Integer.parseInt(object.toString());
        }
        return result;
    }

    @Transactional
    @Override
    public boolean updateAtteDtl(TAtteDtl dtl) {
        boolean flag=false;
        try {
            entityManager.merge(dtl);
            flag=true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    public TAtteDtl getDtlByAtteno(String atteno) {
        if(StringUtil.isEmpty(atteno)){
            return null;
        }
        String sql=" select bean from TAtteDtl bean where atteno = :ano ";
        TypedQuery<TAtteDtl> query=entityManager.createQuery(sql,TAtteDtl.class);
        query.setParameter("ano",atteno);
        List<TAtteDtl> list=query.getResultList();
        if(list!=null&&list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<TCustomerInfo> getCustInfo(CustSearchBean searchBean) {
        String sql = "select a.deptcode,a.custtypeid,a.custid,a.custname,b.cardno,b.bankcardno,b.cardphyid,b.expiredate from T_Customer a left join t_card b on a.custid = b.custid " +
                " where a.status='1' and b.status='normal' and b.transtatus='normal' ";
        if (!StringUtil.isEmpty(searchBean.getCustname())){
            sql += " and a.custname like :perName ";
        }
        if (!StringUtil.isEmpty(searchBean.getDeptcode())){
            sql +=" and a.deptcode = :dcode ";
        }
        if (!StringUtil.isEmpty(searchBean.getCusttypeid())){
            sql +=" and a.custtypeid = :ctypeid ";
        }
        sql +=" order by b.cardno desc ";
        Query query = entityManager.createNativeQuery(sql, TCustomerInfo.class);
        if (!StringUtil.isEmpty(searchBean.getCustname())){
            query.setParameter("perName", "%"+searchBean.getCustname()+"%");
        }
        if (!StringUtil.isEmpty(searchBean.getDeptcode())){
            query.setParameter("dcode", searchBean.getDeptcode());
        }
        if (!StringUtil.isEmpty(searchBean.getCusttypeid())){
            query.setParameter("ctypeid", Integer.parseInt(searchBean.getCusttypeid()));
        }
        List<TCustomerInfo> list = query.getResultList();
        return list;
    }

    @Override
    public Pagination getDtlWithPage(AttedtlSearchBean searchBean, int pageNo, int pageSize) {
        String sql=" select v.transdate attedate,v.transtime attetime,v.doorseqno refno,v.custname,v.custid,c.custtypeid,d.devname devicename,d.deviceid,v.cardno,c.deptcode " ;
        sql+=" from v_atte_dtl v left join t_nc_device d on cast( v.deviceid as INTEGER) = d.deviceid left join t_customer c on c.custid=v.custid where 1=1 ";
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            sql+=" and v.transdate between :sdate and :edate ";
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            sql+="  and v.custname like :cname ";
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
            sql+="  and c.custtypeid = :ctypeid ";
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
            sql+="  and c.deptcode = :dcode ";
        }
        if(!StringUtil.isEmpty(searchBean.getDevname())){
            sql+="  and d.devname like :dname";
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
            sql+="  and v.cardno like :cno ";
        }
        sql+=" order by v.transdate desc,v.transtime desc";
        Query query=entityManager.createNativeQuery(sql, AtteDtl.class);
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            query.setParameter("sdate",searchBean.getStartdate());
            query.setParameter("edate",searchBean.getEnddate());
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            query.setParameter("cname","%"+searchBean.getCustname()+"%");
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
            query.setParameter("ctypeid",Integer.parseInt(searchBean.getCusttypeid()));
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
            query.setParameter("dcode",searchBean.getDeptcode());
        }
        if(!StringUtil.isEmpty(searchBean.getDevname())){
            query.setParameter("dname",searchBean.getDevname());
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
            query.setParameter("cno",searchBean.getCardno());
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<AtteDtl> list=query.getResultList();
        page.setList(list);
        int totalCount= getDtlCount(searchBean);
        page.setTotalCount(totalCount);
        return page;
    }

    public int getDtlCount(AttedtlSearchBean searchBean){
        String sql=" select v.transdate attedate,v.transtime attetime,v.doorseqno refno,v.custname,v.custid,c.custtypeid,d.devname devicename,d.deviceid,v.cardno,c.deptcode " ;
        sql+=" from v_atte_dtl v left join t_nc_device d on cast( v.deviceid as INTEGER) = d.deviceid left join t_customer c on c.custid=v.custid where 1=1 ";
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            sql+=" and v.transdate between :sdate and :edate ";
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            sql+="  and v.custname like :cname ";
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
            sql+="  and c.custtypeid = :ctypeid ";
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
            sql+="  and c.deptcode = :dcode ";
        }
        if(!StringUtil.isEmpty(searchBean.getDevname())){
            sql+="  and d.devname like :dname";
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
            sql+="  and v.cardno like :cno ";
        }
        sql+=" order by v.doorseqno ";
        Query query=entityManager.createNativeQuery(sql, AtteDtl.class);
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            query.setParameter("sdate",searchBean.getStartdate());
            query.setParameter("edate",searchBean.getEnddate());
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            query.setParameter("cname","%"+searchBean.getCustname()+"%");
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
            query.setParameter("ctypeid",Integer.parseInt(searchBean.getCusttypeid()));
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
            query.setParameter("dcode",searchBean.getDeptcode());
        }
        if(!StringUtil.isEmpty(searchBean.getDevname())){
            query.setParameter("dname",searchBean.getDevname());
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
            query.setParameter("cno",searchBean.getCardno());
        }
        List<AtteDtl> list=query.getResultList();
        if(list!=null){
            return list.size();
        }
        return 0;
    }

    @Override
    public boolean delAtteDtl(String attedate, String deptcode) {
        if(!StringUtil.isEmpty(attedate)){
            String sql=" delete from t_atte_dtl t  where t.attedate=:adate ";
             if(!StringUtil.isEmpty(deptcode)){
                 sql+=" and t.custid in (select c.custid from t_customer c where c.deptcode = :dcode )";
             }
            try {
                Query query=entityManager.createNativeQuery(sql);
                if(!StringUtil.isEmpty(deptcode)){
                    query.setParameter("dcode",deptcode);
                }
                query.setParameter("adate",attedate);
                query.executeUpdate();
                return true;
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public List<AtteDtl> getDtlList(AttedtlSearchBean searchBean) {
        String sql=" select v.transdate attedate,v.transtime attetime,v.doorseqno refno,v.custname,v.custid,c.custtypeid,d.devname devicename,d.deviceid,v.cardno,c.deptcode " ;
        sql+=" from v_atte_dtl v left join t_nc_device d on cast( v.deviceid as INTEGER) = d.deviceid left join t_customer c on c.custid=v.custid where 1=1 ";
        sql+=" and exists (select DISTINCT r.deviceid from t_dev_rule r where r.deviceid=cast(v.deviceid as INTEGER) and r.ruleid in (select ar.id from t_atte_rule ar where ar.custtypeid=cast(c.custtypeid as INTEGER) and ar.deptcode=c.deptcode and ar.status=1 )) ";
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            sql+=" and v.transdate between :sdate and :edate ";
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            sql+="  and v.custname like :cname ";
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
            sql+="  and c.custtypeid = :ctypeid ";
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
            sql+="  and c.deptcode = :dcode ";
        }
        if(!StringUtil.isEmpty(searchBean.getDevname())){
            sql+="  and d.devname like :dname";
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
            sql+="  and v.cardno like :cno ";
        }
        sql+=" order by v.doorseqno ";
        Query query=entityManager.createNativeQuery(sql, AtteDtl.class);
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            query.setParameter("sdate",searchBean.getStartdate());
            query.setParameter("edate",searchBean.getEnddate());
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            query.setParameter("cname","%"+searchBean.getCustname()+"%");
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
            query.setParameter("ctypeid",Integer.parseInt(searchBean.getCusttypeid()));
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
            query.setParameter("dcode",searchBean.getDeptcode());
        }
        if(!StringUtil.isEmpty(searchBean.getDevname())){
            query.setParameter("dname",searchBean.getDevname());
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
            query.setParameter("cno",searchBean.getCardno());
        }

        List<AtteDtl> list=query.getResultList();

        return list;
    }

    @Override
    public List<TAtteDtl> getDetailList(String custid,String attedate) {
        if(StringUtil.isEmpty(custid)||StringUtil.isEmpty(attedate)){
            return null;
        }
        String sql=" select bean from TAtteDtl bean where bean.status=1 and  bean.attedate= :adate and bean.custid= :cid ";

        Query query=entityManager.createQuery(sql,TAtteDtl.class);
        query.setParameter("adate",attedate);
        query.setParameter("cid",custid);

        List<TAtteDtl> list=query.getResultList();

        return list;
    }

    @Override
    public List<TCustomerInfo> getReviewList(String deptcode) {
        String sql = "select a.deptcode,a.custtypeid,a.custid,a.custname,b.cardno,b.bankcardno,b.cardphyid,b.expiredate from T_Customer a left join t_card b on a.custid = b.custid " +
                " where a.status='1' and b.status='normal' and b.transtatus='normal' ";
        sql+= " and a.custid in ( select custid from t_atte_review ) ";
        if(!StringUtil.isEmpty(deptcode)){
            sql+=" and a.deptcode= :dcode ";
        }
        sql +=" order by b.cardno desc ";
        Query query = entityManager.createNativeQuery(sql, TCustomerInfo.class);
        if(!StringUtil.isEmpty(deptcode)){
            query.setParameter("dcode",deptcode);
        }
        List<TCustomerInfo> list = query.getResultList();
        return list;
    }

    @Override
    public boolean delReview(String deptcode) {
            String sql=" delete from TAtteReview where custid in (select custid from TCustomer where 1=1  ";
            if(!StringUtil.isEmpty(deptcode)){
                sql+=" and deptcode = :dcode";
            }
            sql+=" ) ";
            try {
                Query query=entityManager.createQuery(sql);
                if(!StringUtil.isEmpty(deptcode)){
                    query.setParameter("dcode",deptcode);
                }
                query.executeUpdate();
                return true;
            } catch (Exception e) {
                e.printStackTrace();
            }

        return false;
    }

    @Override
    public boolean addReview(TAtteReview reviewer) {
        boolean flag=false;
        try {
            entityManager.persist(reviewer);
            flag=true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    public Pagination getPReportWithPage(AttedtlSearchBean searchBean, int pageNo, int pageSize) {
        StringBuffer sql=new StringBuffer();
        sql.append(" with a as ( select v.*,c.cardno from v_atte_info v left join t_card c on v. custid=c.custid    ")
            .append(" where  c.status='normal' and c.transtatus='normal' ");
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            sql.append(" and v.attedate between :sdate and :edate ");
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            sql.append("  and v.custname like :cname ");
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
            sql.append("  and v.custtypeid = :ctypeid ");
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
            sql.append("  and v.deptcode = :dcode ");
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
            sql.append("  and v.cardno like :cno ");
        }
        sql.append(" ) select a.custid,a.custname,a.cardno,a.custtypeid,a.deptcode, ")
        .append(" (select count(*) from v_atte_info where custid=a.custid  ) cnts,")
                .append(" (select count(*) from v_atte_info where custid=a.custid and state=1) cnt1,")
                .append(" (select count(*) from v_atte_info where custid=a.custid and state=2) cnt2,")
                .append(" (select count(*) from v_atte_info where custid=a.custid and state=3) cnt3,")
                .append(" (select count(*) from v_atte_info where custid=a.custid and state=0) cnt4")
        .append(" from a group by a.custname,a.cardno,a.custtypeid,a.deptcode,a.custid ")
         .append(" order by a.deptcode desc ,a.custtypeid desc ");
        Query query=entityManager.createNativeQuery(sql.toString(), AtteReport.class);
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            query.setParameter("sdate",searchBean.getStartdate());
            query.setParameter("edate",searchBean.getEnddate());
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            query.setParameter("cname",searchBean.getCustname());
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
           query.setParameter("ctypeid",searchBean.getCusttypeid());
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
           query.setParameter("dcode",searchBean.getDeptcode());
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
           query.setParameter("cno",searchBean.getCardno());
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<AtteReport> list=query.getResultList();
        page.setList(list);
        int totalCount= getPReportCount(searchBean);
        page.setTotalCount(totalCount);
        return page;
    }

    public int getPReportCount(AttedtlSearchBean searchBean){
        StringBuffer sql=new StringBuffer();
        sql.append(" with a as ( select v.* from v_atte_info v left join t_card c on v. custid=c.custid    ")
                .append(" where  c.status='normal' and c.transtatus='normal' ");
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            sql.append(" and v.attedate between :sdate and :edate ");
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            sql.append("  and v.custname like :cname ");
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
            sql.append("  and v.custtypeid = :ctypeid ");
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
            sql.append("  and v.deptcode = :dcode ");
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
            sql.append("  and v.cardno like :cno ");
        }
        sql.append(" ),  b as ( select distinct custid from a ) ")
                .append("select count(*) from b ");
        Query query=entityManager.createNativeQuery(sql.toString());
        if(!StringUtil.isEmpty(searchBean.getStartdate())&&!StringUtil.isEmpty(searchBean.getEnddate())){
            query.setParameter("sdate",searchBean.getStartdate());
            query.setParameter("edate",searchBean.getEnddate());
        }
        if(!StringUtil.isEmpty(searchBean.getCustname())){
            query.setParameter("cname",searchBean.getCustname());
        }
        if(!StringUtil.isEmpty(searchBean.getCusttypeid())){
            query.setParameter("ctypeid",searchBean.getCusttypeid());
        }
        if(!StringUtil.isEmpty(searchBean.getDeptcode())){
            query.setParameter("dcode",searchBean.getDeptcode());
        }
        if(!StringUtil.isEmpty(searchBean.getCardno())){
            query.setParameter("cno",searchBean.getCardno());
        }
        int result=0;
        Object object=query.getSingleResult();
        if(object!=null){
            result= Integer.parseInt(object.toString());
        }
        return result;
    }
}
