package com.supwisdom.dlpay.atte.dao.impl;

import com.supwisdom.dlpay.atte.dao.CustseaDao;
import com.supwisdom.dlpay.atte.domain.TDevCusttype;
import com.supwisdom.dlpay.atte.domain.TSeaCusttype;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class CustseaDaoImpl implements CustseaDao {
    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public Pagination getCustseaWithPage(String custtypename, int pageNo, int pageSize) {
        StringBuffer sql=new StringBuffer(" select c.custtypeid,t.id,t.updatetime    from tb_custtype c left join t_sea_custtype t on c.custtypeid=t.custtypeid where 1=1 ");
        if(!StringUtil.isEmpty(custtypename)){
            sql.append("  and c.custtypename like :name ");
        }
        Query query=entityManager.createNativeQuery(sql.toString(), TSeaCusttype.class);
        if (!StringUtil.isEmpty(custtypename)){
            query.setParameter("name","%"+custtypename+"%");
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TSeaCusttype> list=query.getResultList();
        page.setList(list);
        int totalCount=getCustseaCount(custtypename);
        page.setTotalCount(totalCount);
        return page;
    }
    private int getCustseaCount(String custtypename){
        String sql=" select count(custtypeid) from tb_custtype where 1=1 ";
        if (!StringUtil.isEmpty(custtypename)){
            sql+=" and custtypename like :name ";
        }
        Query query=entityManager.createNativeQuery(sql);
        if (!StringUtil.isEmpty(custtypename)){
            query.setParameter("name","%"+custtypename+"%");
        }
        int cnt=0;
        List list=query.getResultList();
        if(list!=null && list.size()>0){
            cnt=Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public TSeaCusttype getCustseaById(Integer custtypeid) {
        String sql=" select c.custtypeid,t.id,t.updatetime    from tb_custtype c left join t_sea_custtype t on c.custtypeid=t.custtypeid where c.custtypeid=:cid ";
        Query query=entityManager.createNativeQuery(sql,TSeaCusttype.class);
        query.setParameter("cid",custtypeid);
        List<TSeaCusttype> list=query.getResultList();
        return list.size()==0?null:list.get(0);
    }
    @Transactional
    @Override
    public boolean updateCustsea(TSeaCusttype tSeaCusttype) {
        boolean flag=false;

        try {
            entityManager.merge(tSeaCusttype);
            flag=true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public boolean saveCustsea(TSeaCusttype tSeaCusttype) {
        boolean flag=false;
        try {
            entityManager.persist(tSeaCusttype);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }
    @Transactional
    @Override
    public boolean exist(Integer custtypeid) {
        String sql=" select count(custtypeid) from t_sea_custtype where custtypeid=:sid ";
        Query query=entityManager.createNativeQuery(sql);
        query.setParameter("sid",custtypeid);
        List list=query.getResultList();
        int cnt=0;
        if(list!=null&&list.size()>0){
            cnt= Integer.parseInt(list.get(0).toString());
        }
        if(cnt>0){
            return true;
        }
        return false;
    }

    @Transactional
    @Override
    public List<TNcDevice> getAllCanAssign(Integer ruleid,String devname,String devtype) {
        String sql=" select * from t_nc_device c where c.operflag='A' and  "+
                " c.deviceid not in (select deviceid from t_dev_rule where ruleid= :rid ) ";
        if(!StringUtil.isEmpty(devname)){
            sql+= " and c.devname like :cname ";
        }
        if(!StringUtil.isEmpty(devtype)){
            sql+=" and c.devtype = :ctype ";
        }
        sql+= " order by c.deviceid ";
        Query query=entityManager.createNativeQuery(sql,TNcDevice.class);
        query.setParameter("rid",ruleid);
        if(!StringUtil.isEmpty(devname)){
           query.setParameter("cname","%"+devname+"%");
        }
        if(!StringUtil.isEmpty(devtype)){
            query.setParameter("ctype",devtype);
        }
        List<TNcDevice> list=query.getResultList();
        return list;
    }
    @Transactional
    @Override
    public List<TNcDevice> getAllDevByCusttype(Integer ruleid) {
        String sql=" select * from t_nc_device c left join t_dev_rule t on c.deviceid=t.deviceid  where 1=1";
         if (ruleid!=null){
             sql+="  and t.ruleid = :typeid ";
         }
         sql+= " order by c.deviceid ";
         Query query=entityManager.createNativeQuery(sql,TNcDevice.class);
        if (ruleid!=null){
            query.setParameter("typeid",ruleid);
        }
         List<TNcDevice> list=query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public boolean deleteDevRuleid(Integer ruleid) {
        String sql=" delete from TDevCusttype where ruleid =:rid ";
        if(ruleid!=null){

            Query query= null;
            try {
                query = entityManager.createQuery(sql);
                query.setParameter("rid",ruleid);
                query.executeUpdate();
                return true;
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
    @Transactional
    @Override
    public boolean addDevRuleid(TDevCusttype bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return false;
    }
}
