package com.supwisdom.dlpay.atte.dao.impl;

import com.supwisdom.dlpay.atte.dao.SeasonDao;
import com.supwisdom.dlpay.atte.domain.TSeason;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class SeasondaoImpl implements SeasonDao {
    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public Pagination getSeasonWithPage(String season,String deptcode, int pageNo, int pageSize) {
        String sql=" select bean from TSeason bean where bean.status!=0 ";
        if(!StringUtil.isEmpty(season)){
            sql+= " and bean.season like :name ";
        }
        if(!StringUtil.isEmpty(deptcode)){
            sql+= " and bean.deptcode= :dcode ";
        }
        sql+=" order by bean.id ";
        TypedQuery<TSeason> query=entityManager.createQuery(sql,TSeason.class);
        if(!StringUtil.isEmpty(season)){
            query.setParameter("name","%"+season+"%");
        }
        if(!StringUtil.isEmpty(deptcode)){
            query.setParameter("dcode",deptcode);;
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TSeason> list=query.getResultList();
        page.setList(list);
        int totalCount=getSeasonCount(season,deptcode);
        page.setTotalCount(totalCount);
        return page;
    }

    @Transactional
    @Override
    public TSeason getSeasonById(Integer id) {
        String sql="select bean from TSeason bean where status!=0 and id = :sid";
        TypedQuery<TSeason> query=entityManager.createQuery(sql,TSeason.class);
        query.setParameter("sid",id);
        List<TSeason> list=query.getResultList();
        return list.size()==0?null:list.get(0);
    }

    private int getSeasonCount(String season,String deptcode){
        String sql=" select count(bean.id) from TSeason bean where bean.status!=0 ";
        if(!StringUtil.isEmpty(season)){
            sql+= " and bean.season like :name ";
        }
        if(!StringUtil.isEmpty(deptcode)){
            sql+= " and bean.deptcode= :dcode ";
        }
        Query query = entityManager.createQuery(sql);
        if(!StringUtil.isEmpty(season)){
            query.setParameter("name","%"+season+"%");
        }
        if(!StringUtil.isEmpty(deptcode)){
            query.setParameter("dcode",deptcode);;
        }
        int cnt = 0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public TSeason findBySeason(String season) {
        String sql=" select bean from TSeason bean where bean.season=:name ";
        TypedQuery<TSeason> query=entityManager.createQuery(sql,TSeason.class);
         query.setParameter("name",season);
         List<TSeason> list=query.getResultList();
         if(list!=null&&list.size()>0){
             return list.get(0);
         }
        return null;
    }

    @Transactional
    @Override
    public boolean saveSeason(TSeason season) {
        boolean flag=false;
        try {
            entityManager.persist(season);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public int getMaxSeasonId() {
        String sql=" select max(s.id) from TSeason s ";
        Query query=entityManager.createQuery(sql);
        Object result=query.getSingleResult();
        if(result!=null){
            return (int)result;
        }
        return 0;
    }

    @Transactional
    @Override
    public TSeason getSeasonByIdAndName(Integer id, String season) {
        String sql="select bean from TSeason bean where 1=1 and id <>:sid ";
        if (!StringUtil.isEmpty(season)){
            sql+= " and bean.season = :name";
        }
        TypedQuery<TSeason> query=entityManager.createQuery(sql,TSeason.class);
        query.setParameter("sid",id);
        if(!StringUtil.isEmpty(season)){
            query.setParameter("name",season);
        }
        List<TSeason> list=query.getResultList();
        if(list!=null&&list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateSeason(TSeason season) {
        boolean flag=false;

        try {
            entityManager.merge(season);
            flag=true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
    @Transactional
    @Override
    public boolean deleteSeason(int id) {
        boolean flag=false;

        try {
            String sql=" update t_atte_rule  set status=0 where id = ?1 ";
            Query query=entityManager.createNativeQuery(sql);
            query.setParameter(1,id);
            query.executeUpdate();
            flag=true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TSeason> findAllSeason() {
        String sql=" select bean from TSeason bean where status=1 ";
        TypedQuery<TSeason> query=entityManager.createQuery(sql,TSeason.class);
        List<TSeason> list=query.getResultList();
        return list;
    }
    @Transactional
    @Override
    public TSeason getOpenRule(Integer custtypid, String deptcode) {
        String sql=" select bean from TSeason  bean where bean.status=1 ";
        if(custtypid!=null){
            sql+=" and bean.custtypeid =:ctypeid ";
        }
        if(!StringUtil.isEmpty(deptcode)){
            sql+=" and bean.deptcode = :dcode";
        }
        TypedQuery<TSeason> query=entityManager.createQuery(sql,TSeason.class);

        if(custtypid!=null){
            query.setParameter("ctypeid",custtypid);
        }
        if(!StringUtil.isEmpty(deptcode)){
            query.setParameter("dcode",deptcode);
        }
        List<TSeason> list=query.getResultList();
        if(list!=null&&list.size()>0){
            return list.get(0);
        }
        return null;
    }
}
