package com.supwisdom.dlpay.atte.service;

import com.supwisdom.dlpay.atte.bean.AtteDtl;
import com.supwisdom.dlpay.atte.bean.AttedtlSearchBean;
import com.supwisdom.dlpay.atte.domain.TAtteClass;
import com.supwisdom.dlpay.atte.domain.TAtteDtl;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


public interface AtteClassService {
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getClassWithPage(String classname,String deptcode, int pageNo, int pageSize);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TAtteClass getClassById(Integer classid);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveAtteClass(TAtteClass atteClass);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TAtteClass getClassByName(String classname);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public int getMaxClassid();

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean canAddClass(String deptcode,int workorno,String startdate,String enddate,int exceptid);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateClass(TAtteClass atteClass);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TCustomerInfo> hasClassCust(Integer classid);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TCustomerInfo> getAllCustomer(String perName, String deptcode, String custtypeid);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean addClassCust(Integer classid,List<String> custidlist);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean deleteAtteClass(Integer classid);

    //生成考勤名单  attedate
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean createAtteDtl(String attedate,String deptcode);

    //查询考勤明细信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getAtteDtlInfoWithPage(AttedtlSearchBean searchBean,int pageNo,int pageSize);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateAtteDtl(TAtteDtl dtl);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TAtteDtl getDtlByAtteno(String atteno);

    //批量生产考勤名单
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean addBatchDtl(String startdate,String enddate,String deptcode);

    //查询考勤流水信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getDtlWithPage(AttedtlSearchBean searchBean,int pageNo,int pageSize);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<AtteDtl> getDtlList(AttedtlSearchBean searchBean);

    //处理考勤流水
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean handleDtl(String deptcode,String attedate);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TCustomerInfo> getReviewList(String deptcode);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean addReview(String deptcode,String opercode,List<String> custidlist);

    // 考勤报表
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getPReportWithPage(AttedtlSearchBean searchBean,int pageNo,int pageSize);
}
