package com.supwisdom.dlpay.atte.service;

import com.supwisdom.dlpay.atte.domain.TSeaCusttype;
import com.supwisdom.dlpay.atte.domain.TSeason;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface CustseaService {

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getCustseaWithPage(String custtypename, int pageNo, int pageSize);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TSeaCusttype getCustseaById(Integer custtypeid);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateCustsea(TSeaCusttype tSeaCusttype);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveCustsea(TSeaCusttype tSeaCusttype);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean exist(Integer custtypeid);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcDevice> getAllCanAssign(Integer ruleid,String devname,String devtype);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcDevice> getAllDevByCusttype(Integer ruleid);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public void assignDevRule(String ids,String ruleid);


}
