package com.supwisdom.dlpay.atte.service;

import com.supwisdom.dlpay.atte.domain.TSeason;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface SeasonService {
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getSeasonWithPage(String season,String deptcode,int pageNo, int pageSize);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TSeason getSeasonById(Integer id);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TSeason findBySeason(String season);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveSeason(TSeason season);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public int getMaxSeasonId();

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TSeason findSeasonByIdAndName(Integer id,String season);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateSeason(TSeason season);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean deleteSeason(int id);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TSeason> findAllSeason();

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean stoporopen(Integer id);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TSeason getOpenRule(Integer custtypeid,String deptcode);
}
