package com.supwisdom.dlpay.atte.service.impl;

import com.supwisdom.dlpay.atte.bean.AtteDtl;
import com.supwisdom.dlpay.atte.bean.AttedtlSearchBean;
import com.supwisdom.dlpay.atte.bean.CustSearchBean;
import com.supwisdom.dlpay.atte.dao.AtteClassDao;
import com.supwisdom.dlpay.atte.dao.CustseaDao;
import com.supwisdom.dlpay.atte.dao.SeasonDao;
import com.supwisdom.dlpay.atte.domain.*;
import com.supwisdom.dlpay.atte.service.AtteClassService;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.dao.BusinessparaDao;
import com.supwisdom.dlpay.framework.domain.TBusinesspara;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.dao.CustomerDao;
import com.supwisdom.dlpay.ncmgr.dao.NcTimeDao;
import com.supwisdom.dlpay.ncmgr.dao.NcTimeGrpDao;
import com.supwisdom.dlpay.ncmgr.dao.NcWeekTimeDao;
import com.supwisdom.dlpay.ncmgr.domain.TNcTime;
import com.supwisdom.dlpay.ncmgr.domain.TNcTimegrp;
import com.supwisdom.dlpay.ncmgr.domain.TNcWeektime;
import com.supwisdom.dlpay.system.domain.TCustType;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class AtteClassServiceImpl implements AtteClassService {
    @Autowired
    AtteClassDao atteClassDao;
    @Autowired
    CustomerDao customerDao;
    @Autowired
    CustseaDao custseaDao;
    @Autowired
    SeasonDao seasonDao;
    @Autowired
     NcTimeGrpDao ncTimeGrpDao;
    @Autowired
     NcWeekTimeDao ncWeekTimeDao;
    @Autowired
    NcTimeDao ncTimeDao;
    @Autowired
    private SystemService systemService;
    @Autowired
    private BusinessparaDao businessparaDao;

    @Override
    public Pagination getClassWithPage(String classname,String deptcode, int pageNo, int pageSize) {
        return atteClassDao.getClassWithPage(classname,deptcode,pageNo,pageSize);
    }

    @Override
    public TAtteClass getClassById(Integer classid) {
        return atteClassDao.getClassById(classid);
    }

    @Override
    public boolean saveAtteClass(TAtteClass atteClass) {
        return atteClassDao.saveAtteClass(atteClass);
    }

    @Override
    public TAtteClass getClassByName(String classname) {
        return atteClassDao.getClassByName(classname);
    }

    @Override
    public int getMaxClassid() {
        return atteClassDao.getMaxClassid();
    }

    @Override
    public boolean canAddClass(String deptcode,int workorno, String startdate, String enddate,int exceptid) {
        if(StringUtil.isEmpty(startdate)||StringUtil.isEmpty(enddate)){
            return false;
        }
        if(atteClassDao.existClass(deptcode,startdate,enddate,workorno,exceptid)){
            return false;
        }
        return true;
    }

    @Override
    public boolean updateClass(TAtteClass atteClass) {
        return atteClassDao.updateClass(atteClass);
    }

    @Override
    public List<TCustomerInfo> hasClassCust(Integer classid) {
        if(classid==null){
            return null;
        }
        return atteClassDao.hasClassCust(classid);
    }

    @Override
    public List<TCustomerInfo> getAllCustomer(String perName, String deptcode, String custtypeid) {
        CustSearchBean searchBean=new CustSearchBean();
        searchBean.setCusttypeid(custtypeid);
        searchBean.setDeptcode(deptcode);
        searchBean.setCustname(perName);
        return atteClassDao.getCustInfo(searchBean);
    }

    @Override
    public boolean addClassCust(Integer classid, List<String> custidlist) {
            TAtteClass atteClass=getClassById(classid);
            if(atteClass==null){
                return false;
            }
            atteClassDao.delClassCustByClassid(classid);
            String sdate=atteClass.getStartdate();
            String edate=atteClass.getEnddate();
            Integer start=Integer.parseInt(sdate);
            Integer end=Integer.parseInt(edate);
            while (start<=end){
                for (String custid:custidlist){
                    TClassCust oldbean=atteClassDao.getByIdAndDate(custid,sdate);
                    if(oldbean!=null){
                        atteClassDao.delClassCust(oldbean);
                    }
                    TClassCust newbean=new TClassCust();
                    newbean.setClassid(classid);
                    newbean.setAttedate(sdate);
                    newbean.setCustid(custid);
                    atteClassDao.addClassCust(newbean);
                }
                sdate= DateUtil.getNewDay(sdate,1);
                start=Integer.parseInt(sdate);
            }
            atteClass.setUpdatetime(DateUtil.getNow());
            atteClassDao.updateClass(atteClass);
        return true;
    }

    @Override
    public boolean deleteAtteClass(Integer classid) {
        TAtteClass atteClass=atteClassDao.getClassById(classid);
        if(atteClass==null){
            return false;
        }
        atteClass.setStatus(0); // 1-正常 0-删除
        atteClass.setUpdatetime(DateUtil.getNow());
        atteClassDao.updateClass(atteClass); //删除班次
        atteClassDao.delClassCustByClassid(classid); //删除班次绑定的人员
        return true;
    }


    /**
     *   生成考勤人员名单
     */

    @Override
    public boolean createAtteDtl(String attedate,String deptcode) {
      if(StringUtil.isEmpty(attedate)){
          return false;
      }
      //删除原流水
        atteClassDao.delAtteDtl(attedate,deptcode);
        CustSearchBean searchBean=new CustSearchBean();
        searchBean.setDeptcode(deptcode);
        searchBean.setAttedate(attedate);
        // 获取考勤人员
        List<TCustomerInfo> custlist=atteClassDao.getAtteCust(searchBean);

        for (TCustomerInfo cust:custlist){
            TClassCust classCust=atteClassDao.getByIdAndDate(cust.getCustid(),attedate);
            TNcTimegrp timegrp=null;
            TAtteClass atteClass=null;
            if(classCust==null){
                // 无排班
              Integer timegrpid=getTimegrp(cust,attedate);
                if(timegrpid!=null){
                    timegrp=ncTimeGrpDao.findByTimeGrpId(timegrpid);
                }
            }else{

                atteClass=atteClassDao.getClassById(classCust.getClassid());
                if(atteClass!=null&&atteClass.getWorkorno()==1){
                    timegrp=ncTimeGrpDao.findByTimeGrpId(atteClass.getTimegrpid());
                }

            }

            if(timegrp==null){
                continue;
            }
            Map<Integer,Integer> map=new HashMap<>();
            map.put(timegrp.getTimeid1(),timegrp.getTimeid1());
            map.put(timegrp.getTimeid2(),timegrp.getTimeid2());
            map.put(timegrp.getTimeid3(),timegrp.getTimeid3());
            map.put(timegrp.getTimeid4(),timegrp.getTimeid4());
            map.put(timegrp.getTimeid5(),timegrp.getTimeid5());
            map.put(timegrp.getTimeid6(),timegrp.getTimeid6());
            for(Integer timeid:map.keySet()){
                if(timeid!=null){
                    TAtteDtl dtl=new TAtteDtl();
                    dtl.setAttedate(attedate);
                    dtl.setAtteno(atteClassDao.getAtteNo(attedate));
                    dtl.setCustid(cust.getCustid());
                    dtl.setState(0);
                    dtl.setStatus(1);
                    dtl.setTimeid(timeid);
                    dtl.setUpdatetime(DateUtil.getNow());
                    atteClassDao.saveAtteDtl(dtl);
                }
            }

        }
        return true;
    }

    private Integer getTimegrp(TCustomerInfo cust,String attedate){
        Integer timegrpid=null;
        if(cust.getCusttypeid()==null||StringUtil.isEmpty(cust.getDeptcode())){
            return timegrpid;
        }
        TSeason season=seasonDao.getOpenRule(cust.getCusttypeid(),cust.getDeptcode());
        if(season==null&&season.getWeekid()==null){
            return timegrpid;
        }
        TNcWeektime weektime=ncWeekTimeDao.findByWeekTimeId(season.getWeekid());
        if(weektime==null){
            return timegrpid;
        }
        int weekday=DateUtil.getWeekday(attedate);
        switch (weekday){
            case 1:
                timegrpid=weektime.getDay1grpid();
                break;
            case 2:
                timegrpid=weektime.getDay2grpid();
                break;
            case 3:
                timegrpid=weektime.getDay3grpid();
                break;
            case 4:
                timegrpid=weektime.getDay4grpid();
                break;
            case 5:
                timegrpid=weektime.getDay5grpid();
                break;
            case 6:
                timegrpid=weektime.getDay6grpid();
                break;
            case 7:
                timegrpid=weektime.getDay7grpid();
                break;
            default:
                timegrpid=0;
                    break;
        }
        return timegrpid;

    }

    /**   HHmmss
     *  获取时差 （min）
     *
     */
    public int getDiffMin(String starttime,String endtime){
        String stime=DateUtil.getNow("yyyyMMdd")+starttime;
        String etime=DateUtil.getNow("yyyyMMdd")+endtime;
        long diff=DateUtil.getInterval(stime,etime); // 毫秒
        int min= (int) (diff/(1000*60));
            return min;
    }

    @Override
    public Pagination getAtteDtlInfoWithPage(AttedtlSearchBean searchBean, int pageNo, int pageSize) {
        return atteClassDao.getAttedtlWithPage(searchBean,pageNo,pageSize);
    }

    @Override
    public boolean updateAtteDtl(TAtteDtl dtl) {
        return atteClassDao.updateAtteDtl(dtl);
    }

    @Override
    public TAtteDtl getDtlByAtteno(String atteno) {
        return atteClassDao.getDtlByAtteno(atteno);
    }


    @Override
    public boolean addBatchDtl(String startdate, String enddate, String deptcode) {
        Integer start=Integer.parseInt(startdate);
        Integer end=Integer.parseInt(enddate);
        while (start<=end){
            createAtteDtl(startdate,deptcode);
            startdate= DateUtil.getNewDay(startdate,1);
            start=Integer.parseInt(startdate);
        }
        return true;
    }

    @Override
    public Pagination getDtlWithPage(AttedtlSearchBean searchBean, int pageNo, int pageSize) {
        return atteClassDao.getDtlWithPage(searchBean,pageNo,pageSize);
    }

    @Override
    public List<AtteDtl> getDtlList(AttedtlSearchBean searchBean) {
        return atteClassDao.getDtlList(searchBean);
    }

    @Override
    public boolean handleDtl(String deptcode, String attedate) {
        AttedtlSearchBean searchBean=new AttedtlSearchBean();
        searchBean.setDeptcode(deptcode);
        searchBean.setStartdate(attedate);
        searchBean.setEnddate(attedate);
        List<AtteDtl> list=atteClassDao.getDtlList(searchBean);
        for(AtteDtl dtl:list){
          List<TAtteDtl> details=atteClassDao.getDetailList(dtl.getCustid(),attedate) ;
           if(details!=null){
               for(TAtteDtl detail:details){
                int state=getState(detail.getTimeid(),dtl.getAttetime());
                if(detail.getState()==0){
                    detail.setState(state);
                    detail.setUpdatetime(DateUtil.getNow());
                    atteClassDao.updateAtteDtl(detail);
                }else if(detail.getState()==2&&state==1){
                    detail.setState(state);
                    detail.setUpdatetime(DateUtil.getNow());
                    atteClassDao.updateAtteDtl(detail);
                }
               }
           }
        }
        return true;
    }

    // 判断流水状态 0-未打卡 1-正常 2-迟到/早退 3-请假
    public int getState(Integer timeid,String attetime){
        int flag=0;
        TNcTime time=ncTimeDao.findByTimeId(timeid);
        if(time==null){
            return flag;
        }
        String btime=time.getBtime().replace(":","")+"00";
        String etime=time.getEtime().replace(":","")+"00";
        int bmin=getDiffMin(attetime,btime);
        int emin=getDiffMin(attetime,etime);
        int d_min=0;
        if(time.getTimetype()==1){   //考到
          TBusinesspara b_para= businessparaDao.findByParakey("atte_bmin");
          d_min=Integer.parseInt(b_para.getParaval());
             if(bmin>0){  //
                 flag=0;
             }else {
                 if(emin>0){
                     flag=1;
                 }else if(emin>-d_min){
                     flag=2;
                 }else{
                     flag=0;
                 }
             }
        }else if(time.getTimetype()==2){ //考离
            TBusinesspara e_para= businessparaDao.findByParakey("atte_emin");
            d_min=Integer.parseInt(e_para.getParaval());
            if(bmin>d_min){
                flag=0;
            }else if(bmin<d_min&&bmin>0){
                flag=2;
            }else if(bmin<0&&emin>0){
                flag=1;
            }else{
                flag=0;
            }
        }else{

            if(bmin<0&&emin>0){
                flag=1;
            }else{
                flag=0;
            }
        }
        return flag;
    }

    @Override
    public List<TCustomerInfo> getReviewList(String deptcode) {
        return atteClassDao.getReviewList(deptcode);
    }

    @Override
    public boolean addReview(String deptcode, String opercode, List<String> custidlist) {
        atteClassDao.delReview(deptcode);
        for (String custid:custidlist){
            TAtteReview reviewer=new TAtteReview();
            reviewer.setCustid(custid);
            reviewer.setOpercode(opercode);
            reviewer.setUpdatetime(DateUtil.getNow());
            atteClassDao.addReview(reviewer);
        }
        return true;
    }

    @Override
    public Pagination getPReportWithPage(AttedtlSearchBean searchBean, int pageNo, int pageSize) {
        return atteClassDao.getPReportWithPage(searchBean,pageNo,pageSize);
    }
}
