package com.supwisdom.dlpay.atte.service.impl;

import com.supwisdom.dlpay.atte.dao.CustseaDao;
import com.supwisdom.dlpay.atte.domain.TDevCusttype;
import com.supwisdom.dlpay.atte.domain.TSeaCusttype;
import com.supwisdom.dlpay.atte.service.CustseaService;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CustseaServiceImpl implements CustseaService {
    @Autowired
    CustseaDao custseaDao;
    @Override
    public Pagination getCustseaWithPage(String custtypename, int pageNo, int pageSize) {
        return custseaDao.getCustseaWithPage(custtypename,pageNo,pageSize);
    }

    @Override
    public TSeaCusttype getCustseaById(Integer custtypeid) {
        return custseaDao.getCustseaById(custtypeid);
    }

    @Override
    public boolean updateCustsea(TSeaCusttype tSeaCusttype) {
        return custseaDao.updateCustsea(tSeaCusttype);
    }

    @Override
    public boolean saveCustsea(TSeaCusttype tSeaCusttype) {
        return custseaDao.saveCustsea(tSeaCusttype);
    }

    @Override
    public boolean exist(Integer  custtypeid) {
        return custseaDao.exist(custtypeid);
    }

    @Override
    public List<TNcDevice> getAllCanAssign(Integer ruleid,String devname,String devtype) {
        return custseaDao.getAllCanAssign(ruleid,devname,devtype);
    }

    @Override
    public List<TNcDevice> getAllDevByCusttype(Integer ruleid) {
        return custseaDao.getAllDevByCusttype(ruleid);
    }

    @Override
    public void assignDevRule(String ids, String ruleid) {
            if(custseaDao.deleteDevRuleid(Integer.parseInt(ruleid))){
                if(!StringUtil.isEmpty(ids)){

                    String[] strs=ids.split(",");
                    for(String id:strs){
                        if (!StringUtil.isEmpty(id)) {
                            TDevCusttype custdev=new TDevCusttype();
                            custdev.setRuleid(Integer.parseInt(ruleid));
                            custdev.setDeviceid(Integer.parseInt(id));
                            custseaDao.addDevRuleid(custdev);
                        }
                    }
                }
            }
    }
}
