package com.supwisdom.dlpay.atte.service.impl;

import com.supwisdom.dlpay.atte.dao.SeasonDao;
import com.supwisdom.dlpay.atte.domain.TSeason;
import com.supwisdom.dlpay.atte.service.SeasonService;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SeasonServiceImpl implements SeasonService {
    @Autowired
    SeasonDao seasonDao;

    @Override
    public Pagination getSeasonWithPage(String season,String deptcode ,int pageNo, int pageSize) {
        return seasonDao.getSeasonWithPage(season,deptcode,pageNo,pageSize);
    }

    @Override
    public TSeason getSeasonById(Integer id) {

        return seasonDao.getSeasonById(id);
    }

    @Override
    public TSeason findBySeason(String season) {
        return seasonDao.findBySeason(season);
    }

    @Override
    public boolean saveSeason(TSeason season) {
        return seasonDao.saveSeason(season);
    }

    @Override
    public int getMaxSeasonId() {

        return seasonDao.getMaxSeasonId();
    }

    @Override
    public TSeason findSeasonByIdAndName(Integer id, String season) {
        return seasonDao.getSeasonByIdAndName(id,season);
    }

    @Override
    public boolean updateSeason(TSeason season) {
        return seasonDao.updateSeason(season);
    }

    @Override
    public boolean deleteSeason(int id) {
        return seasonDao.deleteSeason(id);
    }

    @Override
    public List<TSeason> findAllSeason() {
        return seasonDao.findAllSeason();
    }

    @Override
    public boolean stoporopen(Integer id) {
        TSeason season=seasonDao.getSeasonById(id);
        if(season==null){
            return false;
        }
        season.setUpdatetime(DateUtil.getNow());
        if(season.getStatus()==1){
            season.setStatus(2); //停用
        }else{
            TSeason open=seasonDao.getOpenRule(season.getCusttypeid(),season.getDeptcode());
            if(open!=null){
                open.setStatus(2);
                open.setUpdatetime(DateUtil.getNow());
                seasonDao.updateSeason(open);
            }
            season.setStatus(1); //启用
        }
        seasonDao.updateSeason(season);
        return true;
    }

    @Override
    public TSeason getOpenRule(Integer custtypeid, String deptcode) {
        return seasonDao.getOpenRule(custtypeid,deptcode);
    }
}
