package com.supwisdom.dlpay.atte.task;

import com.supwisdom.dlpay.atte.service.AtteClassService;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.task.SyncCustomerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Configuration      //1.主要用于标记配置类，兼备Component的效果。
@EnableScheduling   // 2.开启定时任务
public class CreateAtteDtlTask implements ApplicationRunner {
    protected static Logger logger = LoggerFactory.getLogger(CreateAtteDtlTask.class);
    @Autowired
    AtteClassService atteClassService;

    @Override
    public void run(ApplicationArguments args) throws Exception {

    }

    @Scheduled(cron = "${atte.create.dtl}")//每天一点生成流水
    public void createAtteDtl(){

        String attedate= null;
        try {
            String now = DateUtil.getNow();
            logger.info("时间:" + now + "--生成考勤名单");
            attedate = DateUtil.getNow("yyyyMMdd");
            atteClassService.createAtteDtl(attedate,null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    @Scheduled(cron = "${atte.refresh.dtl}")//每十分钟刷新一次考勤状态
    public void refreshAtteDtl(){
        try {
            String now = DateUtil.getNow();
            logger.info("时间:" + now + "--刷新考勤状态");
          String  attedate = DateUtil.getNow("yyyyMMdd");
            atteClassService.handleDtl(null,attedate);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
