package com.supwisdom.dlpay.conference.api.controller;

import com.supwisdom.dlpay.api.bean.ApiResponse;
import com.supwisdom.dlpay.conference.api.bean.*;
import com.supwisdom.dlpay.conference.bean.ConferenceShowBean;
import com.supwisdom.dlpay.conference.domain.*;
import com.supwisdom.dlpay.conference.service.ConferenceService;
import com.supwisdom.dlpay.conference.util.ConferenceConstant;
import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.domain.TCustomer;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.ncmgr.bean.NcDevBean;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.ncmgr.service.NcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/api/conference")
public class ConerenceApiController {
    @Autowired
    private WebInterfaceService webInterfaceService;
    @Autowired
    private ConferenceService conferenceService;
    @Autowired
    private NcService ncService;

    @RequestMapping(value = "/getconference", method = RequestMethod.POST)
    @ResponseBody
    public ConferenceResp getConferenceToday(@ModelAttribute ConferenceReq req) {
        ConferenceResp resp = new ConferenceResp();
        String confdate = req.getConfdate();
        if (StringUtil.isEmpty(confdate)) {
            resp.setRetcode(99);
            resp.setRetmsg("日期为空");
            return resp;
        }
        String devphyid = req.getDevphyid();
        if (StringUtil.isEmpty(devphyid)) {
            resp.setRetcode(99);
            resp.setRetmsg("设备物理id为空");
            return resp;
        }
        TNcDevice device = ncService.getDevInfoByDevphyid(devphyid);
        if (null == device) {
            resp.setRetcode(9);
            resp.setRetmsg("设备不存在");
            return resp;
        }

        List<ConferenceApiBean> conflist = conferenceService.getConferneceForDevice(confdate);
        resp.setConflist(conflist);
        resp.setCount(conflist.size());
        resp.setRetmsg("OK");
        resp.setRetcode(0);
        return resp;
    }


    @RequestMapping(value = "/getattrate", method = RequestMethod.POST)
    @ResponseBody
    public ConfrateResp getConferenceAttendRate(@ModelAttribute ConfrateReq req) {
        ConfrateResp resp = new ConfrateResp();
        Integer confid = req.getConfid();
        if (null == confid) {
            resp.setRetcode(99);
            resp.setRetmsg("会议id为空");
            return resp;
        }

        TConference conf = conferenceService.getConferenceById(confid);
        if (null == conf) {
            resp.setRetcode(99);
            resp.setRetmsg("会议不存在");
            return resp;
        }
        Integer totcnt = 0;
        Integer actualcnt = 0;
        Float rate = 0f;
        if (ConferenceConstant.CONFTYPE_LIST.equals(conf.getConftype())) {

            totcnt = conferenceService.getListConfPeopleTotalCount(confid);

            actualcnt = conferenceService.getConfPeopleActualCount(confid);
            if (0 != totcnt) {
                rate = actualcnt * 100f / totcnt;
            }
            resp.setActualcnt(actualcnt);
            resp.setAttrate(rate);
            resp.setTotcnt(totcnt);
        } else {
            actualcnt = conferenceService.getNolistConfPeopleCount(confid);
            resp.setActualcnt(actualcnt);
            resp.setTotcnt(totcnt);
            resp.setAttrate(rate);
        }
        resp.setRetcode(0);
        resp.setRetmsg("ok");
        return resp;
    }


    @RequestMapping(value = "/getconfpeople", method = RequestMethod.POST)
    @ResponseBody
    public ConfPeopleResp getConfPeoples(@ModelAttribute ConfPeopleReq req) {
        ConfPeopleResp resp = new ConfPeopleResp();
        Integer confid = req.getConfid();
        TConference conference = conferenceService.getConferenceById(confid);
        if (null == conference) {
            resp.setRetmsg("");
        }

        List<ConfPeopleApiBean> lst = conferenceService.getConfPeopleListByConfid(confid, conference.getConftype());
        resp.setCount(lst.size());
        resp.setPeoplelist(lst);
        resp.setRetcode(0);
        resp.setRetmsg("ok");
        return resp;
    }


    @RequestMapping(value = "/doattend")
    @ResponseBody
    public ModelAndView doAttend(@ModelAttribute ConfAttendReq req) {
        ModelAndView mov = new ModelAndView();
        String userid = req.getUserid();
        Integer confid = req.getConfid();
        String timestamp = req.getTimestamp();
        String devphyid = req.getDevphyid();
        if (null == confid || StringUtil.isEmpty(timestamp) || StringUtil.isEmpty(devphyid)) {
            mov.addObject("msg", "签到失败");
            mov.addObject("errorMsg", "参数传递错误");
            mov.setViewName("apph5/confresult");
            return mov;
        }


        TConference conference = conferenceService.getConferenceById(confid);
        if (null == conference) {
            mov.addObject("msg", "签到失败");
            mov.addObject("errorMsg", "会议不存在");
            mov.setViewName("apph5/confresult");
            return mov;
        }

        TNcDevice device = conferenceService.getBindedDevice(confid);
        if (null == device) {
            mov.addObject("msg", "签到失败");
            mov.addObject("errorMsg", "请在会议绑定的设备上打卡");

            mov.setViewName("apph5/confresult");
            return mov;
        }

        String now = DateUtil.getNow("yyyyMMddHHmmss");
        String downcheck = DateUtil.getNewTime(now, -60 * 5);
        String upcheck = DateUtil.getNewTime(now, 60 * 5);

        if (DateUtil.compareDatetime(timestamp, downcheck) < 0 || DateUtil.compareDatetime(timestamp, upcheck) > 0) {
            mov.addObject("msg", "签到失败");
            mov.addObject("errorMsg", "时间误差过大");
            mov.setViewName("apph5/confresult");
            return mov;
        }

        if(StringUtil.isEmpty(userid)){
            mov.addObject("confid",confid);
            mov.setViewName("apph5/tempattend");
            return mov;
        }
        TCustomer customer = webInterfaceService.findCustomerById(userid);
        if (null == customer) {
            mov.addObject("msg", "签到失败");
            mov.addObject("errorMsg", "客户不存在");
            mov.setViewName("apph5/confresult");
            return mov;
        }

        String atttime = DateUtil.getNow("HHmm");

        int compareAttend = DateUtil.compareDatetime(atttime, conference.getAttendtime(), "HHmm");
        int compareStart = DateUtil.compareDatetime(atttime, conference.getStarttime(), "HHmm");

        if (-1 == compareAttend) {
            mov.addObject("msg", "签到失败");
            mov.addObject("errorMsg", "会议签到时间尚未开始，请在签到时间之后再打卡");
            mov.setViewName("apph5/confresult");
            return mov;
        }
        String attstatus;
        if (-1 == compareStart) {
            attstatus = ConferenceConstant.ATTENDSTATUS_CHECKED;
        } else {
            attstatus = ConferenceConstant.ATTENDSTATUS_LATE;
        }

        if (ConferenceConstant.CONFTYPE_NOLIST.equals(conference.getConftype())) {
            TNolistConfPeople opeople = conferenceService.getNolistConfPeopleByConfidAndCustid(confid, customer.getCustid());
            if (null != opeople) {
                mov.addObject("msg", "签到失败");
                mov.addObject("errorMsg", "请勿重复签到");
                mov.setViewName("apph5/confresult");
                return mov;
            }

            TNolistConfPeople people = new TNolistConfPeople();

            people.setAttstatus(attstatus);
            //   people.setCardno(dtl.getCardno());
            people.setConfid(conference.getConfid());
            people.setCustid(customer.getCustid());
            people.setAtttime(atttime);
            people.setCustname(customer.getCustname());
            people.setAtttype(ConferenceConstant.ATTTYPE_SELF);
            people.setLastsaved(DateUtil.getNow());
            conferenceService.saveNolistConfPeople(people);
        } else {
            TConfPeople people = conferenceService.getTConfPeopleByConfidAndCustid(conference.getConfid(), customer.getCustid());
            if (null == people) {
                mov.addObject("msg", "签到失败");
                mov.addObject("errorMsg", "打卡人员不在会议名单中");
                mov.setViewName("apph5/confresult");
                return mov;
            }
            if (ConferenceConstant.ATTENDSTATUS_CHECKED.equals(people.getAttstatus())) {
                mov.addObject("msg", "签到失败");
                mov.addObject("errorMsg", "请勿重复签到");
                mov.setViewName("apph5/confresult");
                return mov;
            }

            if (!ConferenceConstant.ATTENDSTATUS_INSTEAD.equals(people.getAttstatus())) {
                people.setAttstatus(attstatus);
            }
            people.setAtttime(atttime);
            conferenceService.saveConfPeople(people);
        }

        mov.addObject("msg", "签到成功");
        mov.addObject("remarkTitle", "会议概要");
        mov.addObject("remark", conference.getRemark());
        mov.setViewName("apph5/confresult");
        return mov;
    }

    @RequestMapping(value = "/savetempcust", method = RequestMethod.POST)
    @ResponseBody
    public Map saveTempCustomer(@RequestBody TempCustomerBean postData) {
        Map map = new HashMap();
        TConference conference=conferenceService.getConferenceById(postData.getConfid());
        if(null==conference.getConfid()){
            map.put("errcode","500");
            map.put("errStr","会议不存在");
            return  map;
        }
        String atttime = DateUtil.getNow("HHmm");

        int compareStart = DateUtil.compareDatetime(atttime, conference.getStarttime(), "HHmm");
        String attstatus;

        if (-1 != compareStart) {
            attstatus = ConferenceConstant.ATTENDSTATUS_LATE;
        } else {
            attstatus = ConferenceConstant.ATTENDSTATUS_CHECKED;
        }

        String conftype=conference.getConftype();
        if(ConferenceConstant.CONFTYPE_LIST.equals(conftype)){
            TConfPeople people = conferenceService.getTConfPeopleByConfidAndCustid(conference.getConfid(), postData.getPhone());
            if (null != people) {
                map.put("errcode","500");
                map.put("errStr","您已成功签到");
                return map;
            }
            people=new TConfPeople();

            people.setAttstatus(attstatus);
            //   people.setCardno(dtl.getCardno());
            people.setConfid(conference.getConfid());
            people.setCustid(postData.getPhone());
            people.setAtttime(atttime);
            people.setCustname(postData.getCustname());
            people.setAtttype(ConferenceConstant.ATTTYPE_TEMP);
            people.setLastsaved(DateUtil.getNow());
            people.setRemark(postData.getDeptname());
            conferenceService.saveConfPeople(people);
        }else{
            TNolistConfPeople people = conferenceService.getNolistConfPeopleByConfidAndCustid(conference.getConfid(), postData.getPhone());
            if (null != people) {
                map.put("errcode","500");
                map.put("errStr","您已成功签到");
                return map;
            }
            people = new TNolistConfPeople();
            people.setAttstatus(attstatus);
        //    people.setCardno(dtl.getCardno());
            people.setConfid(conference.getConfid());
            people.setCustid(postData.getPhone());
            people.setAtttime(atttime);
            people.setCustname(postData.getCustname());
            people.setAtttype(ConferenceConstant.ATTTYPE_TEMP);
            people.setLastsaved(DateUtil.getNow());
            people.setRemark(postData.getDeptname());
            conferenceService.saveNolistConfPeople(people);
        }
        map.put("errcode","0");
        return map;
    }

    @RequestMapping(value = "/test", method = RequestMethod.POST)
    @ResponseBody
    public ApiResponse test() {
        ApiResponse resp = new ApiResponse();
        resp.setRetmsg("OK");
        resp.setRetcode(0);
        return resp;
    }
}
