package com.supwisdom.dlpay.conference.controller;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.conference.bean.ConferenceShowBean;
import com.supwisdom.dlpay.conference.bean.ConfpeopleReportBean;
import com.supwisdom.dlpay.conference.bean.ConfpeopleShowBean;
import com.supwisdom.dlpay.conference.domain.TConference;
import com.supwisdom.dlpay.conference.service.ConferenceService;
import com.supwisdom.dlpay.conference.util.ConferenceConstant;
import com.supwisdom.dlpay.customer.bean.CustomerSearchBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.mainservice.domain.TCustomer;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.ncmgr.service.NcService;
import com.supwisdom.dlpay.util.WebCheckException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.List;

@Controller
public class ConfPeopleController {
    @Autowired
    private ConferenceService conferenceService;
    @Autowired
    private WebInterfaceService webInterfaceService;



    @GetMapping("/confpeople/index")
    public String ConferenceView(@AuthenticationPrincipal UserDetails operUser,
                                 Model model) {
        TOperator oper = (TOperator) operUser;
        String deptcode=oper.getDeptcode();
        List<TConference> conf=conferenceService.getAllConference(deptcode);
        for(TConference c:conf){
            String conftype="名单会议";
            if(ConferenceConstant.CONFTYPE_NOLIST.equals(c.getConftype())){
                conftype="临时会议";
            }
            String date= DateUtil.reformatDatetime(c.getConfdate(),"yyyyMMdd","yyyy-MM-dd");
            c.setConfname(c.getConfname()+"  "+date+"  "+conftype);
        }
        model.addAttribute("conflist",conf);
        return "confpeople/index";
    }

    @GetMapping("/confpeople/peoplelist")
    @ResponseBody
    public PageResult<ConfpeopleShowBean> searchConfPeople(@RequestParam("page") Integer pageNo,
                                                             @RequestParam("limit") Integer pageSize,
                                                             @RequestParam(value = "confid", required = false) Integer confid,
                                                             @RequestParam(value = "attstatus", required = false) String attstatus,
                                                             @RequestParam(value = "atttype", required = false) String atttype,
                                                             Model model) {
        try {
            if(null==confid){
                return new PageResult<>(99, "请选择会议");
            }
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;

            return conferenceService.getConfPeoplePage(confid, attstatus,atttype, pageNo, pageSize);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @GetMapping("/confpeople/load4add")
    public String load4ConfDetails(
                                   @AuthenticationPrincipal UserDetails operUser,
                                   Model model) {
        CustomerSearchBean bean=new CustomerSearchBean();
        TOperator oper = (TOperator) operUser;
        String deptcode=oper.getDeptcode();
        bean.setDeptcode(deptcode);
        PageResult<TCustomerInfo> infolist=webInterfaceService.getCustomerInfoPage(bean);
        List<TCustomerInfo> list=infolist.getData();
        if(!StringUtil.isEmpty(list)){
            model.addAttribute("custlist", list);
        }

        return "confpeople/form";
    }

    @PostMapping("/confpeople/editconfpeople")
    @ResponseBody
    public JsonResult editConfpeople(@RequestParam("pid") String pid,
                                     @RequestParam("conftype") String conftype,
                                     @RequestParam(value="attstatus") String attstatus,
                                     @RequestParam(value="insteadcustid", required = false) String insteadcustid,
                                     @RequestParam(value="remark", required = false) String remark
                                    ) {
        try{
            if(!ConferenceConstant.ATTENDSTATUS_INSTEAD.equals(attstatus)){
                insteadcustid="";
            }
            return conferenceService.updateConfPeople(pid,conftype,insteadcustid,attstatus,remark);
        }catch (Exception e){
            e.printStackTrace();
            return JsonResult.error("修改失败");

        }

    }

}
