package com.supwisdom.dlpay.conference.controller;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.conference.bean.ConfReportShowBean;
import com.supwisdom.dlpay.conference.bean.ConferenceShowBean;
import com.supwisdom.dlpay.conference.bean.ConfpeopleReportBean;
import com.supwisdom.dlpay.conference.bean.ConfpeopleShowBean;
import com.supwisdom.dlpay.conference.domain.TConfPeople;
import com.supwisdom.dlpay.conference.domain.TConference;
import com.supwisdom.dlpay.conference.service.ConferenceService;
import com.supwisdom.dlpay.conference.util.ConferenceConstant;
import com.supwisdom.dlpay.customer.bean.CustomerSearchBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.List;

@Controller
public class ConfReportController {
    @Autowired
    private ConferenceService conferenceService;
    @Autowired
    private WebInterfaceService webInterfaceService;


    @GetMapping("/confreport/index")
    public String ConferenceView(Model model) {
        String today = DateUtil.getNow("yyyy-MM-dd");

        model.addAttribute("confDate", today);
        return "confreport/index";
    }

    @GetMapping("/confreport/reportlist")
    @ResponseBody
    public PageResult<ConfReportShowBean> searchConfPeople(@RequestParam("page") Integer pageNo,
                                                           @RequestParam("limit") Integer pageSize,
                                                           @RequestParam(value = "confname", required = false) String confname,
                                                           @RequestParam(value = "conftype", required = false) String conftype,
                                                           @RequestParam(value = "confdate", required = false) String confdate,
                                                           @AuthenticationPrincipal UserDetails operUser,
                                                           Model model) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            TOperator oper = (TOperator) operUser;
            String deptcode = oper.getDeptcode();
            String status = ConferenceConstant.CONFSTATUS_OVER;
            String date="";
            if(!StringUtil.isEmpty(confdate)){
                date=DateUtil.reformatDatetime(confdate,"yyyy-MM-dd","yyyyMMdd");
            }

            return conferenceService.getConfReportPage(confname, conftype, deptcode, date, status, pageNo, pageSize);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @GetMapping("/confreport/load4detail")
    public String load4ConfDetails(@RequestParam("confid") Integer confid, Model model) {
        model.addAttribute("detailConfid", confid);
        return "confreport/detail";
    }

    @GetMapping("/confreport/attlist")
    @ResponseBody
    public PageResult<ConfpeopleReportBean> searchUnAttendConfPeople(
            @RequestParam("confid") Integer confid,
            @RequestParam(value = "searchkey", required = false) String searchkey,
            @RequestParam(value ="attstatus", required = false) String attstatus,
            @RequestParam(value ="deptcode", required = false) String deptcode) {
        try {
            return conferenceService.getConfPeopleReport(confid,searchkey, attstatus,deptcode,"not");
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @GetMapping("/confreport/unattlist")
    @ResponseBody
    public PageResult<ConfpeopleReportBean> searchAttendConfPeople(
            @RequestParam("confid") Integer confid,
            @RequestParam(value = "searchkey", required = false) String searchkey,
            @RequestParam(value ="attstatus", required = false) String attstatus,
            @RequestParam(value ="deptcode", required = false) String deptcode) {
        try {
            return conferenceService.getConfPeopleReport(confid, searchkey,attstatus,deptcode,"");
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }
}
