package com.supwisdom.dlpay.conference.controller;

import cn.afterturn.easypoi.entity.vo.MapExcelConstants;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.view.PoiBaseView;
import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.conference.bean.ConferenceShowBean;
import com.supwisdom.dlpay.conference.domain.TConfPeople;
import com.supwisdom.dlpay.conference.domain.TConferenceDevbind;
import com.supwisdom.dlpay.conference.service.ConferenceService;
import com.supwisdom.dlpay.conference.util.ConferenceConstant;
import com.supwisdom.dlpay.conference.util.QRCodeUtil;
import com.supwisdom.dlpay.customer.bean.CustomerSearchBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerImportBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.*;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.ncmgr.service.NcService;
import com.supwisdom.dlpay.util.WebCheckException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Controller
public class ConferenceController {
    @Autowired
    private ConferenceService conferenceService;
    @Autowired
    private NcService ncService;
    @Autowired
    private WebInterfaceService webInterfaceService;


    @GetMapping("/conference/index")
    public String ConferenceView() {
        return "conference/conflist";
    }

    @GetMapping("/conference/conflist")
    @ResponseBody
    public PageResult<ConferenceShowBean> searchConflist(@RequestParam("page") Integer pageNo,
                                                         @RequestParam("limit") Integer pageSize,
                                                         @RequestParam(value = "confname", required = false) String confname,
                                                         @RequestParam(value = "conftype", required = false) String conftype,
                                                         @AuthenticationPrincipal UserDetails operUser) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            TOperator oper = (TOperator) operUser;
            String deptcode = oper.getDeptcode();
            return conferenceService.getConferenceInfos(confname, conftype, deptcode,"", pageNo, pageSize);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @PostMapping("/conference/deleteconf")
    @ResponseBody
    public JsonResult deleteConference(@RequestParam Integer id) {
        try {
            if (null == id) {
                return JsonResult.error("参数传递错误");
            }
            if (conferenceService.deleteConference(id)) {
                return JsonResult.ok("删除成功！");
            } else {
                return JsonResult.error("删除失败！");
            }
        } catch (WebCheckException ex) {
            return JsonResult.error(ex.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResult.error("系统处理异常").put("exception", e);
        }
    }

    @PostMapping("/conference/deleteconfpeople")
    @ResponseBody
    public JsonResult deleteConfPeople(@RequestParam String pid) {
        try {
            if (null == pid) {
                return JsonResult.error("参数传递错误");
            }
            if (conferenceService.deleteConfPeople(pid)) {
                return JsonResult.ok("删除成功！");
            } else {
                return JsonResult.error("删除失败！");
            }
        } catch (WebCheckException ex) {
            return JsonResult.error(ex.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResult.error("系统处理异常").put("exception", e);
        }
    }


    @GetMapping("/conference/load4addconf")
    public String load4addConference(Model model) {
        String now = DateUtil.getNow("yyyyMMdd");
        model.addAttribute("maxdate", DateUtil.reformatDatetime(now, "yyyyMMdd", "yyyy-MM-dd"));
        List<TNcDevice> devices = ncService.getSystemDevByType(ConferenceConstant.DEVICETYPE_CONFERENCE);
        model.addAttribute("confdevice", devices);
        return "conference/confform";
    }


    @PostMapping("/conference/addconf")
    @ResponseBody
    public JsonResult editConference(@RequestParam("confname") String confname,
                                     @RequestParam("conftype") String conftype,
                                     @RequestParam("confdate") String confdate,
                                     @RequestParam("starttime") String starttime,
                                     @RequestParam("endtime") String endtime,
                                     @RequestParam("attendtime") String attendtime,
                                     @RequestParam("deviceid") Integer deviceid,
                                     @RequestParam("remark") String remark,
                                     //    @RequestParam(value = "file", required = false) MultipartFile file,
                                     @AuthenticationPrincipal UserDetails operUser,
                                     HttpServletRequest request) {
        try {
            if (StringUtil.isEmpty(confname)
                    || null == deviceid
                    || (!ConferenceConstant.CONFTYPE_LIST.equals(conftype) && !ConferenceConstant.CONFTYPE_NOLIST.equals(conftype))
                    || !DateUtil.checkDatetimeValid(starttime, "HH:mm")
                    || !DateUtil.checkDatetimeValid(endtime, "HH:mm")
                    || !DateUtil.checkDatetimeValid(attendtime, "HH:mm")) {
                return JsonResult.error("参数传递错误");
            } else if (DateUtil.compareDatetime(endtime, starttime, "HH:mm") <= 0) {
                return JsonResult.error("时间范围错误，结束时间必须比起始时间大");
            } else if (DateUtil.compareDatetime(starttime, attendtime, "HH:mm") <= 0) {
                return JsonResult.error("时间范围错误，起始时间必须比签到时间大");
            }
            TOperator oper = (TOperator) operUser;
            if (null == oper || StringUtil.isEmpty(oper.getOperid())) {
                return JsonResult.error("登录过期，请重新登录");
            }

            if (conferenceService.saveNewConference(confname.trim(), DateUtil.unParseToDateFormat(confdate), conftype, DateUtil.unParseToDateFormat(starttime), DateUtil.unParseToDateFormat(endtime), DateUtil.unParseToDateFormat(attendtime), oper,  deviceid,remark)) {
                return JsonResult.ok("新增成功");
            } else {
                return JsonResult.error("新增失败");
            }
        } catch (WebCheckException e) {
            return JsonResult.ok(599, e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResult.error("系统处理异常").put("exception", e);
        }
    }


    @GetMapping("/conference/downloadexcel")
    @ResponseBody
    public void downloadExcel(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        try {
            List<ExcelExportEntity> entity = new ArrayList<ExcelExportEntity>();
            /**
             * 1. 设置列信息：name：列标题   key：	列属性
             */
            entity.add(new ExcelExportEntity("市民卡号", "cardno"));
            entity.add(new ExcelExportEntity("姓名", "custname"));
            List<Map> personList = new ArrayList<Map>();

            /**
             * 3.设置表格属性: title:标题  sheetName:工作簿名 type:表格类型
             */
            ExportParams params = new ExportParams(null, "sheet1", ExcelType.HSSF);
            map.put(MapExcelConstants.MAP_LIST, personList);
            map.put(MapExcelConstants.ENTITY_LIST, entity);
            map.put(MapExcelConstants.PARAMS, params);
            map.put(MapExcelConstants.FILE_NAME, "会议名单导入模板");//文件名
            map.put("result", "导出excel文件完成");
            PoiBaseView.render(map, request, response, MapExcelConstants.EASYPOI_MAP_EXCEL_VIEW);

        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "导出excel文件失败");
        }
    }

    @GetMapping("/conference/load4detail")
    public String load4ConfDetails(@RequestParam("confid") Integer confid, Model model) {
        model.addAttribute("detailConfid", confid);
        TNcDevice device = conferenceService.getBindedDevice(confid);
        String devname = "未绑定";
        if (null != device) {
            devname = device.getDevname();
        }
        model.addAttribute("deviceName", devname);
        return "conference/confdetail";
    }

    @GetMapping("/conference/load4detaillist")
    @ResponseBody
    public PageResult<TConfPeople> searchConfPeople(@RequestParam("page") Integer pageNo,
                                                    @RequestParam("limit") Integer pageSize,
                                                    @RequestParam("confid") Integer confid,
                                                    @RequestParam(value = "searchkey", required = false) String searchkey) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;

            return conferenceService.getConferenceDetails(searchkey, confid, pageNo, pageSize);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @RequestMapping("/conference/getQRCode")
    @ResponseBody
    public void getQRCode(@RequestParam("confid") String id, HttpServletResponse httpServletResponse) throws Exception {
        // QRCodeUtil.createQrCode(new FileOutputStream(new File("d:\\qrcode\\qrcode.jpg")),"confid="+id,800,"JPEG");

        httpServletResponse.setHeader("Cache-Control", "no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0);
        httpServletResponse.setContentType("image/jpeg");
        ServletOutputStream responseOutputStream = httpServletResponse.getOutputStream();
        QRCodeUtil.createQrCode(responseOutputStream, "confid=" + id, 750, "JPEG");
        responseOutputStream.flush();
        responseOutputStream.close();

    }

    @GetMapping("/conference/loadimport")
    public String loadimport(@RequestParam("confid") Integer confid,
                             @RequestParam("confname") String confname,Model model) {
        model.addAttribute("detailConfid", confid);
        model.addAttribute("confName", confname);

        return "conference/confpeoplebind";
    }

    @PostMapping("/conference/doimport")
    @ResponseBody
    public JsonResult editConference(@RequestParam("confid") Integer confid,
                                     @RequestParam(value = "file", required = false) MultipartFile file,
                                     HttpServletRequest request) {
        try {

            String path = request.getSession().getServletContext().getRealPath("upload");

            String fpath = null;
            if (null != file) {
                String fileName = file.getOriginalFilename();
                File targetFile = new File(path, fileName);
                if (!targetFile.exists()) {
                    targetFile.mkdirs();
                }
                file.transferTo(targetFile);
                fpath = path + "/" + fileName;
            }

            if (conferenceService.saveConferencePeopleByExcel(confid,fpath)) {
                return JsonResult.ok("新增成功");
            } else {
                return JsonResult.error("新增失败");
            }
        } catch (WebCheckException e) {
            return JsonResult.ok(599, e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResult.error("系统处理异常").put("exception", e);
        }

    }


    @PostMapping("/conference/addconfpeople")
    @ResponseBody
    public JsonResult addConfpeople(@RequestParam("confid") Integer confid,
                                    @RequestParam("cardnos[]") List<String> cardnos) {
        try {
            if (null == confid || StringUtil.isEmpty(cardnos)) {
                return JsonResult.error("参数传递错误");
            }

            if (conferenceService.saveConferencePeople(confid, cardnos)) {
                return JsonResult.ok("人员添加成功");
            } else {
                return JsonResult.error("添加失败");
            }
        } catch (WebCheckException e) {
            return JsonResult.ok(599, e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResult.error("系统处理异常").put("exception", e);
        }

    }

    @RequestMapping("/conference/listpeopleforimport")
    @ResponseBody
    public PageResult<TCustomerImportBean> listConfpeople(
                                                 @RequestParam(value = "custname", required = false) String custname,
                                                 @RequestParam(value = "deptcode", required = false) String deptcode,
                                                 @AuthenticationPrincipal TOperator operUser) {
        try {
            CustomerSearchBean searchBean = new CustomerSearchBean();
            searchBean.setCustname(custname);
            searchBean.setDeptcode(deptcode);
            PageResult<TCustomerImportBean> bean = webInterfaceService.getCustomerInfo(searchBean);
            return bean;
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

}