package com.supwisdom.dlpay.conference.dao;


import com.supwisdom.dlpay.conference.domain.TConfPeople;
import com.supwisdom.dlpay.conference.domain.TConferenceDevbind;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface ConfPeopleDao extends JpaRepository<TConfPeople, String> {

    @Modifying
    @Query("delete from TConfPeople where confid=?1  ")
    void deleteConfPeopleByconfid(int confid);

    TConfPeople findByConfidAndCustid(Integer confid,String custid);

    int countByConfid(Integer confid);

    int countByConfidAndCustidAndAttstatusNot(Integer confid,String custid,String attstatus);

    int countByConfidAndAttstatusIn(Integer confid, List<String> attstatus);

    int countByConfidAndAttstatusInAndAtttypeNot(Integer confid, List<String> attstatus,String Atttype);

    int countByConfidAndAttstatusNotIn(Integer confid, List<String> attstatus);

    int countByConfidAndAttstatusNotInAndAtttypeNot(Integer confid, List<String> attstatus,String atttype);
}
