package com.supwisdom.dlpay.conference.dao;


import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import com.supwisdom.dlpay.conference.domain.TConference;

import java.util.List;

@Repository
public interface ConferenceDao extends JpaRepository<TConference, Integer> , JpaSpecificationExecutor<TConference> {
    TConference findByConfid(Integer confid);

    List<TConference> findByConfdateAndStatus(String confdate, String status);

    List<TConference> findByConfdate(String confdate);

    @Query("from TConference where deptcode=?1 order by confid desc")
    List<TConference> findAllByDeptcodeOrderByConfdate(String deptcode);


    @Query("from TConference order by confid desc")
    List<TConference> findAllOrderByConfdate();
}
