package com.supwisdom.dlpay.conference.service;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.conference.api.bean.ConfPeopleApiBean;
import com.supwisdom.dlpay.conference.api.bean.ConferenceApiBean;
import com.supwisdom.dlpay.conference.bean.ConfReportShowBean;
import com.supwisdom.dlpay.conference.bean.ConferenceShowBean;
import com.supwisdom.dlpay.conference.bean.ConfpeopleReportBean;
import com.supwisdom.dlpay.conference.bean.ConfpeopleShowBean;
import com.supwisdom.dlpay.conference.domain.*;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;


public interface ConferenceService {

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    PageResult<ConferenceShowBean> getConferenceInfos(String confname, String conftype,String deptocde,String confdate, int pageNo, int pageSize);

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    PageResult<ConfReportShowBean> getConfReportPage(String confname, String conftype, String deptcode, String confdate,String status, int pageNo, int pageSize);

    @Transactional(rollbackFor = Exception.class)
    boolean deleteConference(int confid) throws Exception;

    @Transactional(rollbackFor = Exception.class)
    boolean deleteConfPeople(String pid) throws Exception;

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    TNcDevice getBindedDevice(int confid) ;

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    List<TConference> getConferenceByDateAndStatus(String confdate,String status);

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    List<TConference> getAllConference(String deptcode);

    @Transactional(rollbackFor = Exception.class)
    TConference updateConference(TConference conference);

    @Transactional(rollbackFor = Exception.class)
    TConference getConferenceById(Integer confid);

    @Transactional(rollbackFor = Exception.class)
    boolean saveNewConference(String confname,String confdate, String conftype, String starttime,
                              String endtime, String attendtime, TOperator oper, Integer deviceid,String remark) throws Exception;

    @Transactional(rollbackFor = Exception.class)
    boolean saveConferencePeopleByExcel(Integer confid,String fpath) throws Exception;

    @Transactional(rollbackFor = Exception.class)
    boolean saveConferencePeople(Integer confid,List<String> cardnos) throws Exception;

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    PageResult<TConfPeople> getConferenceDetails(String searchkey, int confid, int pageNo, int pageSize);

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    List<TConfDtl> getUnupdateConfDtl();

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    List<ConferenceApiBean> getConferneceForDevice(String confdate);

    @Transactional(rollbackFor = Exception.class)
    TNolistConfPeople saveNolistConfPeople(TNolistConfPeople people) ;

    @Transactional(rollbackFor = Exception.class)
    TConfPeople saveConfPeople(TConfPeople people) ;

    @Transactional(rollbackFor = Exception.class)
    void saveConfDtl(TConfDtl dtl) ;

    @Transactional(rollbackFor = Exception.class)
    JsonResult updateConfPeople(String id,String conftype,String insteadcustid,String attstatus,String remark) ;

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    PageResult<ConfpeopleShowBean> getConfPeoplePage(Integer confid, String attstatus,String atttype, int pageNo, int pageSize);

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    PageResult<ConfpeopleReportBean> getConfPeopleReport(Integer confid, String searchkey,String attstatus, String deptcode,String attflag);

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    TConfPeople getTConfPeopleByConfidAndCustid(Integer confid,String custid) ;

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    TNolistConfPeople getNolistConfPeopleByConfidAndCustid(Integer confid,String custid) ;

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    Integer getConfPeopleActualCount(Integer confid) ;

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    Integer getListConfPeopleTotalCount(Integer confid) ;

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    Integer getNolistConfPeopleCount(Integer confid) ;

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    List<ConfPeopleApiBean> getConfPeopleListByDevphyid(String devphyid, String confdate) ;

    @Transactional(rollbackFor = Exception.class, readOnly = true)
    List<ConfPeopleApiBean> getConfPeopleListByConfid(Integer confid, String conftype) ;

}
