package com.supwisdom.dlpay.conference.service.impl;


import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.conference.api.bean.ConfPeopleApiBean;
import com.supwisdom.dlpay.conference.api.bean.ConferenceApiBean;
import com.supwisdom.dlpay.conference.bean.*;
import com.supwisdom.dlpay.conference.dao.*;
import com.supwisdom.dlpay.conference.domain.*;
import com.supwisdom.dlpay.conference.service.ConferenceService;
import com.supwisdom.dlpay.conference.util.ConferenceConstant;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.dao.CustomerDao;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.ncmgr.dao.NcDeviceDao;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.util.WebCheckException;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.Transformers;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.io.File;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

@Service
public class ConferenceServiceImpl implements ConferenceService {

    @Autowired
    private ConferenceDao conferenceDao;
    @Autowired
    private WebInterfaceService webInterfaceService;
    @Autowired
    private ConfPeopleDao confPeopleDao;
    @Autowired
    private ConferenceDevbindDao conferenceDevbindDao;
    @Autowired
    private NcDeviceDao deviceDao;
    @Autowired
    private SystemUtilService systemUtilService;
    @Autowired
    private ConfDtlDao confDtlDao;
    @Autowired
    private NolistConfPeopleDao nolistConfPeopleDao;
    @Autowired
    private CustomerDao customerDao;


    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public PageResult<ConferenceShowBean> getConferenceInfos(String confname, String conftype,String deptcode,String confdate, int pageNo, int pageSize) {
        Page<TConference> page = getConferencePage(confname, conftype, deptcode, confdate,"", pageNo, pageSize);
        List<ConferenceShowBean> result = new ArrayList<>(0);
        if (null != page && page.getTotalElements() > 0) {
            for (TConference conf : page.getContent()) {
                ConferenceShowBean bean = new ConferenceShowBean();
                bean.setConfname(conf.getConfname());
                bean.setConfdate(DateUtil.reformatDatetime(conf.getConfdate(),"yyyyMMdd","yyyy-MM-dd"));
                bean.setConftype(conf.getConftype());
                bean.setStatus(conf.getStatus());
                bean.setConfid(conf.getConfid());
                bean.setRemark(conf.getRemark());
                bean.setStarttime(conf.getStarttime().substring(0, 2) + ":" + conf.getStarttime().substring(2));
                bean.setEndtime(conf.getEndtime().substring(0, 2) + ":" + conf.getEndtime().substring(2));
                bean.setTimeperoid(bean.getStarttime()+"~"+bean.getEndtime());
                bean.setAttendtime(conf.getAttendtime().substring(0, 2) + ":" + conf.getAttendtime().substring(2));
                result.add(bean);
            }
        }
        return new PageResult<>(page.getTotalElements(), result);
    }

    @Override
    public PageResult<ConfReportShowBean> getConfReportPage(String confname, String conftype, String deptcode, String confdate,String status, int pageNo, int pageSize) {
        Page<TConference> page = getConferencePage(confname, conftype, deptcode, confdate,status, pageNo, pageSize);
        List<ConfReportShowBean> result = new ArrayList<>(0);
        DecimalFormat format=new DecimalFormat("0.00");
        if (null != page && page.getTotalElements() > 0) {
            for (TConference conf : page.getContent()) {
                ConfReportShowBean bean=new ConfReportShowBean();
                bean.setConfname(conf.getConfname());
                bean.setConfdate(DateUtil.reformatDatetime(conf.getConfdate(),"yyyyMMdd","yyyy-MM-dd"));
                bean.setConftype(conf.getConftype());
                bean.setConfid(conf.getConfid());
                String starttime=conf.getStarttime().substring(0, 2) + ":" + conf.getStarttime().substring(2);
                String endtime=conf.getEndtime().substring(0, 2) + ":" + conf.getEndtime().substring(2);
                bean.setTimeperoid(starttime+"~"+endtime);
                bean.setAttendtime(conf.getAttendtime().substring(0, 2) + ":" + conf.getAttendtime().substring(2));
                if(ConferenceConstant.CONFTYPE_NOLIST.equals(conf.getConftype())){
                    Integer totcnt=checkNolistDeptCustomer(conf.getConfid());
                    Integer actualcnt=nolistConfPeopleDao.countByConfid(conf.getConfid());
                    Float rate=0f;
                    if(0!=totcnt){
                        rate=actualcnt*100f/totcnt;
                    }
                    bean.setAttendrate(format.format(rate)+"%");

                }else if(ConferenceConstant.CONFTYPE_LIST.equals(conf.getConftype())){
                    Integer totcnt = getListConfPeopleTotalCount(conf.getConfid());
                    Integer actualcnt=getConfPeopleActualCount(conf.getConfid());
                    Float rate=0f;
                    if(0!=totcnt){
                        rate=actualcnt*100f/totcnt;
                    }
                    bean.setAttendrate(format.format(rate)+"%");

                }
                result.add(bean);

            }
        }
        return new PageResult<>(page.getTotalElements(), result);
    }

    @NotNull
    private Page<TConference> getConferencePage(String confname, String conftype, String deptcode, String confdate,String status, int pageNo, int pageSize) {
        Sort.Order order=new Sort.Order(Sort.Direction.DESC, "confdate");
        Pageable pageable = PageRequest.of(pageNo - 1, pageSize, Sort.by(order));


        return conferenceDao.findAll(new Specification<TConference>() {
            @Override
            public Predicate toPredicate(Root<TConference> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                List<Predicate> predicates = new ArrayList<>();
                if (!StringUtil.isEmpty(confname)) {
                    predicates.add(criteriaBuilder.like(root.get("confname").as(String.class), "%" + confname.trim() + "%"));
                }
                if (!StringUtil.isEmpty(conftype)) {
                    predicates.add(criteriaBuilder.equal(root.get("conftype").as(String.class), conftype));
                }
                List<String> childdplist=null;
                if(!StringUtil.isEmpty(deptcode)){
                    childdplist = customerDao.getChildDeptlist( deptcode);
                }
                if (!StringUtil.isEmpty(childdplist)) {
                    predicates.add(root.get("deptcode").in(childdplist));

                }
                if (!StringUtil.isEmpty(confdate)) {
                    predicates.add(criteriaBuilder.equal(root.get("confdate").as(String.class), confdate));
                }
                if (!StringUtil.isEmpty(status)) {
                    predicates.add(criteriaBuilder.equal(root.get("status").as(String.class), status));
                }
                return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
            }
        }, pageable);
    }

    @Override
    public boolean deleteConference(int confid) throws Exception{
        TConference conf = conferenceDao.findByConfid(confid);
        if (null == conf) {
            throw new WebCheckException("餐补规则不存在！");
        } else if (!ConferenceConstant.CONFSTATUS_UNSTART.equals(conf.getStatus()) && !ConferenceConstant.CONFSTATUS_CLOSED.equals(conf.getStatus())) {
            throw new WebCheckException("只能删除未进行的会议！");
        }

        confPeopleDao.deleteConfPeopleByconfid(confid); //名单
        conferenceDevbindDao.deleteBindByConfid(confid); //绑定设备
        conferenceDao.delete(conf);
        return true;
    }

    @Override
    public boolean deleteConfPeople(String pid) throws Exception {
        TConfPeople people=confPeopleDao.getOne(pid);
        if(null == people){
            throw new WebCheckException("会议人员不存在");
        }
        confPeopleDao.delete(people);
        return true;
    }

    @Override
    public TNcDevice getBindedDevice(int confid) {
        TConferenceDevbind bind=conferenceDevbindDao.findByConfid(confid);
        if(null!=bind){
            TNcDevice dev=deviceDao.findDevById(bind.getDeviceid());
            return dev;
        }
        return null;
    }

    @Override
    public List<TConference> getConferenceByDateAndStatus(String confdate,String status) {

        List<TConference> conflist;
        if(!StringUtil.isEmpty(status)){
            conflist=conferenceDao.findByConfdateAndStatus(confdate,status);
        }else{
            conflist=conferenceDao.findByConfdate(confdate);
        }

        if(StringUtil.isEmpty(conflist)){
            return null;
        }
        return conflist;
    }

    @Override
    public List<TConference> getAllConference(String deptcode) {
        if(!StringUtil.isEmpty(deptcode)){
            return conferenceDao.findAllByDeptcodeOrderByConfdate(deptcode);
        }
        return conferenceDao.findAllOrderByConfdate();

    }

    @Override
    public TConference updateConference(TConference conference) {
        return conferenceDao.save(conference);
    }

    @Override
    public TConference getConferenceById(Integer confid) {
        return conferenceDao.findByConfid(confid);
    }
/*
    @Override
    public boolean closeConference(int confid) {
        return false;
    }*/

    @Override
    public boolean saveNewConference(String confname,String confdate, String conftype, String starttime, String endtime,String attendtime, TOperator oper, Integer deviceid,String remark) throws Exception {

        String errdevname=checkTimeErrorDevice(attendtime,endtime,confdate,deviceid);
        if(!StringUtil.isEmpty(errdevname)){
            throw new WebCheckException("设备《"+ errdevname+"》存在时间冲突，请重新选择设备");
        }

        TConference conf = new TConference();
        conf.setConftype(conftype);
        conf.setConfname(confname);
        conf.setAttendtime(attendtime);
        conf.setConfdate(confdate);
        conf.setStatus(ConferenceConstant.CONFSTATUS_UNSTART);
        conf.setCreateOperid(oper.getOperid());
        conf.setStarttime(starttime);
        conf.setEndtime(endtime);
        conf.setDeptcode(oper.getDeptcode());
        String systime = DateUtil.getNow();
        conf.setCreatetime(systime);
        conf.setLastsaved(systime);
        conf.setRemark(remark);
        conf = conferenceDao.save(conf);

        TConferenceDevbind bind=new TConferenceDevbind();
        bind.setConfid(conf.getConfid());
        bind.setCreateOperid(oper.getOperid());
        bind.setCreatetime(systime);
        bind.setDeviceid(deviceid);
        conferenceDevbindDao.save(bind);



        return true;

    }

    @Override
    public boolean saveConferencePeopleByExcel(Integer confid, String fpath) throws Exception {
        TConference conference=conferenceDao.findByConfid(confid);
        if(null==conference){
            throw new WebCheckException("会议不存在");
        }
        List<String> successCardnos = new ArrayList<>(0);
        List<String> errmsgList = new ArrayList<>(0);

        ImportParams params = new ImportParams();
        params.setTitleRows(0);
        List<ConfPeopleImportBean> peoplelist = ExcelImportUtil.importExcel(new File(fpath), ConfPeopleImportBean.class, params);
        if (peoplelist.size() <= 0) {
            throw new WebCheckException("模板数据为空");
        }

        try {
            for (int n = 0; n < peoplelist.size(); n++) {
                String msg = "";
                String cardno =peoplelist.get(n).getCardno().trim();
                String name = peoplelist.get(n).getCustname().trim();
                if (StringUtil.isEmpty(cardno)) {
                    msg += "，市民卡号为空";
                }
                if (StringUtil.isEmpty(name)) {
                    msg += "，姓名为空";
                }
                TCustomerInfo customer=null;
                List<TCustomerInfo> customerlist = webInterfaceService.getAllTCustomerList(null,cardno,null);
                if(customerlist.size()>0){
                    customer=customerlist.get(0);
                }
                if (!customer.getCustname().equals(name)) {
                    msg += "，市民卡号与姓名不匹配！";
                }
                if (!StringUtil.isEmpty(cardno) && successCardnos.contains(cardno)) {
                    msg += "，市民卡号重复！";
                }
                String errconfname=checkConfTimeError(conference.getAttendtime(),conference.getEndtime(),conference.getConfdate(),cardno);
                if(!StringUtil.isEmpty(errconfname)){
                    msg += "，市民卡号[" + cardno + "]在会议："+errconfname+"中已存在！";
                }

                if (!StringUtil.isEmpty(msg)) {
                    errmsgList.add("第" + (n + 1) + "行数据错误" + msg);
                } else {
                    String atttype=ConferenceConstant.ATTTYPE_SELF;
                    String custid=customer.getCustid();
                    saveNewConfPeople(confid, cardno, name, atttype, custid);

                    successCardnos.add(cardno);
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
            throw new WebCheckException("模板格式有误，请确保卡号为文本格式");
        }

        if (!StringUtil.isEmpty(errmsgList)) {
            StringBuffer errmsg = new StringBuffer("导入失败，名单存在错误！");
            for (int j = 0; j < errmsgList.size(); j++) {
                errmsg.append("<br/>" + errmsgList.get(j));
                if (j > 10) {
                    errmsg.append("<br/>错误太多，请仔细核对名单后再上传！");
                }
            }
            throw new WebCheckException(errmsg.toString());
        }

        return true;
    }

    @Override
    public boolean saveConferencePeople(Integer confid, List<String> cardnos) throws Exception {
        List<String> successCardnos = new ArrayList<>(0);
        List<String> errmsgList = new ArrayList<>(0);

        for (String card :cardnos) {
            String msg = "";
            TCustomerInfo customer=new TCustomerInfo();
            List<TCustomerInfo> customerlist = webInterfaceService.getAllTCustomerList(null,card,null);

            if(customerlist.size()>0){
                customer=customerlist.get(0);
            }else{
                msg+=",对应用户不存在";
            }
            TConference conference=conferenceDao.findByConfid(confid);
            if(null==conference){
                msg+=",会议不存在";
            }

            String errconfname=checkConfTimeError(conference.getAttendtime(),conference.getEndtime(),conference.getConfdate(),card);
            if(!StringUtil.isEmpty(errconfname)){
                msg += "，市民卡号[" + card + "]在会议："+errconfname+"中已存在！";
            }
            if (!StringUtil.isEmpty(msg)) {
                errmsgList.add("，市民卡号[" + card + "]错误" + msg);
            } else{
                String atttype=ConferenceConstant.ATTTYPE_SELF;
                String custid=customer.getCustid();
                saveNewConfPeople(confid,customer.getCardno(),customer.getCustname(),atttype,custid);
            }


        }
        if (!StringUtil.isEmpty(errmsgList)) {
            StringBuffer errmsg = new StringBuffer("添加失败，名单存在错误！");
            for (int j = 0; j < errmsgList.size(); j++) {
                errmsg.append("<br/>" + errmsgList.get(j));
                if (j > 10) {
                    errmsg.append("<br/>错误太多，请重新上传！");
                }
            }
            throw new WebCheckException(errmsg.toString());
        }

        return true;
    }

    private void saveNewConfPeople(Integer confid, String cardno, String name, String atttype, String custid) {
        TConfPeople people = new TConfPeople();
        people.setAttstatus(ConferenceConstant.ATTENDSTATUS_UNCHECK);
        people.setAtttype(atttype);
        people.setCardno(cardno);
        people.setCustid(custid);
        people.setConfid(confid);
        people.setLastsaved(DateUtil.getNow());
        people.setCustname(name);
        confPeopleDao.save(people); //保存明细
    }

    @Override
    public PageResult<TConfPeople> getConferenceDetails(String searchkey, int confid, int pageNo, int pageSize) {
        StringBuffer querySql = new StringBuffer("from TConfPeople t where t.confid=:confid ");
        StringBuffer countSql = new StringBuffer("select count(t.pid) as cnt from TConfPeople t where t.confid=:confid ");
        if (!StringUtil.isEmpty(searchkey)) {
            querySql.append(" and (t.cardno like :str or t.custname like :str) ");
            countSql.append(" and (t.cardno like :str or t.custname like :str) ");
        }
        querySql.append(" order by t.cardno ");
        Query query = entityManager.createQuery(querySql.toString());
        Query countQuery = entityManager.createQuery(countSql.toString());
        query.setParameter("confid", confid);
        countQuery.setParameter("confid", confid);
        if (!StringUtil.isEmpty(searchkey)) {
            query.setParameter("str", "%" + searchkey.trim() + "%");
            countQuery.setParameter("str", "%" + searchkey.trim() + "%");
        }
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize); //分页显示
        List<TConfPeople> list = query.getResultList();
        Long count = (Long) countQuery.getSingleResult();
        return new PageResult<>(count.longValue(), list);
    }

    @Override
    public List<TConfDtl> getUnupdateConfDtl() {
        List<TConfDtl> dtl=confDtlDao.findByUpdateflag(ConferenceConstant.CONFDTL_STATUS_UNUPDATE);
        if(!StringUtil.isEmpty(dtl)){
            return dtl;
        }
        return null;
    }

    @Override
    public List<ConferenceApiBean> getConferneceForDevice(String confdate) {
        StringBuffer querySql=new StringBuffer("select a.confid,a.confname,a.conftype," +
                "a.confdate,a.status,a.starttime,a.endtime,a.attendtime,c.devname as confarea from tb_conference a " +
                "left join tb_conference_devbind b on a.confid=b.confid " +
                "left join t_nc_device c on b.deviceid=c.deviceid " +
                "where a.confdate=:confdate ");

        Query query = entityManager.createNativeQuery(querySql.toString());
        query.setParameter("confdate",confdate);
        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(ConferenceApiBean.class));
        List<ConferenceApiBean> list = query.getResultList();
        return list;
    }

    @Override
    public TNolistConfPeople saveNolistConfPeople(TNolistConfPeople people) {
        return nolistConfPeopleDao.save(people) ;
    }

    @Override
    public TConfPeople saveConfPeople(TConfPeople people) {
        return confPeopleDao.save(people);
    }

    @Override
    public void saveConfDtl(TConfDtl dtl) {
        confDtlDao.save(dtl);
    }

    @Override
    public JsonResult updateConfPeople(String pid, String conftype, String insteadcustid, String attstatus, String remark) {

        if(ConferenceConstant.CONFTYPE_NOLIST.equals(conftype)){
            TNolistConfPeople people=nolistConfPeopleDao.getOne(pid);
            if(null==people){
                return JsonResult.error("修改失败，未查询到该用户");
            }
            TConference conf=conferenceDao.findByConfid(people.getConfid());
            if(null==conf){
                return JsonResult.error("修改失败，会议不存在");
            }

            people.setInsteadcustid(insteadcustid);
            people.setAttstatus(attstatus);
            people.setRemark(remark);
            nolistConfPeopleDao.save(people);

        }else{
            TConfPeople people=confPeopleDao.getOne(pid);
            if(null==people){
                return JsonResult.error("修改失败，未查询到该用户");
            }
            TConference conf=conferenceDao.findByConfid(people.getConfid());
            if(null==conf){
                return JsonResult.error("修改失败，会议不存在");
            }
            if(null!=people.getAtttime()){
                return JsonResult.error("已签到人员不可修改状态");
            }

            if(ConferenceConstant.ATTENDSTATUS_INSTEAD.equals(attstatus)){
                if(ConferenceConstant.CONFSTATUS_OVER.equals(conf.getStatus())||ConferenceConstant.CONFSTATUS_START.equals(conf.getStatus())){
                    return JsonResult.error("已开始或结束的会议不能代签");
                }
                List<TCustomerInfo> clist=customerDao.getAllTCustomerList("","","",insteadcustid);
                if(clist.size()<=0){
                    return JsonResult.error("代签人员不存在");
                }
                TCustomerInfo cust=clist.get(0);
                saveNewConfPeople(conf.getConfid(),cust.getCardno(),cust.getCustname(),ConferenceConstant.ATTTYPE_INSTEAD,insteadcustid);
            }

            people.setInsteadcustid(insteadcustid);
            people.setAttstatus(attstatus);
            people.setRemark(remark);
            if(ConferenceConstant.ATTENDSTATUS_HANDCHECK.equals(attstatus)){
                people.setAtttime("----");
            }
            confPeopleDao.save(people);


        }
        return JsonResult.ok();
    }

    @Override
    public PageResult<ConfpeopleShowBean> getConfPeoplePage(Integer confid, String attstatus,String atttype, int pageNo, int pageSize) {
        TConference conf=conferenceDao.findByConfid(confid);
        if(null==conf){
            return new PageResult<>(99, "会议不存在");
        }
        String table="tb_conf_people";

        if(ConferenceConstant.CONFTYPE_NOLIST.equals(conf.getConftype())){
            table="tb_nolist_conf_people";
        }

        StringBuffer querySql=new StringBuffer("select a.confid,a.confname,b.custname,b.cardno,d.deptname,b.attstatus,b.atttime,b.custid,b.pid,b.remark,b.insteadcustid,a.conftype,e.custname as insteadcustname,b.atttype from "+table+" b  " +
                "left join tb_conference a on a.confid=b.confid " +
                "left join t_customer c on b.custid=c.custid " +
                "left join tb_dept d on c.deptcode=d.deptcode " +
                "left join t_customer e on b.insteadcustid=e.custid " +
                "where b.confid=:confid and b.atttype!='temp' " +
                "union " +
                "select a.confid,a.confname,b.custname,b.cardno,b.remark as deptname,b.attstatus,b.atttime,b.custid,b.pid,'临时人员' as remark,'' as insteadcustid,a.conftype,'' as insteadcustname,b.atttype  from "+table+" b  " +
                "left join tb_conference a on a.confid=b.confid " +
                "where b.confid=:confid and b.atttype='temp' " );

        StringBuffer countSql = new StringBuffer("select count(*) from "+table+" b  " +
                "left join tb_conference a on a.confid=b.confid " +
                "left join t_customer c on b.custid=c.custid " +
                "left join tb_dept d on c.deptcode=d.deptcode " +
                "left join t_customer e on b.insteadcustid=e.custid " +
                "where b.confid=:confid ");


        if (!StringUtil.isEmpty(attstatus)) {
            querySql.append("and b.attstatus=:attstatus ");
            countSql.append("and b.attstatus=:attstatus ");
        }
        if (!StringUtil.isEmpty(atttype)) {
            querySql.append("and b.atttype=:atttype ");
            countSql.append("and b.atttype=:atttype ");
        }
        querySql.append(" order by cardno ");
        Query query = entityManager.createNativeQuery(querySql.toString());
        Query countQuery = entityManager.createNativeQuery(countSql.toString());

        query.setParameter("confid",confid);
        countQuery.setParameter("confid",confid);
        if (!StringUtil.isEmpty(attstatus)) {
            query.setParameter("attstatus", attstatus);
            countQuery.setParameter("attstatus", attstatus);
        }
        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(ConfpeopleShowBean.class));
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize); //分页显示
        List<ConfpeopleShowBean> list = query.getResultList();
        BigInteger count = (BigInteger) countQuery.getSingleResult();
        return new PageResult<>(count.longValue(), list);
    }

    @Override
    public PageResult<ConfpeopleReportBean> getConfPeopleReport(Integer confid,String searchkey, String attstatus, String deptcode,String attflag) {
        TConference conf=conferenceDao.findByConfid(confid);
        if(null==conf){
            return null;
        }
        String table="tb_conf_people";

        if(ConferenceConstant.CONFTYPE_NOLIST.equals(conf.getConftype())){
            table="tb_nolist_conf_people";
        }

        StringBuffer querySql=new StringBuffer("select b.custname,d.deptname,b.attstatus,b.atttime,b.remark,e.custname as insteadcustname,b.atttype from "+table+" b  " +
                "left join tb_conference a on a.confid=b.confid " +
                "left join t_customer c on b.custid=c.custid " +
                "left join tb_dept d on c.deptcode=d.deptcode " +
                "left join t_customer e on b.insteadcustid=e.custid " +
                "where b.confid=:confid and b.atttime is "+attflag +" null and b.atttype !='temp' " );
        if(!StringUtil.isEmpty(attflag)){
            querySql.append("union " +
                    "select b.custname,b.remark as deptname,b.attstatus,b.atttime,'' as remark,'' as insteadcustname,b.atttype from "+table+" b  " +
                    "where b.confid=:confid and b.atttype ='temp' ");
        }
        if (!StringUtil.isEmpty(attstatus)) {
            querySql.append(" and b.attstatus=:attstatus ");
        }
        if(!StringUtil.isEmpty(deptcode)){
            List<String> deptlist=customerDao.getChildDeptlist(deptcode);
            if(!StringUtil.isEmpty(deptlist)){
                querySql.append(" and d.deptcode in ('"+ StringUtils.join(deptlist.toArray(),"','")+"') ");
            }
        }
        if(!StringUtil.isEmpty(searchkey)){
            querySql.append("and b.custname=:searchkey");
        }
        querySql.append(" order by atttime ");



        Query query = entityManager.createNativeQuery(querySql.toString());
        query.setParameter("confid",confid);
        if(!StringUtil.isEmpty(searchkey)){
            query.setParameter("searchkey", searchkey);
        }
        if(!StringUtil.isEmpty(attstatus)){
            query.setParameter("attstatus", attstatus);
        }

        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(ConfpeopleReportBean.class));
        List<ConfpeopleReportBean> list = query.getResultList();
        return  new PageResult<>(list);
    }


    @Override
    public TConfPeople getTConfPeopleByConfidAndCustid(Integer confid, String custid) {
        return confPeopleDao.findByConfidAndCustid(confid,custid);
    }

    @Override
    public TNolistConfPeople getNolistConfPeopleByConfidAndCustid(Integer confid, String custid) {
        return nolistConfPeopleDao.findByConfidAndCustid(confid,custid);

    }

    @Override
    public Integer getConfPeopleActualCount(Integer confid) {
        List<String> list = new ArrayList<>();
        list.add(ConferenceConstant.ATTENDSTATUS_CHECKED);
        list.add(ConferenceConstant.ATTENDSTATUS_HANDCHECK);
        list.add(ConferenceConstant.ATTENDSTATUS_LATE);
        return confPeopleDao.countByConfidAndAttstatusInAndAtttypeNot(confid,list,ConferenceConstant.ATTTYPE_TEMP);
    }

    @Override
    public Integer getListConfPeopleTotalCount(Integer confid) {
        List<String> list = new ArrayList<>();
        list.add(ConferenceConstant.ATTENDSTATUS_INSTEAD);
        list.add(ConferenceConstant.ATTENDSTATUS_CLOSED);

        return confPeopleDao.countByConfidAndAttstatusNotInAndAtttypeNot(confid,list,ConferenceConstant.ATTTYPE_TEMP);
    }

    @Override
    public Integer getNolistConfPeopleCount(Integer confid) {
        return nolistConfPeopleDao.countByConfid(confid);
    }

    @Override
    public List<ConfPeopleApiBean> getConfPeopleListByDevphyid(String devphyid, String confdate) {
        StringBuffer querySql=new StringBuffer("select a.custname,a.attstatus,a.atttime from tb_conf_people a " +
                "left join tb_conference b on a.confid=b.confid  " +
                "left join tb_conference_devbind c on b.confid=c.confid " +
                "left join t_nc_device d on c.deviceid=d.deviceid " +
                "where b.confdate=:confdate and d.devphyid=:devphyid " +
                "UNION  " +
                "select a.custname,a.attstatus,a.atttime from tb_nolist_conf_people a " +
                "left join tb_conference b on a.confid=b.confid  " +
                "left join tb_conference_devbind c on b.confid=c.confid " +
                "left join t_nc_device d on c.deviceid=d.deviceid " +
                "where b.confdate=:confdate and d.devphyid=:devphyid");


        Query query = entityManager.createNativeQuery(querySql.toString());
        query.setParameter("devphyid",devphyid);
        query.setParameter("confdate",confdate);
        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(ConfPeopleApiBean.class));
        List<ConfPeopleApiBean> list = query.getResultList();
        return list;
    }

    @Override
    public List<ConfPeopleApiBean> getConfPeopleListByConfid(Integer confid, String conftype) {
        String table="tb_conf_people";
        if(ConferenceConstant.CONFTYPE_NOLIST.equals(conftype)){
            table="tb_nolist_conf_people";
        }
        StringBuffer querySql=new StringBuffer("select a.custname,a.attstatus,a.atttime,c.deptname,d.custtypename from "+table+" a " +
                "left join t_customer b on a.custid=b.custid " +
                "left join tb_dept c on b.deptcode=c.deptcode " +
                "left join tb_custtype d on b.custtypeid=d.custtypeid "+
                    "where a.atttime is not null and a.atttype != 'temp' and a.confid=:confid " +
                "UNION "+
                "select a.custname,a.attstatus,a.atttime,a.remark as deptname," +
                "'临时人员' as custtypename from "+table+" a "+
                "where  confid=:confid and a.atttype='temp'");
        Query query = entityManager.createNativeQuery(querySql.toString());
        query.setParameter("confid",confid);
        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(ConfPeopleApiBean.class));
        List<ConfPeopleApiBean> list = query.getResultList();
        return list;

    }


    private String checkConfTimeError(String attendtime, String endtime,String confdate,String cardno) {
        Query query = entityManager.createNativeQuery("select a.confname from tb_conference a,TB_Conf_People b where a.confid=b.confid  " +
                "and  (a.status='unstart' or a.status='start') " +
                "and b.cardno=:cardno " +
                "and a.confdate=:confdate " +
                "and ((:attendtime between a.attendtime and a.endtime) or (:endtime between a.attendtime and a.endtime) or (a.attendtime>:attendtime and a.endtime<:endtime)) ");
        query.setParameter("cardno", cardno);
        query.setParameter("confdate", confdate);
        query.setParameter("attendtime", attendtime);
        query.setParameter("endtime", endtime);
        List<String> confname = query.getResultList();
        if(!StringUtil.isEmpty(confname)){
            return confname.get(0);
        }
        return null;
    }

    private String checkTimeErrorDevice(String attendtime, String endtime,String confdate,Integer deviceid) {
        Query query = entityManager.createNativeQuery("select c.devname from tb_conference a " +
                "left join tb_conference_devbind b on a.confid=b.confid " +
                "left join t_nc_device c on b.deviceid=c.deviceid " +
                "where (a.status='unstart' or a.status='start') " +
                "and b.deviceid=:deviceid " +
                "and a.confdate=:confdate " +
                "and ((:attendtime between a.attendtime and a.endtime) or (:endtime between a.attendtime and a.endtime) or (a.attendtime>:attendtime and a.endtime<:endtime)) ");
        query.setParameter("deviceid", deviceid);
        query.setParameter("confdate", confdate);
        query.setParameter("attendtime", attendtime);
        query.setParameter("endtime", endtime);
        List<String> confname = query.getResultList();
        if(!StringUtil.isEmpty(confname)){
            return confname.get(0);
        }
        return null;
    }

    private Integer checkNolistDeptCustomer(Integer confid) {
        Query query = entityManager.createNativeQuery("select count(t.custid) from t_customer t " +
                "where t.deptcode in (select distinct d.deptcode from tb_conf_people p left join t_customer t " +
                "on p.custid=t.custid left join tb_dept d on d.deptcode=t.deptcode where confid=:confid)");
        query.setParameter("confid", confid);
        BigInteger cnt = (BigInteger) query.getSingleResult();
        System.out.println("cnt:::"+cnt);

        return cnt.intValue();
    }


}
