package com.supwisdom.dlpay.conference.task;

import com.supwisdom.dlpay.api.bean.CardsResponse;
import com.supwisdom.dlpay.api.bean.CitizenCardInfo;
import com.supwisdom.dlpay.api.bean.QueryCardsParam;
import com.supwisdom.dlpay.app.bean.CustomerInfo;
import com.supwisdom.dlpay.conference.domain.TConfDtl;
import com.supwisdom.dlpay.conference.domain.TConfPeople;
import com.supwisdom.dlpay.conference.domain.TConference;
import com.supwisdom.dlpay.conference.domain.TNolistConfPeople;
import com.supwisdom.dlpay.conference.service.ConferenceService;
import com.supwisdom.dlpay.conference.util.ConferenceConstant;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.doorlist.service.DoorlistMgrService;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.domain.TCard;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.paysdk.ApiLoginHelper;
import com.supwisdom.dlpay.paysdk.proxy.ApiLoginProxy;
import com.supwisdom.dlpay.paysdk.proxy.UserProxy;
import com.supwisdom.dlpay.system.domain.TSystemParam;
import com.supwisdom.dlpay.system.service.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Configuration      //1.主要用于标记配置类，兼备Component的效果。
@EnableScheduling   // 2.开启定时任务
public class ConferenceTask {

    protected static Logger logger = LoggerFactory.getLogger(ConferenceTask.class);


    @Autowired
    private ConferenceService conferenceService;
    @Autowired
    private WebInterfaceService webInterfaceService;

    @Scheduled(cron = "${conference.updatestatus.cron}")//每分钟执行一次
    private void UpdateConferenceStatus(){
        String confdate=DateUtil.getNow("yyyyMMdd");
        String timenow=DateUtil.getNow("HHmm");
        List<TConference> unstartconf=conferenceService.getConferenceByDateAndStatus(confdate, ConferenceConstant.CONFSTATUS_UNSTART);
        if(null!=unstartconf){
            logger.info("开始更新未开始会议");
            for(TConference conf:unstartconf){
                int compare=DateUtil.compareDatetime(timenow,conf.getStarttime(),"HHmm");
                if(0<=compare){
                    conf.setStatus(ConferenceConstant.CONFSTATUS_START);
                    conferenceService.updateConference(conf);
                }
            }
        }
        List<TConference> startconf=conferenceService.getConferenceByDateAndStatus(confdate, ConferenceConstant.CONFSTATUS_START);
        if(null!=startconf){
            logger.info("开始更新已开始会议");
               for(TConference conf:startconf){
                   int compare=DateUtil.compareDatetime(timenow,conf.getEndtime(),"HHmm");
                   if(0<=compare){
                    conf.setStatus(ConferenceConstant.CONFSTATUS_OVER);
                    conferenceService.updateConference(conf);
                }
            }
        }
    }

  /*  @Scheduled(cron = "${conference.uploaddtl.cron}")//每10秒执行一次
    private void uploadConfDtl(){
        List<TConfDtl> dtllist=conferenceService.getUnupdateConfDtl();
        if(!StringUtil.isEmpty(dtllist)){
            for(TConfDtl dtl:dtllist){
                TConference conference=conferenceService.getConferenceById(dtl.getConfid());
                if(null==conference){
                    logger.error(dtl.getCustname()+"所属会议不存在");
                    dtl.setUpdateflag(ConferenceConstant.CONFDTL_STATUS_UPDATED);
                    dtl.setRemark(dtl.getCustname()+"所属会议不存在");
                    conferenceService.saveConfDtl(dtl);
                    continue;
                }
                TCustomerInfo info=webInterfaceService.getTCustomerByExcel(dtl.getCardno());
                if(null==info){
                    logger.error(dtl.getCustname()+"不存在");
                    dtl.setUpdateflag(ConferenceConstant.CONFDTL_STATUS_UPDATED);
                    dtl.setRemark(dtl.getCustname()+"不存在");
                    conferenceService.saveConfDtl(dtl);
                    continue;
                }

                String atttime=dtl.getAtttime();

                int compareAttend=DateUtil.compareDatetime(atttime,conference.getAttendtime(),"HHmm");
                int compareStart=DateUtil.compareDatetime(atttime,conference.getStarttime(),"HHmm");

                if(-1==compareAttend){
                    continue;
                }
                String attstatus;
                if(-1==compareStart){
                    attstatus= ConferenceConstant.ATTENDSTATUS_CHECKED;
                }else{
                    attstatus=ConferenceConstant.ATTENDSTATUS_LATE;
                }
                if(ConferenceConstant.CONFTYPE_NOLIST.equals(conference.getConftype())){
                    TNolistConfPeople people=new TNolistConfPeople();

                    people.setAttstatus(attstatus);
                    people.setCardno(dtl.getCardno());
                    people.setConfid(dtl.getConfid());
                    people.setCustid(dtl.getCustid());
                    people.setAtttime(atttime);
                    people.setCustname(dtl.getCustname());
                    people.setAtttype(ConferenceConstant.ATTTYPE_SELF);
                    people.setLastsaved(DateUtil.getNow());
                    conferenceService.saveNolistConfPeople(people);
                }else{
                    TConfPeople people=conferenceService.getTConfPeopleByConfidAndCustid(dtl.getConfid(),dtl.getCustid());
                    if(null==people){
                        logger.error(dtl.getCustname()+"在会议中不存在");
                        dtl.setUpdateflag(ConferenceConstant.CONFDTL_STATUS_UPDATED);
                        dtl.setRemark(dtl.getCustname()+"在会议中不存在");
                        conferenceService.saveConfDtl(dtl);
                        continue;
                    }
                    people.setAttstatus(attstatus);
                    people.setAtttime(atttime);
                    conferenceService.saveConfPeople(people);
                }
                dtl.setUpdateflag(ConferenceConstant.CONFDTL_STATUS_UPDATED);
                conferenceService.saveConfDtl(dtl);
            }
        }

    }*/

}
