package com.supwisdom.dlpay.customer.controller;


import cn.afterturn.easypoi.entity.vo.NormalExcelConstants;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.view.PoiBaseView;
import com.google.gson.Gson;
import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.api.bean.QueryUserParam;
import com.supwisdom.dlpay.api.bean.UserInforResponse;
import com.supwisdom.dlpay.customer.bean.CustomerSaveBean;
import com.supwisdom.dlpay.customer.bean.CustomerSearchBean;
import com.supwisdom.dlpay.customer.bean.TCustomerExportBean;
import com.supwisdom.dlpay.doorlist.bean.CustomerListBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.mainservice.bean.TDoordtlInfo;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.paysdk.proxy.UserProxy;
import com.supwisdom.dlpay.system.bean.TreeSelectNode;
import com.supwisdom.dlpay.system.domain.TCustType;
import com.supwisdom.dlpay.system.domain.TDept;
import com.supwisdom.dlpay.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/customer")
public class CustomerController {


    @Autowired
    private UserProxy userProxy;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WebInterfaceService webInterfaceService;

    @RequestMapping("/index")
    public String indexView(ModelMap model) {
        List<TCustType> lst = systemService.findAllCusttype();
        List<TDept> dept = systemService.findAllDept();
        Gson gson = new Gson();
        String deptString = gson.toJson(dept);
        model.put("deptlist", deptString);
        String typeString = gson.toJson(lst);
        model.put("custtypelist", typeString);

        return "doorlist/customer/index";
    }

    @RequestMapping("/list")
    @ResponseBody
    public PageResult<TCustomerInfo> getDataList(@RequestParam("page") Integer pageNo,
                                                 @RequestParam("limit") Integer pageSize,
                                                 @RequestParam(value = "custname", required = false) String custname,
                                     //            @RequestParam(value = "deptcode", required = false) String deptcode,
                                                 @AuthenticationPrincipal TOperator operUser) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            CustomerSearchBean searchBean = new CustomerSearchBean();
            searchBean.setPageNo(pageNo);
            searchBean.setCustname(custname);
            searchBean.setPageSize(pageSize);
            String deptcode="";
            if (StringUtil.isEmpty(deptcode)&&!"S".equals(operUser.getOpertype())) {
                deptcode = operUser.getDeptcode();
            }
            searchBean.setDeptcode(deptcode);

            PageResult<TCustomerInfo> bean = webInterfaceService.getCustomerInfoPage(searchBean);

            return bean;
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }


    @GetMapping("/loadadd")
    public String loadadd(Model model) {
        List<TCustType> list = systemService.findAllCusttype();
        model.addAttribute("typelist", list);
        List<TDept> deptlist = systemService.findAllDept();
        model.addAttribute("deptlist", deptlist);

        return "doorlist/customer/form";
    }

    @PostMapping("/add")
    @ResponseBody
    public JsonResult add(@RequestBody CustomerListBean customer,
                          @AuthenticationPrincipal TOperator operUser) {
        if (customer != null) {
            String operid = operUser.getOperid();
            String now = DateUtil.getNow();
            QueryUserParam queryUserParam = new QueryUserParam();
            queryUserParam.setCitizencardno(customer.getCardno());
            UserInforResponse response = userProxy.querybycardno(queryUserParam);
            if (response.getRetcode() != 0) {
                return JsonResult.error("核心平台验证人员失败：" + response.getRetmsg());
            }
            webInterfaceService.doSaveCustomerAndCard(operid, now, customer, response);
            return JsonResult.ok();
        } else {
            return JsonResult.error("添加失败");
        }
    }

    @PostMapping("/delete")
    @ResponseBody
    public JsonResult delete(@RequestParam String custid) {
        boolean flag = webInterfaceService.deleteCustomer(custid);
        if (flag) {
            return JsonResult.ok();
        }
        return JsonResult.error("删除失败");
    }


    @GetMapping("/depttree")
    @ResponseBody
    public List<TreeSelectNode> searchDeptTree() {
        List<TreeSelectNode> tree = systemService.getDeptSelectTree();
        return tree;
    }

    @ResponseBody
    @RequestMapping(value = "/exportexcel")
    public void exportexcel(HttpServletRequest request, HttpServletResponse response,
                            @RequestParam(value = "custname", required = false, defaultValue = "all") String custname,
                            @AuthenticationPrincipal TOperator operUser) {

        Map map = new HashMap();
        try {
            /**
             * 1. 查询数据
             */
            // final int max_field = 9;
            // 保存表字段
            List<TCustomerExportBean> bean = null;
            String deptcode="";
            if(!"S".equals(operUser.getOpertype())){
                deptcode=operUser.getDeptcode();
            }
            bean=webInterfaceService.getCustomerExportBean(custname,deptcode);

            /**
             * 2.设置表格属性: title:标题  sheetName:工作簿名 type:表格类型
             */
            ExportParams params = new ExportParams("人员表", "人员", ExcelType.XSSF);
//		params.setFreezeCol(2);
            map.put(NormalExcelConstants.DATA_LIST, bean);//设置值
            map.put(NormalExcelConstants.PARAMS, params);//设置属性
            map.put(NormalExcelConstants.CLASS, TCustomerExportBean.class);
            map.put(NormalExcelConstants.FILE_NAME, "设备流水名单");
            PoiBaseView.render(map, request, response, NormalExcelConstants.EASYPOI_EXCEL_VIEW);

        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "导出excel文件失败");
        }

    }
}
