/*
package com.supwisdom.dlpay.customermanage.controller;


import com.google.gson.Gson;
import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.framework.util.ExportExcel;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.restaurant.bean.CustomerSaveBean;
import com.supwisdom.dlpay.restaurant.bean.CustomerSearchBean;
import com.supwisdom.dlpay.restaurant.bean.CustomerShowBean;
import com.supwisdom.dlpay.restaurant.domain.TCustType;
import com.supwisdom.dlpay.restaurant.service.CustTypeService;
import com.supwisdom.dlpay.restaurant.service.CustomerService;
import com.supwisdom.dlpay.restaurant.util.RestaurantConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/customer")
public class CustomerController {

    @Autowired
    private CustomerService customerService;

    @Autowired
    private CustTypeService custTypeService;

    @RequestMapping("/index")
    public String indexView(ModelMap model) {
        List<TCustType> lst = custTypeService.findAll();
        Map<Integer, String> map = new HashMap<>();
        for (TCustType type : lst) {
            map.put(type.getCusttypeid(), type.getCusttypename());
        }
        Gson gson = new Gson();
        String gsonString = gson.toJson(map);
        model.put("custtypelist", gsonString);

        return "restaurant/customer/index";
    }

    @RequestMapping("/list")
    @PreAuthorize("hasPermission('/customer/list','')")
    @ResponseBody
    public PageResult<CustomerShowBean> getDataList(@RequestParam("page") Integer pageNo,
                                                    @RequestParam("limit") Integer pageSize,
                                                    @RequestParam(value = "searchkey", required = false) String searchKey) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            CustomerSearchBean searchBean = new CustomerSearchBean();
            searchBean.setPageNo(pageNo);
            searchBean.setCustname(searchKey);
            searchBean.setPageSize(pageSize);
            PageResult<CustomerShowBean> bean= customerService.getCustomerPage(searchBean);

            return bean;
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }


    @GetMapping("/loadadd")
    @PreAuthorize("hasPermission('/customer/loadadd','')")
    public String loadadd(Model model) {
        List<TCustType> list=custTypeService.findAll();
        model.addAttribute("typelist",list);
        return "restaurant/customer/form";
    }

    @PostMapping("/add")
    @PreAuthorize("hasPermission('/customer/add','')")
    @ResponseBody
    public JsonResult add(@RequestBody CustomerSaveBean customer) {
        if (customer != null) {
            customer.setSavecardflag(0);
            customer.setStatus(RestaurantConstant.STATUS_CARD_NORMAL);
            customer.setCheckstatus(RestaurantConstant.STATUS_CHECKSTATUS_UNCHECK);
            return customerService.saveCustomer(customer);
        } else {
            return JsonResult.error("添加失败");
        }
    }

    @PostMapping("/delete")
    @PreAuthorize("hasPermission('/customer/delete','')")
    @ResponseBody
    public JsonResult delete(@RequestParam String  custid) {
        return customerService.deleteCustomer(custid);
    }


    @GetMapping("/loadimport")

    @PreAuthorize("hasPermission('/customer/loadimport','')")

    public String loadimport(Model model) {
        return "restaurant/customer/import";
    }


    @RequestMapping("/download")
    @PreAuthorize("hasPermission('/customer/download','')")
    @ResponseBody
    public JsonResult downloadfile(HttpServletRequest request, HttpServletResponse response) throws Exception{
        String[] titles0 = {"姓名",	"市名卡号",	"市名卡银行卡号","人员类别号","手机（选填）"
        }; //表头
        String[][] info0 = {{"张三",	"123456",	"3000000","1","12341234123"
        }}; // 示例内容
        String fileName0 = "客户导入模板";// 保存数据

        try {
            ExportExcel.queryexcel(fileName0, titles0,info0,request, response);
            return JsonResult.ok("操作成功");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return JsonResult.error("操作失败");
    }

    @PostMapping("/import")
    @PreAuthorize("hasPermission('/customer/import','')")
    @ResponseBody
    public JsonResult importFile(@RequestParam(value = "file",required = false) MultipartFile file, HttpServletRequest request) throws Exception{
//    System.out.println("---------under the upload file:"+file);
        return customerService.importFile(file,request);
    }


    @RequestMapping("/export")
    @ResponseBody
    public JsonResult exportCustomerExcel(
                                   HttpServletRequest request, HttpServletResponse response) {

        return customerService.export( request, response);
    }


}
*/
