package com.supwisdom.dlpay.framework.core;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JwtConfig {
  @Value("${jwt.secret}")
  private String secret;
  @Value("${jwt.expiration:3600}")
  private Long expiration = 3600L;
  @Value("${jwt.header:Authorization}")
  private String header = "Authorization";
  @Value("${jwt.token_header:Bearer }")
  private String tokenHeader = "Bearer";

  public String getSecret() {
    return secret;
  }

  public Long getExpiration() {
    return expiration;
  }

  public String getHeader() {
    return header;
  }

  public String getTokenHeader() {
    return tokenHeader;
  }
}
