package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TOperRole;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface OperRoleDao extends JpaRepository<TOperRole, String> {

  @Query(value = "select distinct rolecode from TB_OPER_ROLE a,TB_ROLE b where a.roleid=b.roleid and a.operid=?1", nativeQuery = true)
  List<String> getRolecodeByOperid(String operid);

  void deleteByRoleId(String roleId);

  List<TOperRole> findAllByOperid(String operid);

  void deleteByOperid(String operid);
}
