package com.supwisdom.dlpay.framework.domain;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;

public class TPeriodPK implements Serializable {

  @Id
  @Column(name="PERIOD_YEAR", nullable = false, precision = 4)
  private Integer periodYear;

  @Id
  @Column(name="PERIOD_MONTH", nullable = false, precision = 2)
  private Integer periodMonth;

  public Integer getPeriodYear() {
    return periodYear;
  }

  public void setPeriodYear(Integer periodYear) {
    this.periodYear = periodYear;
  }

  public Integer getPeriodMonth() {
    return periodMonth;
  }

  public void setPeriodMonth(Integer periodMonth) {
    this.periodMonth = periodMonth;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TPeriodPK tPeriodPK = (TPeriodPK) o;
    if (periodYear != null ? !periodYear.equals(tPeriodPK.getPeriodYear()) : periodYear != null)
      return false;
    if (periodMonth != null ? !periodMonth.equals(tPeriodPK.getPeriodMonth()) : periodMonth != null)
      return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = periodYear != null ? periodYear.hashCode() : 0;
    result = 31 * result + (periodMonth != null ? periodMonth.hashCode() : 0);
    return result;
  }
}
