package com.supwisdom.dlpay.mainservice.dao;

import com.supwisdom.dlpay.customer.bean.CustomerSearchBean;
import com.supwisdom.dlpay.customer.bean.TCustomerExportBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerImportBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.mainservice.domain.TCustomer;

import java.util.List;

public interface CustomerDao {

    public TCustomer findCustomerByNo(String cardno);

    public TCustomer findCustomerById(String custid);

    public boolean saveCustomer(TCustomer bean);

    public List<TCustomerInfo> getAllTCustomerList(String perName, String cardno, String bankcardno,String custid);

    public TCustomerInfo getTCustomerByExcel(String cardno);

    public PageResult<TCustomerInfo> getCustomerInfoPage(CustomerSearchBean param);

    public PageResult<TCustomerImportBean> getCustomerInfo(CustomerSearchBean param);

    boolean deleteCustomer(String custid);

    List<TCustomerExportBean> getCustomerExportList(String custname,String deptcode);

    List<String> getChildDeptlist( String deptcode) ;

    }
