package com.supwisdom.dlpay.mainservice.dao.impl;

import com.supwisdom.dlpay.mainservice.dao.CardDao;
import com.supwisdom.dlpay.mainservice.domain.TCard;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class CardDaoImpl implements CardDao {
    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public TCard findCardByCustid(String custid) {
        String sql = "select bean from TCard bean where bean.custid = :custid ";
        TypedQuery<TCard> query = entityManager.createQuery(sql, TCard.class);
        query.setParameter("custid", custid);
        List<TCard> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean saveCard(TCard bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public TCard findCardByCardno(String cardno) {
        String sql = "select bean from TCard bean where bean.cardno = :cardno ";
        TypedQuery<TCard> query = entityManager.createQuery(sql, TCard.class);
        query.setParameter("cardno", cardno);
        List<TCard> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateCard(TCard bean) {
        boolean flag = false;
        try {
            entityManager.merge(bean);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
}
