package com.supwisdom.dlpay.mainservice.dao.impl;

import com.supwisdom.dlpay.customer.bean.CustomerSearchBean;
import com.supwisdom.dlpay.customer.bean.TCustomerExportBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerImportBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.dao.CustomerDao;
import com.supwisdom.dlpay.mainservice.domain.TCustomer;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.math.BigInteger;
import java.util.List;

@Repository
public class CustomerDaoImpl implements CustomerDao {

    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public TCustomer findCustomerByNo(String cardno) {
        String sql = "select bean from TCustomer bean left join TCard a on a.custid= bean.custid " +
                " where a.cardno=:cardno ";
        TypedQuery<TCustomer> query = entityManager.createQuery(sql, TCustomer.class);
        query.setParameter("cardno", cardno);
        List<TCustomer> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public TCustomer findCustomerById(String custid) {
        String sql = "select bean from TCustomer bean where bean.custid=:custid";
        TypedQuery<TCustomer> query = entityManager.createQuery(sql, TCustomer.class);
        query.setParameter("custid", custid);
        List<TCustomer> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean saveCustomer(TCustomer bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TCustomerInfo> getAllTCustomerList(String perName, String cardno, String bankcardno,String custid) {
        String sql = "select a.custid,a.custname,b.cardno,b.bankcardno,b.cardphyid,b.expiredate,a.custtypeid,a.deptcode from T_Customer a left join t_card b on a.custid = b.custid " +
                " where a.status='1' and b.status='normal' and b.transtatus='normal' ";
        if (!StringUtil.isEmpty(perName)){
            sql += " and a.custname like :perName ";
        }
        if (!StringUtil.isEmpty(cardno)){
            sql +=" and b.cardno like :cardno ";
        }
        if (!StringUtil.isEmpty(bankcardno)){
            sql +=" and b.bankcardno like :bankcardno ";
        }
        if (!StringUtil.isEmpty(custid)){
            sql +=" and a.custid = :custid ";
        }
        sql +=" order by b.cardno desc ";
        Query query = entityManager.createNativeQuery(sql, TCustomerInfo.class);
        if (!StringUtil.isEmpty(perName)){
            query.setParameter("perName", "%"+perName+"%");
        }
        if (!StringUtil.isEmpty(cardno)){
            query.setParameter("cardno", "%"+cardno+"%");
        }
        if (!StringUtil.isEmpty(bankcardno)){
            query.setParameter("bankcardno", "%"+bankcardno+"%");
        }
        if (!StringUtil.isEmpty(custid)){
            query.setParameter("custid", custid);
        }
        List<TCustomerInfo> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public PageResult<TCustomerInfo> getCustomerInfoPage(CustomerSearchBean param) {

        String deptcode=param.getDeptcode();
        List<String> childdplist = getChildDeptlist( deptcode);

        String perName=param.getCustname();
        String sql = "select a.custid,a.custname,a.deptcode,a.custtypeid,b.cardno,b.bankcardno,b.cardphyid,b.expiredate from T_Customer a left join t_card b on a.custid = b.custid " +
                " where a.status='1' and b.status='normal' and b.transtatus='normal' ";
        String countSql = "select count(*) as cnt from T_Customer a left join t_card b on a.custid = b.custid " +
                " where a.status='1' and b.status='normal' and b.transtatus='normal' ";

        if (!StringUtil.isEmpty(perName)){
            sql += " and a.custname like :perName ";
            countSql += " and a.custname like :perName ";
        }
        if (!StringUtil.isEmpty(childdplist)) {
            sql+=" and a.deptcode in ('"+ StringUtils.join(childdplist.toArray(),"','")+"') ";
            countSql+=" and a.deptcode in ('"+ StringUtils.join(childdplist.toArray(),"','")+"') ";

        }

        sql +=" order by b.cardno desc ";


        Query query = entityManager.createNativeQuery(sql);
        Query countQuery = entityManager.createNativeQuery(countSql);
        if (!StringUtil.isEmpty(perName)){
            query.setParameter("perName", "%"+perName+"%");
            countQuery.setParameter("perName", "%"+perName+"%");
        }
        query.setFirstResult((param.getPageNo() - 1) * param.getPageSize());
        query.setMaxResults(param.getPageSize()); //分页显示

        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(TCustomerInfo.class));
        List<TCustomerInfo> list = query.getResultList();
        BigInteger count = (BigInteger) countQuery.getSingleResult();
        return new PageResult<>(count.longValue(), list);
    }

    @Transactional
    @Override
    public PageResult<TCustomerImportBean> getCustomerInfo(CustomerSearchBean param) {

        String deptcode=param.getDeptcode();
        List<String> childdplist = getChildDeptlist( deptcode);

        String perName=param.getCustname();
        String sql = "select a.custid,a.custname,c.deptname,b.cardno from T_Customer a " +
                "left join t_card b on a.custid = b.custid " +
                "left join tb_dept c on a.deptcode=c.deptcode" +
                " where a.status='1' and b.status='normal' and b.transtatus='normal' ";

        if (!StringUtil.isEmpty(perName)){
            sql += " and a.custname like :perName ";
        }
        if (!StringUtil.isEmpty(childdplist)) {
            sql+=" and a.deptcode in ('"+ StringUtils.join(childdplist.toArray(),"','")+"') ";
        }

        sql +=" order by b.cardno desc ";

        Query query = entityManager.createNativeQuery(sql);
        if (!StringUtil.isEmpty(perName)){
            query.setParameter("perName", "%"+perName+"%");
        }
        query.setFirstResult((param.getPageNo() - 1) * param.getPageSize());
        query.setMaxResults(param.getPageSize()); //分页显示
        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(TCustomerImportBean.class));
        List<TCustomerImportBean> list = query.getResultList();
        return new PageResult<>( list);
    }

    public List<String> getChildDeptlist( String deptcode) {
        List<String> childdplist=null;
        if (!StringUtil.isEmpty(deptcode)) {
            Query chirdGroupQuery = entityManager.createNativeQuery("WITH RECURSIVE r AS(" +
                    "SELECT * FROM tb_dept WHERE deptcode =:deptcode " +
                    "union ALL " +
                    "SELECT t.* FROM tb_dept t, r WHERE t.fdeptcode = r.deptcode) " +
                    "select deptcode from r order by deptno");
            chirdGroupQuery.setParameter("deptcode", deptcode);
            childdplist = chirdGroupQuery.getResultList(); //递归查询所有的子节点
        }
        return childdplist;
    }

    @Transactional
    @Override
    public TCustomerInfo getTCustomerByExcel(String cardno) {
        String sql = "select a.custid,a.custname,b.cardno,b.bankcardno,b.cardphyid,b.expiredate,a.deptcode,a.custtypeid from t_customer a,t_card b  " +
                " where a.custid = b.custid and b.status = 'normal' and b.transtatus='normal' and cardno=?1 ";
        Query query = entityManager.createNativeQuery(sql, TCustomerInfo.class);
        query.setParameter(1, cardno);
        List<TCustomerInfo> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean deleteCustomer(String custid){
        boolean flag = false;
        try {
            String sql = "delete from TCustomer t where t.custid=?1";
            Query query = entityManager.createQuery(sql);
            query.setParameter(1, custid);
            query.executeUpdate();
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    public List<TCustomerExportBean> getCustomerExportList(String custname,String deptcode) {
        List<String> childdplist= getChildDeptlist( deptcode);
        String sql = "select a.custname,a.deptname,a.custtypename,b.cardno,b.bankcardno,b.cardphyid from T_Customer a left join t_card b on a.custid = b.custid " +
                " where a.status='1' and b.status='normal' and b.transtatus='normal' ";

        if (!StringUtil.isEmpty(custname)){
            sql += " and a.custname like :perName ";
        }
        if (!StringUtil.isEmpty(childdplist)) {
            sql+=" and a.deptcode in ('"+ StringUtils.join(childdplist.toArray(),"','")+"') ";

        }
        sql +=" order by b.cardno desc ";

        Query query = entityManager.createNativeQuery(sql);
        if (!StringUtil.isEmpty(custname)){
            query.setParameter("perName", "%"+custname+"%");
        }

        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(TCustomerExportBean.class));
        List<TCustomerExportBean> list = query.getResultList();
        return list;
    }
}
