package com.supwisdom.dlpay.mainservice.service;

import com.supwisdom.dlpay.api.bean.UserInforResponse;
import com.supwisdom.dlpay.customer.bean.CustomerSearchBean;
import com.supwisdom.dlpay.customer.bean.TCustomerExportBean;
import com.supwisdom.dlpay.doorlist.bean.CustomerListBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerImportBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.mainservice.bean.TDoorcardlstInfo;
import com.supwisdom.dlpay.mainservice.bean.TDoordtlInfo;
import com.supwisdom.dlpay.mainservice.domain.TCard;
import com.supwisdom.dlpay.mainservice.domain.TCustomer;
import com.supwisdom.dlpay.mainservice.domain.TKey;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface WebInterfaceService {

    //获取所有厂商
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TKey> getAllKeys() throws Exception;


    /*cardlist*********************/

    //根据查询条件分页获取所有设备内名单信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getSystemCardListFrSearch(String allocatStartDate, String allocatEndDate,
                                             String devname, String custname, String cardno, String syncflag,String operflag, String buildingid,String regionid, int pageNo, int pageSize);

    //根据查询条件分页获取管理员权限的设备内名单信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getOperatorCardListFrSearch(String allocatStartDate, String allocatEndDate,
                                                  String devname, String custname, String cardno, String syncflag,String operflag, String buildingid,String regionid, int pageNo, int pageSize,String operRegionid);

    //根据查询条件分页获取楼栋管理员权限下的设备内名单信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getBuildingOperCardListFrSearch(String allocatStartDate, String allocatEndDate,
                                                      String devname, String custname, String cardno, String syncflag,String operflag, String buildingid,String operid, int pageNo, int pageSize);


    //根据查询条件获取系统管理员所有导出表单信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class},readOnly = true)
    public List<TDoorcardlstInfo> getSystemCardListMap( String allocatStartDate, String allocatEndDate,
                                                    String devname, String custname, String cardno, String syncflag, String operflag, String buildingid,String regionid);

    //根据查询条件获取区域管理员所有导出表单信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class},readOnly = true)
    public List<TDoorcardlstInfo> getOperatorCardListMap( String allocatStartDate, String allocatEndDate,
                                                       String devname, String custname, String cardno, String syncflag, String operflag, String buildingid,String regionid,String operRegionid);

    //根据查询条件获取楼栋管理员所有导出表单信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class},readOnly = true)
    public List<TDoorcardlstInfo> getBuildingOperCardListMap( String allocatStartDate, String allocatEndDate,
                                                          String devname, String custname, String cardno, String syncflag, String operflag, String buildingid,String operid);

    //根据名单编号将已同步的名单修改为未同步使其重新同步
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public void updateDoorcardlstToNoWithIds (List<Long> listIds);


    /*doordtl******************/

    //根据查询条件获取所有导出Excel数据
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TDoordtlInfo> findSystemExportExcelDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno,
                                                     String custname, String buildingid, String regionid, String devname, String streamstatus);

    //根据查询条件获取管理员权限的Excel数据
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TDoordtlInfo> findOperatorExportExcelDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno,
                                                             String custname, String buildingid, String regionid, String devname, String streamstatus,String operRegionid);

    //根据查询条件获取楼栋管理员权限的Excel数据
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TDoordtlInfo> findBuildingOperExportExcelDoorDtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno,
                                                                     String custname, String buildingid,String devname, String streamstatus,String operid);

    //根据查询条件获取系统管理员流水数据
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination findSystemTDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno,
                                         String custname, String buildingid, String devname, String streamstatus, int pageNo, int pageSize,String regionid);

    //根据查询条件获取区域管理员权限相应流水数据
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination findOperatorTDoordtl(
            String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno,
            String custname, String buildingid, String devname, String streamstatus, int pageNo, int pageSize,String regionid,String operRegionid);

    //根据查询条件获取楼栋管理员权限相应流水数据
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination findBuildingOperTDoordtl(
            String startTranDate, String endTranDate, String startTranTime, String endTranTime, String cardno,
            String custname, String buildingid, String devname, String streamstatus, int pageNo, int pageSize,String operid);


    /*customer*********************/

    //根据卡号查询是否存在customer
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TCustomer findCustomerByNo(String cardno);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    //根据用户id查询是否存在customer
    public TCustomer findCustomerById(String custid);

    //保存客户
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveCustomer(TCustomer bean);

    //根据查询条件获取所有要下发的客户
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TCustomerInfo> getAllTCustomerList(String perName, String cardno, String bankcardno);


    /*card************************/

    //根据客户id获取其卡信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TCard findCardByCustid(String custid);

    //保存卡信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveCard(TCard bean);

    //根据excel卡号信息获取客户信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TCustomerInfo getTCustomerByExcel(String cardno);

    //根据同步到的市民卡号判断此卡是否导入门禁数据库
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TCard findCardByCardno(String cardno);

    //修改卡信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateCard(TCard bean);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean deleteCustomer(String custid);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public void doSaveCustomerAndCard(String operid, String now, CustomerListBean list, UserInforResponse response) ;

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    PageResult<TCustomerInfo> getCustomerInfoPage(CustomerSearchBean bean);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    PageResult<TCustomerImportBean> getCustomerInfo(CustomerSearchBean bean);

    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    List<TCustomerExportBean> getCustomerExportBean(String custname,String deptcode);


}
