package com.supwisdom.dlpay.ncmgr.controller;

import cn.afterturn.easypoi.entity.vo.MapExcelConstants;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.view.PoiBaseView;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.ncmgr.bean.NcDevBean;
import com.supwisdom.dlpay.ncmgr.bean.NcTimeBean;
import com.supwisdom.dlpay.ncmgr.domain.*;
import com.supwisdom.dlpay.ncmgr.service.NcService;
import com.supwisdom.dlpay.system.domain.TDictionaryId;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.ManagerService;
import com.supwisdom.dlpay.system.service.SystemService;
import com.supwisdom.dlpay.util.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/ncmgr")
public class NcMgrController {
    protected static Logger logger = LoggerFactory.getLogger(NcMgrController.class);

    @Autowired
    private NcService ncService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private ManagerService managerService;

    @RequestMapping("/devindex")
    public String devindex(ModelMap model) {
        return "ncmgr/nc_dev";
    }

    @GetMapping("/timeindex")
    public String timeindex() {
        return "ncmgr/nc_time";
    }

    @GetMapping("/timegrpindex")
    public String timegrpdex() {
        return "ncmgr/nc_timegrp";
    }

    @GetMapping("/weektimeindex")
    public String weektimeindex() {
        return "ncmgr/nc_weektime";
    }

    @RequestMapping("/devweek")
    public String devweek(ModelMap model){
        return "ncmgr/nc_devweek";
    }

    @RequestMapping("/impdevindex")
    public String impdevindex(){
        return "ncmgr/nc_impDev";
    }

    /**
     * 分页查询设备信息
     * @param request
     * @param response
     * @param pageNo
     * @param pageSize
     * @param devname
     * @param buildingid
     * @param regionid
     * @param devtype
     * @return
     */
    @RequestMapping("/loadDevList")
    @ResponseBody
    public Map loadDevList(HttpServletRequest request,
                           HttpServletResponse response,
                           @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                           @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                           @RequestParam(value = "devname", required = false, defaultValue = "") String devname,
                           @RequestParam(value = "buildingid", required = false, defaultValue = "") String buildingid,
                           @RequestParam(value = "regionid",required = false,defaultValue = "") String regionid,
                           @RequestParam(value = "devtype", required = false, defaultValue = "") String devtype,
                           @AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        try{
            String opertype = operUser.getOpertype();
            Pagination page = null;
            List<TRegion> regions = null;
            List<TBuilding> buildings = null;
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))) {
                page = ncService.getSystemNcDeviceWithPage(devname, pageNo, pageSize, map, buildingid, regionid, devtype);
                map.put("PageResult", page);
                regions = systemService.getAllRegions();
                map.put("regions", regions);
                buildings = ncService.getAllBuilding();
                map.put("buildings", buildings);

            }else if (opertype.equals("H") && !StringUtil.isEmpty(operUser.getRegionid())){
                page = ncService.getOperatorNcDeviceWithPage(devname, pageNo, pageSize, buildingid, regionid, devtype,operUser.getRegionid());
                map.put("PageResult", page);
                regions = systemService.getRegionListById(operUser.getRegionid());
                map.put("regions", regions);
                buildings = systemService.getBuildingByRegionId(operUser.getRegionid());
                map.put("buildings", buildings);
            }else if (opertype.equals("L")){
                map.put("regions", regions);
                page = ncService.getBuildingOperNcDeviceWithPage(devname, pageNo, pageSize, buildingid, devtype, operUser.getOperid());
                map.put("PageResult", page);
                buildings = systemService.getBuildingOperBuildings(operUser.getOperid());
                map.put("buildings", buildings);
            }
            List<TDictionaryId> dicts = systemService.findTDictionaryByType(8);
            map.put("dicts", dicts);


        }catch (Exception e){
            e.printStackTrace();
            logger.error("查询设备失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 获取设备信息
     * @param deviceid
     * @return
     */
    @RequestMapping("/loadNcDevForUpdate")
    @ResponseBody
    public Map loadNcDevForUpdate(@RequestParam(value = "deviceid") int deviceid,
                                  @AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        try {
            TNcDevice device = ncService.findDevById(deviceid);
            map.put("device", device);
            List<TDictionaryId> dicts = systemService.findTDictionaryByType(8);//设备类型  C：控制器  R：读头
            map.put("dicts", dicts);
            List<TDictionaryId> devUseType = systemService.findTDictionaryByType(16);//获取设备使用类别
            map.put("devUseType", devUseType);

            String opertype = operUser.getOpertype();
            List<TRegion> regionsfill = null;
            List<TBuilding> buildingsfill = null;
            List<TNcDevice> devices = null;
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                regionsfill = systemService.getAllRegions();
                map.put("regionsfill", regionsfill);
                buildingsfill = ncService.getAllBuilding();
                map.put("buildingsfill", buildingsfill);
                devices = ncService.getSystemDevByType("C");//根据设备类型获取设备
                map.put("devices", devices);
            }else if (opertype.equals("H") && !StringUtil.isEmpty(operUser.getRegionid())){
                regionsfill = systemService.getRegionListById(operUser.getRegionid());
                map.put("regionsfill", regionsfill);
                buildingsfill = systemService.getBuildingByRegionId(operUser.getRegionid());
                map.put("buildingsfill", buildingsfill);
                devices = ncService.getOperatorDevByType("C", operUser.getRegionid());
                map.put("devices", devices);
            }else if (opertype.equals("L") ){
                //楼栋管理员填充区域为所有区域
                regionsfill = systemService.getAllRegions();
                map.put("regionsfill", regionsfill);
                buildingsfill = systemService.getBuildingOperBuildings(operUser.getOperid());
                map.put("buildingsfill", buildingsfill);
                devices = ncService.getBuildingOperDevByType("C", operUser.getOperid());
                map.put("devices", devices);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 根据区域id填充可选楼栋列表
     * @param regionid
     * @return
     */
    @ResponseBody
    @RequestMapping("/getRegionBuilding")
    public Map getRegionBuilding(@RequestParam(value = "regionid") String regionid,@AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        try{
            List<TBuilding> regionBuildings = null;
            if (operUser.getOpertype().equals("L")){
                regionBuildings = systemService.getBuildingOperBuildingByRegionId(regionid, operUser.getOperid());
            }else if(operUser.getOpertype().equals("H") && !StringUtil.isEmpty(operUser.getRegionid())){
                regionBuildings = systemService.getOperatorBuildingByRegionId(regionid,operUser.getRegionid());
            } else {
                regionBuildings = systemService.getBuildingByRegionId(regionid);
            }
            map.put("reBuilding", regionBuildings);
        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }


    /**
     * 添加或修改设备
     * @param postData
     * @param request
     * @param response
     * @return
     */
    @PostMapping("/saveNcDev")
    @ResponseBody
    public Map saveNcDev(@RequestBody NcDevBean postData,
                         HttpServletRequest request, HttpServletResponse response){
        Map map = new HashMap();
        try {
            //需要校验名称，读头编号，物理编号是否重复
            //大于0则更新，否则为新加记录
            TNcDevice device;
            if (postData.getDeviceid()>0) {
                device = ncService.validDevName(postData.getDeviceid(), postData.getDevname());
                if (device != null && device.getDeviceid() > 0) {
                    map.put("errStr", "设备名称已经存在!");
                    return map;
                }
                device = ncService.validDevPhyid(postData.getDeviceid(),postData.getDevphyid());
                if (device !=null && device.getDeviceid()>0){
                    map.put("errStr", "设备物理编号已经存在!");
                    return map;
                }
                if(postData.getDevtype().equals("R")){
                    device = ncService.validDevNo(postData.getFdevid(),postData.getDevno(),postData.getDeviceid());
                    if (device !=null && device.getDeviceid()>0){
                        map.put("errStr", "该控制器下读头号已经存在!");
                        return map;
                    }
                    TNcDevice fDev = ncService.findDevById(postData.getFdevid());
                    TBuilding buidingF = ncService.getBuidingById(fDev.getBuildingid());
                    if (!postData.getBuildingid().equals(buidingF.getBuildingid())){
                        map.put("errStr", "该读头和其控制器读头楼栋不一致!");
                        return map;
                    }
                }

                TNcDevice devUpdate = ncService.findDevById(postData.getDeviceid());
                devUpdate.setDevname(postData.getDevname());
                devUpdate.setDevphyid(postData.getDevphyid());
                devUpdate.setDevtype(postData.getDevtype());
                devUpdate.setFdevid(postData.getFdevid());
                devUpdate.setDevno(postData.getDevno());
                devUpdate.setIp(postData.getIp());
                devUpdate.setOperflag("A");
                devUpdate.setSyncflag("S");
                devUpdate.setUpdtime(DateUtil.getNow());
                devUpdate.setSynctime(DateUtil.getNow());
                devUpdate.setBuildingid(postData.getBuildingid());
                devUpdate.setRegionid(postData.getRegionid());
                TBuilding buiding = ncService.getBuidingById(postData.getBuildingid());
                devUpdate.setBuildingname(buiding.getBuildingname());

                ncService.updateDevice(devUpdate);

                map.put("errStr", "");
            }else {
                //添加设备
                device = ncService.validDevName(0,postData.getDevname());
                if (device !=null && device.getDeviceid()>0){
                    map.put("errStr", "设备名称已经存在!");
                    return map;
                }
                device = ncService.validDevPhyid(0,postData.getDevphyid());
                if (device !=null && device.getDeviceid()>0){
                    map.put("errStr", "设备物理编号已经存在!");
                    return map;
                }
                if(postData.getDevtype().equals("R")){
                    device = ncService.validDevNo(postData.getFdevid(),postData.getDevno(),0);
                    if (device !=null && device.getDeviceid()>0){
                        map.put("errStr", "该控制器下读头号已经存在!");
                        return map;
                    }
                    TNcDevice fDev = ncService.findDevById(postData.getFdevid());
                    TBuilding buidingF = ncService.getBuidingById(fDev.getBuildingid());
                    if (!postData.getBuildingid().equals(buidingF.getBuildingid())){
                        map.put("errStr", "该读头和其控制器读头楼栋不一致!");
                        return map;
                    }
                }
                if(postData.getDevtype().equals("R")){
                    RedisUtil.del("ncdev_" + postData.getDevphyid() + "_" + postData.getDevno());
                    RedisUtil.set("ncdev_" + postData.getDevphyid() + "_" + postData.getDevno(),String.valueOf(postData.getDeviceid()));
                }

                int maxId = ncService.getMaxId();
                TNcDevice devAdd = new TNcDevice();
                devAdd.setDeviceid(maxId+1);
                devAdd.setDevname(postData.getDevname());
                devAdd.setDevphyid(postData.getDevphyid().toUpperCase());
                devAdd.setDevtype(postData.getDevtype());
                devAdd.setFdevid(postData.getFdevid());
                devAdd.setDevno(postData.getDevno());
                devAdd.setIp(postData.getIp());
                devAdd.setBuildingid(postData.getBuildingid());
                TBuilding buiding = ncService.getBuidingById(postData.getBuildingid());
                devAdd.setBuildingname(buiding.getBuildingname());
                devAdd.setRegionid(postData.getRegionid());
                devAdd.setOperflag("A");
                devAdd.setSyncflag("S");
                devAdd.setUpdtime(DateUtil.getNow());
                devAdd.setSynctime(DateUtil.getNow());
                devAdd.setUsetype(postData.getUsetype());
                TNcDevice fdev = ncService.findDevById(postData.getFdevid());
                if(postData.getDevtype().equals("R")){
                    RedisUtil.set("ncdev_" + fdev.getDevphyid() + "_" + postData.getDevno(),String.valueOf(maxId+1));
                }
                ncService.saveDevice(devAdd);
                map.put("errStr", "");
            }
        }catch (Exception e){
            e.printStackTrace();
            map.put("errStr", "添加设备失败！");
            logger.error("添加设备失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 设备删除
     * @param devid
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/deleteNcDev", method = {RequestMethod.GET})
    @ResponseBody
    public Map deleteNcDev(@RequestParam(value = "devid") int devid,
                              HttpServletRequest request, HttpServletResponse response) {
        Map map = new HashMap();
        String message = "";
        try {
            boolean flag = ncService.getDevWeekByDevid(devid);
            if (flag==true){
                message = "该设备已绑定时间周！";
                map.put("message", message);
                return map;
            }
            TNcDevice dev = ncService.getDevInfoByDevid(devid);
            if(dev!=null){
                RedisUtil.del("ncdev_" + dev.getDevphyid() + "_" + dev.getDevno());
                if (dev.getDevtype().equals("C")){
                    List<TNcDevice> listByfDevid = ncService.getDevListByfDevid(dev.getDeviceid());
                    if (listByfDevid!=null && listByfDevid.size()>0){
                        message = "该控制器设备已绑定读头！";
                        map.put("message", message);
                        return map;
                    }
                }
            }

            ncService.delDevById(devid);
            RedisUtil.incr("zcard_max_version");

        } catch (Exception e) {
            e.printStackTrace();
            message = "删除设备出现异常!";
            logger.error("删除设备失败：" + e.getMessage());
        }
        map.put("message", message);
        return map;

    }

    /**
     * 清除设备名单
     * @param devid
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/listClean", method = {RequestMethod.GET})
    @ResponseBody
    public Map listClean(@RequestParam(value = "devid") int devid,
                         HttpServletRequest request, HttpServletResponse response,@AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        String message="";
        try{
            TNcCardlist cleanList = ncService.getCleanList(devid);
            if (cleanList==null) {
                //如果该设备没有清空专用名单则添加一个(直接添加到同步表里)
                TNcCardlist tNcCardlist = new TNcCardlist();
                long listid = RedisUtil.incr("seq_cardlist");
                tNcCardlist.setListid(listid + "");
                tNcCardlist.setCustid("");
                tNcCardlist.setCustname(devid + "设备清除名单");
                tNcCardlist.setCardno("");
                tNcCardlist.setCardphyid("FFFFFFFF");
                tNcCardlist.setClosedate("20991231");
                tNcCardlist.setOperid(operUser.getOperid());
                tNcCardlist.setDeviceid(devid);
                //清除名单专用标志
                tNcCardlist.setOperflag("Q");
                tNcCardlist.setRectime(DateUtil.getNow());
                tNcCardlist.setSynctime("");
                tNcCardlist.setSyncflag("N");
                tNcCardlist.setRtnflag("N");
                tNcCardlist.setRtntime("");
                tNcCardlist.setVersion(0);
                ncService.saveCardlist(tNcCardlist);
            }else{
                cleanList.setSyncflag("N");
                cleanList.setSynctime("");
                cleanList.setVersion(cleanList.getVersion()+1);
                cleanList.setRectime(DateUtil.getNow());
                ncService.updateCardlist(cleanList);
            }
        }catch (Exception e){
            e.printStackTrace();
            message = "设备名单清空异常!";
            logger.error("设备名单清空失败："+e.getMessage());
        }
        map.put("message", message);
        return map;
    }

    /**
     * 设备名单重下
     * @param devid
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/listReload", method = {RequestMethod.GET})
    @ResponseBody
    public Map listReload(@RequestParam(value = "devid") int devid,
                          HttpServletRequest request, HttpServletResponse response){
        Map map = new HashMap();
        String message="";
        try{
            //修改该设备名单同步标志为未同步
            ncService.updateForListReload(devid);
        }catch (Exception e){
            e.printStackTrace();
            message = "设备名单重下异常!";
            logger.error("设备名单重下失败"+e.getMessage());
        }
        map.put("message", message);
        return map;
    }

    /**
     * 获取时间段
     * @param request
     * @param response
     * @param pageNo
     * @param pageSize
     * @param timename
     * @return
     */
    @RequestMapping(value = "/loadTimeList")
    @ResponseBody
    public Map loadTimeList(HttpServletRequest request,
                            HttpServletResponse response,
                            @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                            @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                            @RequestParam(value = "timename", required = true, defaultValue = "") String timename){
        Map map = new HashMap();
        try {
            Pagination page = null;
            page = ncService.getNcTimeWithPage(timename, pageNo, pageSize, map);
            map.put("PageResult", page);
        }catch (Exception e){
            e.printStackTrace();
            logger.error("查询设备失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 删除时间段
     * @param timeid
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/deleteNcTime", method = {RequestMethod.GET})
    @ResponseBody
    public Map deleteNcTime(@RequestParam(value = "timeid") int timeid,
                            HttpServletRequest request, HttpServletResponse response){
        Map map = new HashMap();
        String message = "";
        int flag=0;
        try {
            List<String> timegrpIdById = ncService.getTimegrpIdById(timeid);
            if(timegrpIdById.size()>0){
                message = "时间段已被应用于时间组，删除失败！";
                flag=1;
            }else {
                ncService.delTimeByTimeId(timeid);
                ncService.updListVersion();
            }
        } catch (Exception e) {
            e.printStackTrace();
            message = "删除时间段出现异常!";
            logger.error("删除时间段失败：" + e.getMessage());
        }
        map.put("flag",flag);
        map.put("message", message);
        return map;
    }

    /**
     * 获取时间段信息
     * @param timeid
     * @return
     */
    @RequestMapping("/loadNcTimeForUpdate")
    @ResponseBody
    public Map loadNcTimeForUpdate(@RequestParam(value = "timeid") int timeid) {
        Map map = new HashMap();
        try {
            TNcTime time = ncService.findByTimeId(timeid);
            map.put("time", time);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 添加时间段
     * @param postData
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/addNcTime", method = {RequestMethod.POST})
    @ResponseBody
    public Map addNcTime(@RequestBody NcTimeBean postData,
                              HttpServletRequest request, HttpServletResponse response) {
        Map map = new HashMap();
        try {
            TNcTime time = ncService.findByTimeName(postData.getTimename());
            TNcTime ts = null;
            if (time == null) {
                int timeid = ncService.getMaxTimeId();
                ts = new TNcTime();
                ts.setTimeid(timeid+1);
                ts.setTimename(postData.getTimename());
                ts.setBtime(postData.getBtime());
                ts.setEtime(postData.getEtime());
                ts.setTimetype(postData.getTimetype());
                ts.setOperflag("A");
                ts.setSyncflag("");
                ts.setUpdtime(DateUtil.getNow());

                ncService.saveTime(ts);
                map.put("errStr", "");
            } else {
                map.put("errStr", "时间段名称已经存在，请修改！");
                return map;
            }
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "添加时间段失败！");
            logger.error("添加时间段失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 修改时间段信息
     * @param bean
     * @param request
     * @return
     */
    @RequestMapping(value = "/updateNcTime", method = {RequestMethod.POST})
    @ResponseBody
    public Map updateNcTime(@RequestBody NcTimeBean bean,
                                 HttpServletRequest request) {
        Map map = new HashMap();
        try {
            if (bean == null) {
                map.put("errStr", "请先选择时间段，然后再修改！");
                return map;
            }
            TNcTime temp = ncService.findByIdAndName(bean.getTimeid(), bean.getTimename());
            if (temp != null) {
                map.put("errStr", "该时间段名称已存在，请重新修改!");
                return map;
            }

            TNcTime time = ncService.findByTimeId(bean.getTimeid());
            time.setTimename(bean.getTimename());
            time.setBtime(bean.getBtime());
            time.setEtime(bean.getEtime());
            time.setTimetype(bean.getTimetype());
            time.setOperflag("A");//操作标记  A：添加   D：删除
            time.setSyncflag("");
            time.setUpdtime(DateUtil.getNow());
            ncService.updateTime(time);
            ncService.updListVersion();
            RedisUtil.incr("zcard_max_version");
            map.put("errStr", "");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "修改时间段信息失败!");
            logger.error("时间段信息修改：" + e.getMessage());
        }
        return map;
    }

    /**
     * 分页获取所有时间组信息
     *
     * @param request
     * @param response
     * @param pageNo
     * @param pageSize
     * @param timegrpname 时间组名称
     * @return
     */
    @RequestMapping(value = "/loadTimegrpList")
    @ResponseBody
    public Map loadTimegrpList(
            HttpServletRequest request,
            HttpServletResponse response,
            @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
            @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
            @RequestParam(value = "timegrpname", required = true, defaultValue = "") String timegrpname) {
        Map map = new HashMap();
        try {
            Pagination page = null;
            page = ncService.getNcTimeGrpWithPage(timegrpname, pageNo, pageSize, map);
            List<TNcTime> timelist = ncService.findAllNcTime();
            map.put("PageResult", page);
            map.put("timelist", timelist);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("查询时间组失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 获取时间组信息
     *
     * @param timegrpid 时间组编号
     * @return
     */
    @RequestMapping("/loadNcTimeGrpForUpdate")
    @ResponseBody
    public Map loadNcTimeGrpForUpdate(
                                        @RequestParam(value = "timegrpid") int timegrpid) {
        Map map = new HashMap();
        try {
            TNcTimegrp timegrp = ncService.findByTimeGrpId(timegrpid);
            map.put("timegrp", timegrp);
            List<TNcTime> timelist = ncService.findAllNcTime();
            map.put("timelist", timelist);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("获取时间组信息失败：" + e.getMessage());
        }
        return map;
    }


    /**
     * 添加时间组
     *
     * @param postData 时间组信息
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/addNcTimegrp", method = {RequestMethod.POST})
    @ResponseBody
    public Map addNcTime(@RequestBody TNcTimegrp postData,
                              HttpServletRequest request, HttpServletResponse response) {
        Map map = new HashMap();
        try {
            TNcTimegrp timegrp = ncService.findByTimeGrpName(postData.getTimegrpname());

            TNcTimegrp ts = null;
            if (timegrp == null) {
                int timegrpid = ncService.getMaxTimeGrpId();
                ts = new TNcTimegrp();
                ts.setTimegrpid(timegrpid+1);
                ts.setTimegrpname(postData.getTimegrpname());
                ts.setTimeid1(postData.getTimeid1());
                ts.setTimeid2(postData.getTimeid2());
                ts.setTimeid3(postData.getTimeid3());
                ts.setTimeid4(postData.getTimeid4());
                ts.setTimeid5(postData.getTimeid5());
                ts.setTimeid6(postData.getTimeid6());
                ts.setAdddelflag(1);
                ts.setDownstatus(0);
                ts.setUpdatetime(DateUtil.getNow());

                ncService.saveTimegrp(ts);
                map.put("errStr", "");
            } else {
                map.put("errStr", "时间组名称已经存在，请修改！");
                return map;
            }
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "添加时间组失败！");
            logger.error("添加时间组失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 修改时间组信息
     * @param bean
     * @param request
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/updateNcTimegrp", method = {RequestMethod.POST})
    public Map updateNcTimegrp(@RequestBody TNcTimegrp bean,
                                    HttpServletRequest request) {
        Map map = new HashMap();
        try {
            if (bean == null) {
                map.put("errStr", "请先选择时间组，然后再修改！");
                return map;
            }
            TNcTimegrp temp = ncService.findByGrpIdAndName(bean.getTimegrpid(), bean.getTimegrpname());
            if (temp != null) {
                map.put("errStr", "该时间组名称已存在，请重新修改!");
                return map;
            }

            TNcTimegrp timegrp = ncService.findByTimeGrpId(bean.getTimegrpid());
            timegrp.setTimegrpname(bean.getTimegrpname());
            timegrp.setTimeid1(bean.getTimeid1());
            timegrp.setTimeid2(bean.getTimeid2());
            timegrp.setTimeid3(bean.getTimeid3());
            timegrp.setTimeid4(bean.getTimeid4());
            timegrp.setTimeid5(bean.getTimeid5());
            timegrp.setTimeid6(bean.getTimeid6());
            timegrp.setAdddelflag(1);
            timegrp.setDownstatus(0);
            timegrp.setUpdatetime(DateUtil.getNow());
            ncService.updateTimegrp(timegrp);
            ncService.updListVersion();
            RedisUtil.incr("zcard_max_version");
            map.put("errStr", "");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "修改时间组信息失败!");
            logger.error("时间组信息修改：" + e.getMessage());
        }
        return map;
    }

    /**
     * 删除时间组
     * @param timegrpid
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/deleteNcTimegrp", method = {RequestMethod.GET})
    public Map deleteNcTimegrp(@RequestParam(value = "timegrpid") int timegrpid,
                                  HttpServletRequest request, HttpServletResponse response) {
        Map map = new HashMap();
        String message = "";
        int flag = 0;
            try {
                List<String> weekTimeById = ncService.getWeekTimeById(timegrpid);
                if(weekTimeById.size()>0){
                    message="时间组已应用于时间周，删除失败！";
                    flag=1;
                }else {
                    ncService.delByGrpId(timegrpid);
                    ncService.updListVersion();
                }
            } catch (Exception e) {
                e.printStackTrace();
                message = "删除时间组出现异常!";
                logger.error("删除时间组失败：" + e.getMessage());
            }
        map.put("flag",flag);
        map.put("message", message);
        return map;
    }

    /**
     * 查询获取时间周信息列表
     * @param request
     * @param response
     * @param pageNo
     * @param pageSize
     * @param weektimename
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/loadweektimeList")
    public Map loadweektimeList(
            HttpServletRequest request,
            HttpServletResponse response,
            @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
            @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
            @RequestParam(value = "weektimename", required = true, defaultValue = "") String weektimename) {
        Map map = new HashMap();
        try {
            Pagination page = null;
            page = ncService.getNcWeekTimeWithPage(weektimename, pageNo, pageSize, map);
            List<TNcTimegrp> timegrp = ncService.findAllNcTimeGrp();
            map.put("PageResult", page);
            map.put("timegrp", timegrp);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("查询时间组失败：" + e.getMessage());
        }
        return map;
    }


    /**
     * 获取时间周信息
     *
     * @param weektimeid 时间周编号
     * @return
     */
    @ResponseBody
    @RequestMapping("/loadNcweektimeForUpdate")
    public Map loadNcweektimeForUpdate(
                                          @RequestParam(value = "weektimeid") int weektimeid) {
        Map map = new HashMap();
        try {
            TNcWeektime weektime = ncService.findByWeekTimeId(weektimeid);
            map.put("weektime", weektime);//时间周
            List<TNcTimegrp> timegrp = ncService.findAllNcTimeGrp();
            map.put("timegrp", timegrp);//时间组信息
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 添加时间周
     * @param postData
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/addNcweektime", method = {RequestMethod.POST})
    public Map addNcweektime(@RequestBody TNcWeektime postData,
                                  HttpServletRequest request, HttpServletResponse response) {
        Map map = new HashMap();
        try {
            TNcWeektime weektime = ncService.findByWeekTimeName(postData.getWeekname());

            TNcWeektime ts = null;
            int weektimeid=ncService.getMaxWeekId();//weekid最小值3，最大值15
            if (weektimeid==0){
                weektimeid=3;
            }else{
                weektimeid= weektimeid+1;
            }

            if(weektimeid>=15){
                map.put("errStr","时间周数量超限！");
            }
            if (weektime == null) {
                ts = new TNcWeektime();
                ts.setWeekid(weektimeid);
                ts.setWeekname(postData.getWeekname());
                ts.setDay1grpid(postData.getDay1grpid());
                ts.setDay2grpid(postData.getDay2grpid());
                ts.setDay3grpid(postData.getDay3grpid());
                ts.setDay4grpid(postData.getDay4grpid());
                ts.setDay5grpid(postData.getDay5grpid());
                ts.setDay6grpid(postData.getDay6grpid());
                ts.setDay7grpid(postData.getDay7grpid());
                ts.setAdddelflag(1);
                ts.setDownstatus(0);
                ts.setUpdatetime(DateUtil.getNow());

                ncService.saveWeektime(ts);
                map.put("errStr", "");
            } else {
                map.put("errStr", "时间周名称已经存在，请修改！");
                return map;
            }
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "添加时间周失败！");
            logger.error("添加时间周失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 修改时间周信息
     * @param bean
     * @param request
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/updateNcweektime", method = {RequestMethod.POST})
    public Map updateNcweektime(@RequestBody TNcWeektime bean,
                                     HttpServletRequest request) {
        Map map = new HashMap();
        try {
            if (bean == null) {
                map.put("errStr", "请先选择时间周，然后再修改！");
                return map;
            }
            TNcWeektime temp = ncService.findByWeekIdAndName(bean.getWeekid(), bean.getWeekname());
            if (temp != null) {
                map.put("errStr", "该时间周名称已存在，请重新修改!");
                return map;
            }

            TNcWeektime weektime = ncService.findByWeekTimeId(bean.getWeekid());
            weektime.setWeekname(bean.getWeekname());
            weektime.setDay1grpid(bean.getDay1grpid());
            weektime.setDay2grpid(bean.getDay2grpid());
            weektime.setDay3grpid(bean.getDay3grpid());
            weektime.setDay4grpid(bean.getDay4grpid());
            weektime.setDay5grpid(bean.getDay5grpid());
            weektime.setDay6grpid(bean.getDay6grpid());
            weektime.setDay7grpid(bean.getDay7grpid());
            weektime.setAdddelflag(1);
            weektime.setDownstatus(0);
            weektime.setUpdatetime(DateUtil.getNow());
            ncService.updateWeektime(weektime);
            ncService.updListVersion();
            RedisUtil.incr("zcard_max_version");
            map.put("errStr", "");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "修改时间周信息失败!");
            logger.error("时间周信息修改：" + e.getMessage());
        }
        return map;
    }

    /**
     * 删除时间周
     * @param weektimeid
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/deleteNcweektime", method = {RequestMethod.GET})
    public Map deleteNcweektime(@RequestParam(value = "weektimeid") int weektimeid,
                                   HttpServletRequest request, HttpServletResponse response) {
        Map map = new HashMap();
        int flag=0;
        String message="";
        try {
            List devWeekByWeekid = ncService.getDevWeekByWeekid(weektimeid);
            if(devWeekByWeekid.size()>0){
                message = "时间周已绑定设备，删除失败！";
                flag=1;
            }else {
                ncService.delByWeekId(weektimeid);
                ncService.updListVersion();
                /*//删除doortime表中的时间周
                webInterfaceService.delDoorTime("XKP_"+weektimeid);*/
            }
        } catch (Exception e) {
            e.printStackTrace();
            message = "删除时间周出现异常!";
            logger.error("删除时间周失败：" + e.getMessage());
        }

        map.put("flag",flag);
        map.put("message", message);
        return map;
    }


    /**
     * 获取设备时间周
     * @param request
     * @param response
     * @param pageNo
     * @param pageSize
     * @param weekid
     * @param devname
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/loaddevweekList")
    public Map loaddevweekList(
            HttpServletRequest request,
            HttpServletResponse response,
            @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
            @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
            @RequestParam(value = "weekid") int weekid,
            @RequestParam(value = "devname") String devname) {
        Map map = new HashMap();
        try {
            Pagination page = null;
            page = ncService.getNcDevWeekWithPage(weekid, devname, pageNo, pageSize, map);
            map.put("PageResult", page);
            List<TNcWeektime> weektime = ncService.findAllNcWeekTime();
            map.put("weektime", weektime);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("查询时间组失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 删除设备时间周
     * @param devid
     * @param weekid
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/deleteNcdevweek", method = {RequestMethod.GET})
    public Map deleteNcdevweek(@RequestParam(value = "devid") int devid,
                               @RequestParam(value = "weekid") int weekid,
                               HttpServletRequest request, HttpServletResponse response) {
        String message = "";
        Map map = new HashMap();
        try {
            ncService.delDevWeekById(devid,weekid);
            ncService.updListVersion();
            RedisUtil.incr("zcard_max_version");
        } catch (Exception e) {
            e.printStackTrace();
            message = "删除设备时间周出现异常!";
            logger.error("删除设备时间周失败：" + e.getMessage());
        }
        map.put("message", message);
        return map;
    }

    /**
     * 添加设备时间周
     * @param weekid
     * @param devids
     * @param request
     * @param beans
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/addNcdevweek", method = {RequestMethod.POST})
    public Map addNcdevweek(
            @RequestParam(value = "weekid", required = true) int weekid,
            @RequestParam(value = "devids", required = true) String devids,
            HttpServletRequest request,
            @RequestBody String[] beans) {
        Map map = new HashMap();
        String errStr="";
            try {
                int maxDevWeekVersion = ncService.findMaxDevWeekVersion();
                if(beans != null && beans.length > 0){
                    String[] devlist=beans;
                    ncService.deleteDevWeekByWeekId(weekid);
                    for (int i=0;i<devlist.length;i++){
                        TNcDevweek devweek = new TNcDevweek();
                        TNcDevweekId tNcDevweekId = new TNcDevweekId();
                        tNcDevweekId.setDevid(Integer.parseInt(devlist[i]));
                        tNcDevweekId.setWeekid(weekid);
                        devweek.setId(tNcDevweekId);
                        TNcDevice dev = ncService.findDevById(Integer.parseInt(devlist[i]));
                        devweek.setDevname(dev.getDevname());
                        TNcWeektime wt = ncService.findByWeekTimeId(weekid);
                        devweek.setWeekname(wt.getWeekname());
                        devweek.setUpdatetime(DateUtil.getNow());
                        devweek.setVersion(maxDevWeekVersion);
                        boolean b = ncService.saveDevWeek(devweek);
                        map.put("errStr", "");
                    }
                    ncService.updListVersion();
                    RedisUtil.incr("zcard_max_version");
                }
            } catch (Exception e) {
                e.printStackTrace();
                map.put("errStr", "分配设备失败");
                logger.error("分配设备失败：" + e.getMessage());
            }

        return map;
    }

    /**
     * 根据id查询已选取此时间周的设备
     * @param reWeekId
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value="/getChosenDev")
    public Map getChosenDev(
            @RequestParam(value = "reWeekId",required=true) int reWeekId,
            HttpServletRequest request,
            HttpServletResponse response){
        Map map = new HashMap();
        try{
            List<TNcDevweek> chosenDev = ncService.findChosenDev(reWeekId);
            map.put("chosenDev",chosenDev);//已做出选择的设备
        }catch (Exception e){
            e.printStackTrace();
            logger.error("查询已做出选择设备失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 获取设备时间周信息
     *
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/loadforadddevweek")
    public Map loadforadddevweek(
            HttpServletRequest request,
            HttpServletResponse response,
            @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        try {
            List<TNcWeektime> weektime = ncService.findAllNcWeekTime();
            map.put("weektime", weektime);//时间周
            String opertype = operUser.getOpertype();
            List<TNcDevice> device = null;

                device = ncService.findAllNcDevices();


            map.put("device", device);//设备
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("查询设备失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 设备导入模板下载
     * @param request
     * @param response
     */
    @ResponseBody
    @RequestMapping("/downNcDevExcelTemplate")
    public void downNcDevExcelTemplate(HttpServletRequest request, HttpServletResponse response){
        Map map = new HashMap();
        try {
            List<ExcelExportEntity> entity = new ArrayList<ExcelExportEntity>();
            /**
             * 1. 设置列信息：name：列标题   key：	列属性
             */
            entity.add(new ExcelExportEntity("设备名称", "devname"));
            entity.add(new ExcelExportEntity("设备类型", "devtype"));
            //entity.add(new ExcelExportEntity("设备使用类型", "usetype")); 默认全部为门禁 MJ
            entity.add(new ExcelExportEntity("上级设备编号", "fdevid"));
            entity.add(new ExcelExportEntity("终端物理编号", "devphyid"));
            entity.add(new ExcelExportEntity("读头号", "devno"));
            entity.add(new ExcelExportEntity("IP地址", "ip"));
            entity.add(new ExcelExportEntity("区域编号", "regionid"));
            entity.add(new ExcelExportEntity("楼栋编号", "buildingid"));
            List<Map> personList = new ArrayList<Map>();
            /**
             * 2.设置表格属性: title:标题  sheetName:工作簿名 type:表格类型
             */
            ExportParams params = new ExportParams(null, "sheet1", ExcelType.HSSF);
            map.put(MapExcelConstants.MAP_LIST, personList);
            map.put(MapExcelConstants.ENTITY_LIST, entity);
            map.put(MapExcelConstants.PARAMS, params);
            map.put(MapExcelConstants.FILE_NAME, "设备导入模板");//文件名
            map.put("result", "导出excel文件完成");
            PoiBaseView.render(map, request, response, MapExcelConstants.EASYPOI_MAP_EXCEL_VIEW);

        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "导出excel文件失败");
        }
    }


    /**
     * 设备导入
     * @param file
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/saveNcDevByExcel",method = {RequestMethod.POST})
    public Map saveNcDevByExcel(@RequestParam(value = "file", required = false) MultipartFile file,
                                   HttpServletRequest request,HttpServletResponse response){
        Map map = new HashMap();
        try {
            String devTypeId = request.getParameter("devTypeId");
            String path = request.getSession().getServletContext().getRealPath("upload");
            String fileName = file.getOriginalFilename();
            File targetFile = new File(path, fileName);
            if (!targetFile.exists()) {
                targetFile.mkdirs();
            }
            file.transferTo(targetFile);
            map = impNcDevList(path + "/" + fileName,devTypeId, map);

        }catch (Exception e){
            e.printStackTrace();
        }

        return map;
    }

    private Map impNcDevList(String fpath,String devTypeId,Map map){
        ImportParams params = new ImportParams();
        params.setTitleRows(0);
        List<TNcDevice> tNcDeviceList = ExcelImportUtil.importExcel(new File(fpath), TNcDevice.class, params);
        int totCnt = tNcDeviceList.size();
        int flag = 0;
        if (totCnt<=0){
            map.put("impDev_succ","导入文件中未查询到数据！");
            flag = -1;
            map.put("flag", flag);
            return map;
        }
        String failStr = "";
        try{
            TNcDevice device;

            //判断导入数据是否合法
            for (int i=0;i<tNcDeviceList.size();i++){
                if (tNcDeviceList.get(i).getRegionid()==null||"".equals(tNcDeviceList.get(i).getRegionid())){
                    failStr = "第"+(i+1)+"条数据--设备所属区域编号为空！";
                    map.put("impDev_succ",failStr);
                    flag = -1;
                    map.put("flag", flag);
                    return map;
                }
                TRegion regionById = systemService.getRegionById(tNcDeviceList.get(i).getRegionid());
                if (regionById==null){
                    failStr = "第"+(i+1)+"条数据--设备所属区域不存在！";
                    map.put("impDev_succ",failStr);
                    flag = -1;
                    map.put("flag", flag);
                    return map;
                }

                if (tNcDeviceList.get(i).getBuildingid()==null||"".equals(tNcDeviceList.get(i).getBuildingid())){
                    failStr = "第"+(i+1)+"条数据--设备所属楼栋编号为空！";
                    map.put("impDev_succ",failStr);
                    flag = -1;
                    map.put("flag", flag);
                    return map;
                }
                TBuilding buildingById = systemService.getBuildingById(tNcDeviceList.get(i).getBuildingid());
                if (buildingById==null){
                    failStr = "第"+(i+1)+"条数据--设备所属楼栋不存在！";
                    map.put("impDev_succ",failStr);
                    flag = -1;
                    map.put("flag", flag);
                    return map;
                }

                //控制器设备类型
                if (devTypeId.equals("C")){
                    if (!tNcDeviceList.get(i).getDevtype().equals("C")){
                        failStr = "第"+(i+1)+"条数据--设备类型和所选设备类型不一致！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    if (tNcDeviceList.get(i).getDevphyid()==null){
                        failStr = "第"+(i+1)+"条数据--终端物理编号为空！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    if (tNcDeviceList.get(i).getDevname()==null){
                        failStr = "第"+(i+1)+"条数据--设备名称为空！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    if (tNcDeviceList.get(i).getDevtype()==null){
                        failStr = "第"+(i+1)+"条数据--设备类型为空！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    device = ncService.validDevPhyid(0,tNcDeviceList.get(i).getDevphyid());
                    if (device!=null && device.getDeviceid()>0){
                        failStr = "第"+(i+1)+"条数据--终端物理编号已存在！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    device = ncService.validDevName(0,tNcDeviceList.get(i).getDevname());
                    if (device!=null && device.getDeviceid()>0){
                        failStr = "第"+(i+1)+"条数据--设备名称已存在！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    if (tNcDeviceList.get(i).getFdevid()!=null){
                        failStr = "第"+(i+1)+"条数据--控制器类型上级设备必须为空！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    if (tNcDeviceList.get(i).getDevno()!=null){
                        failStr = "第"+(i+1)+"条数据--控制器类型读头号必须为空！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    if (tNcDeviceList.get(i).getDevtype().equals("C") && tNcDeviceList.get(i).getDevphyid().length()!=12){
                        failStr = "第"+(i+1)+"条数据--控制器类型终端物理编号必须为12位！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                }


                //读头设备类型
                if (devTypeId.equals("R")){
                    if (!tNcDeviceList.get(i).getDevtype().equals("R")){
                        failStr = "第"+(i+1)+"条数据--设备类型和所选设备类型不一致！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    if (tNcDeviceList.get(i).getDevphyid()==null){
                        failStr = "第"+(i+1)+"条数据--终端物理编号为空！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    if (tNcDeviceList.get(i).getDevname()==null){
                        failStr = "第"+(i+1)+"条数据--设备名称为空！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    if (tNcDeviceList.get(i).getDevtype()==null){
                        failStr = "第"+(i+1)+"条数据--设备类型为空！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    device = ncService.validDevPhyid(0,tNcDeviceList.get(i).getDevphyid());
                    if (device!=null && device.getDeviceid()>0){
                        failStr = "第"+(i+1)+"条数据--终端物理编号已存在！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    device = ncService.validDevName(0,tNcDeviceList.get(i).getDevname());
                    if (device!=null && device.getDeviceid()>0){
                        failStr = "第"+(i+1)+"条数据--设备名称已存在！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    if (tNcDeviceList.get(i).getDevtype().equals("R") && tNcDeviceList.get(i).getFdevid()==null){
                        failStr = "第"+(i+1)+"条数据--读头类型上级设备不可为空！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    if (tNcDeviceList.get(i).getDevtype().equals("R") && tNcDeviceList.get(i).getDevno()==null){
                        failStr = "第"+(i+1)+"条数据--读头类型读头号不可为空！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    if (tNcDeviceList.get(i).getDevtype().equals("R")){
                        device = ncService.findDevById(tNcDeviceList.get(i).getFdevid());
                        if (device==null){
                            failStr = "第"+(i+1)+"条数据--此上级设备不存在！";
                            map.put("impDev_succ",failStr);
                            flag = -1;
                            map.put("flag", flag);
                            return map;
                        }
                    }
                    device = ncService.findDevById(tNcDeviceList.get(i).getFdevid());
                    if (!(device.getDevtype().equals("C"))){
                        failStr = "第"+(i+1)+"条数据--此上级设备不为控制器！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                    device=ncService.validDevNo(tNcDeviceList.get(i).getFdevid(),tNcDeviceList.get(i).getDevno(),0);
                    if (device!=null && device.getDeviceid()>0){
                        failStr = "第"+(i+1)+"条数据--该控制器下此读头号已存在！";
                        map.put("impDev_succ",failStr);
                        flag = -1;
                        map.put("flag", flag);
                        return map;
                    }
                }

            }

            //批量添加设备
            int successCnt = 0;
            int errCnt = 0;
            for (TNcDevice tNcDeviceTemp:tNcDeviceList){
                TNcDevice validDevName = ncService.validDevName(0, tNcDeviceTemp.getDevname());
                if (validDevName!=null && validDevName.getDeviceid()>0){
                    errCnt++;
                    continue;
                }
                TNcDevice validDevPhyid = ncService.validDevPhyid(0, tNcDeviceTemp.getDevphyid());
                if (validDevPhyid!=null){
                    errCnt++;
                    continue;
                }
                if (tNcDeviceTemp.getDevtype().equals("R")){
                    TNcDevice validDevNo = ncService.validDevNo(tNcDeviceTemp.getFdevid(), tNcDeviceTemp.getDevno(), 0);
                    if (validDevNo!=null){
                        errCnt++;
                        continue;
                    }
                    RedisUtil.del("ncdev_" + tNcDeviceTemp.getDevphyid() + "_" + tNcDeviceTemp.getDevno());
                    RedisUtil.set("ncdev_" + tNcDeviceTemp.getDevphyid() + "_" + tNcDeviceTemp.getDevno(),String.valueOf(tNcDeviceTemp.getDeviceid()));
                }
                int maxId = ncService.getMaxId();
                TNcDevice devAdd = new TNcDevice();
                devAdd.setDeviceid(maxId+1);
                devAdd.setDevname(tNcDeviceTemp.getDevname());
                devAdd.setDevphyid(tNcDeviceTemp.getDevphyid().toUpperCase());
                devAdd.setDevtype(tNcDeviceTemp.getDevtype());
                devAdd.setFdevid(tNcDeviceTemp.getFdevid());
                if (tNcDeviceTemp.getDevtype().equals("C")){
                    devAdd.setDevno(0);//控制器读头为0
                }else {
                    devAdd.setDevno(tNcDeviceTemp.getDevno());
                }
                devAdd.setIp(tNcDeviceTemp.getIp());
                devAdd.setOperflag("A");
                devAdd.setSyncflag("S");
                String now = DateUtil.getNow();
                devAdd.setSynctime(now);
                devAdd.setUpdtime(now);
                devAdd.setUsetype("MJ");//设备使用类型全为门禁"MJ"
                devAdd.setRegionid(tNcDeviceTemp.getRegionid());
                devAdd.setBuildingid(tNcDeviceTemp.getBuildingid());
                TBuilding buildingById = systemService.getBuildingById(tNcDeviceTemp.getBuildingid());
                devAdd.setBuildingname(buildingById.getBuildingname());
                if(tNcDeviceTemp.getDevtype().equals("R")){
                    TNcDevice fdev = ncService.findDevById(tNcDeviceTemp.getFdevid());
                    RedisUtil.set("ncdev_" + fdev.getDevphyid() + "_" + tNcDeviceTemp.getDevno(),String.valueOf(devAdd.getDeviceid()));
                }
                ncService.saveDevice(devAdd);
                successCnt++;
            }
            map.put("resultStr","共导入"+totCnt+"条数据,"+successCnt+"条数据成功,"+errCnt+"条数据失败！");
            map.put("impDev_succ", "");
        }catch (Exception e){
            map.put("impDev_succ","导入失败");
            logger.error("设备名单导入失败--"+e.getMessage());
            flag = -2;
            map.put("flag", flag);
            return map;
        }
        map.put("flag", flag);
        return map;
    }

}
