package com.supwisdom.dlpay.ncmgr.service;

import com.supwisdom.dlpay.doorlist.bean.TDoordevInfo;
import com.supwisdom.dlpay.ncmgr.domain.*;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

public interface NcService {
    //根据查询条件分页获取所有设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getSystemNcDeviceWithPage(String devname, int pageNo, int pageSize, Map map, String buildingid,String regionid, String devtype);

    //根据查询条件分页获取管理员设备---
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getOperatorNcDeviceWithPage(String devname,int pageNo,int pageSize, String buildingid,String regionid,String devtype,String operRegionid);

    //根据查询条件分页获取楼栋管理员设备 ---regionid为空
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getBuildingOperNcDeviceWithPage(String devname,int pageNo,int pageSize,String buildingid,String devtype,String operid);

    //获取所有楼栋信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TBuilding> getAllBuilding();

    //获取所有区域信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TRegion> getAllRegion();

    //根据楼栋id获取楼栋信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TBuilding getBuidingById(String id);

    //根据设备类型获取所有设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcDevice> getSystemDevByType(String type);

    //根据设备类型获取操作员权限设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcDevice> getOperatorDevByType(String type,String regionid);

    //根据设备类型获取楼栋管理员权限设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcDevice> getBuildingOperDevByType(String type,String operid);

    //根据设备id获取设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcDevice findDevById(int id);

    //验证设备名称
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcDevice validDevName(int devid,String devname);

    //验证设备物理编号
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcDevice validDevPhyid(int devid,String devPhyid);

    //验证读头号
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcDevice validDevNo(int fdevid,int devno,int devid);

    //修改设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateDevice(TNcDevice bean);

    //获取设备最大主键
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public int getMaxId();

    //保存设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveDevice(TNcDevice bean);

    //根据设备编号获取设备及父设备信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcDevice getDevInfoByDevid(int devid);

    //根据设备编号获取设备及父设备信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcDevice getDevInfoByDevphyid(String devphyid);

    //根据控制器设备编号获取其读头设备列表
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcDevice> getDevListByfDevid(int devid);

    //根据设备编号删除设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public void delDevById(int devid);

    //根据楼栋id更新设备的所属楼栋名称
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public void updateBuildingnameByBuildingid(String buildingid,String buildingname);

    //根据设备编号查询是否绑定时间周
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean getDevWeekByDevid(int devid);

    //设备名单清空(获取清空所用名单)
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcCardlist getCleanList(int devid);

    //保存同步名单信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveCardlist(TNcCardlist bean);

    //修改同步名单
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateCardlist(TNcCardlist bean);

    //设备名单重下(修改该设备已同步名单为未同步)
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public void updateForListReload(int devid);

    //根据楼栋id获取设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcDevice getDevByBuildingid(String buildingid);

    //获取系统管理员权限下所有可以分配的设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TDoordevInfo> getSystemDevList(String devname,String regionid,String buildingid);

    //获取区域管理员权限下所有可以分配的设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TDoordevInfo> getOperatorDevList(String devname,String regionid,String buildingid,String operRegionid);

    //获取楼栋管理员权限下所有可以分配的设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TDoordevInfo> getBuildingOperDevList(String devname,String regionid,String buildingid,String operid);

    //根据查询条件分页获取所有时间段信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getNcTimeWithPage(String time,int pageNo, int pageSize,Map map);

    //根据时间段
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<String> getTimegrpIdById(int id);

    //根据时间段id删除时间段
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean delTimeByTimeId(int id);

    //DevWeek数据所有版本号+1
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updListVersion();

    //根据时间段id获取时间段信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcTime findByTimeId(int id);

    //根据时间段名称获取时间段信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcTime findByTimeName(String name);

    //获取时间段最大主键
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public int getMaxTimeId();

    //保存时间段
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveTime(TNcTime bean);

    //根据id和名称获取时间段信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcTime findByIdAndName(int id, String name);

    //修改时间段
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateTime(TNcTime bean);

    //根据查询条件分页获取时间组
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getNcTimeGrpWithPage(String time,int pageNo, int pageSize,Map map);

    //获取所有时间段
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcTime> findAllNcTime();

    //根据id获取时间组信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcTimegrp findByTimeGrpId(int id);

    //根据时间组名称获取时间组信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcTimegrp findByTimeGrpName(String name);

    //获取时间组最大id主键
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public int getMaxTimeGrpId();

    //保存时间组
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveTimegrp(TNcTimegrp bean);

    //根据id和名称查询时间组是否存在
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcTimegrp findByGrpIdAndName(int id,String name);

    //修改时间组
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateTimegrp(TNcTimegrp bean);

    //根据时间组id查询此时间组是否被时间周使用
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<String> getWeekTimeById(int id);

    //根据id删除时间组
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean delByGrpId(int id);

    //根据查询条件分页获取时间周
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getNcWeekTimeWithPage(String time,int pageNo, int pageSize,Map map);

    //获取所有时间组
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcTimegrp> findAllNcTimeGrp();

    //根据id获取时间周信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcWeektime findByWeekTimeId(int id);

    //根据名称获取时间周信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcWeektime findByWeekTimeName(String name);

    //获取最大时间周id 只支持3-15
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public int getMaxWeekId();

    //保存时间周
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveWeektime(TNcWeektime bean);

    //根据id和名称查询时间周是否存在
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public TNcWeektime findByWeekIdAndName(int id,String name);

    //修改时间周
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean updateWeektime(TNcWeektime bean);

    //根据时间周id查询设备绑定时间周情况
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List getDevWeekByWeekid(int id);

    //根据id删除时间周
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean delByWeekId(int id);

    //根据查询条件分页获取设备绑定时间周信息
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public Pagination getNcDevWeekWithPage(int weekid,String devname,int pageNo, int pageSize,Map map);

    //获取所有时间周
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcWeektime> findAllNcWeekTime();

    //根据设备编号和时间周id删除对应设备时间周
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public void delDevWeekById(int devid,int weekid);

    //获取最大设备时间周版本
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public int findMaxDevWeekVersion();

    //根据时间周id删除设备绑定的时间周
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public void deleteDevWeekByWeekId(int weekId);

    //保存设备时间周
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public boolean saveDevWeek(TNcDevweek devweek);

    //根据id查询已选取此时间周的设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcDevweek> findChosenDev(int weekId);

    //获取所有设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcDevice> findAllNcDevices();

    //获取管理员权限下的设备
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = {Exception.class})
    public List<TNcDevice> findOperatorDevices(String operRegionid);

    //根据查询条件分页获取所有可以远程的设备
    public Pagination getAllRemoteDev(String devname, int pageNo, int pageSize, String buildingid,String regionid);

    //根据查询条件分页获取所有管理员权限下可以远程的设备
    public Pagination getOperateRemoteDev(String devname, int pageNo, int pageSize, String buildingid,String regionid,String operRegionid);

    //根据查询条件分页获取所有楼栋管理员权限下可以远程的设备
    public Pagination getBuildingOperRemoteDev(String devname, int pageNo, int pageSize, String buildingid,String regionid,String operid);
}
