package com.supwisdom.dlpay.system.dao;

import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.system.bean.AllotBuildingBean;
import com.supwisdom.dlpay.system.domain.TOperbuilding;
import com.supwisdom.dlpay.system.page.Pagination;

import java.util.List;

public interface BuildingDao {
    public List<TBuilding> getBuildingByRegionId(String regionid);

    public Pagination getSystemBuildingList(String regionid, String buildingname, int pageNo, int pageSize);

    public Pagination getOperatorBuildingList(String operRegionid,String regionid,String buildingname,int pageNo,int pageSize);

    public Pagination getBuildingOperBuildingList(String regionid,String buildingname,String operid,int pageNo,int pageSize);

    public TBuilding getBuildingById(String buildingid);

    public TBuilding getBuildingByName(String buildingname);

    public boolean saveBuilding(TBuilding bean);

    public TBuilding getBuildingByNameAndId(String buildingname,String buildingid);

    public boolean updateBuilding(TBuilding bean);

    public boolean updateBuildingFlag(String buildingid);

    public List<AllotBuildingBean> findSystemAllotBuildingList();

    public List<AllotBuildingBean> findOperatorAllotBuildingList(String operRegionid);

    public List<AllotBuildingBean> findBuildingInOper(String operid);

    public boolean deleteOperBuildingByOperid(String operid);

    public boolean saveOperBuilding(TOperbuilding bean);

    public List<TBuilding> getAllBuildings();

    public List<TBuilding> getOperatorBuildings(String regionid);

    public List<TBuilding> getBuildingOperBuildings(String operid);

    public List<TBuilding> getOperatorBuildingByRegionId(String regionid,String operRegionid);

    public List<TBuilding> getBuildingOperBuildingByRegionId(String regionid,String operid);
}
