package com.supwisdom.dlpay.system.dao;

import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.system.domain.TCompany;
import com.supwisdom.dlpay.system.domain.TModifyCompany;
import com.supwisdom.dlpay.system.page.Pagination;

import java.util.List;

public interface CompanyDao {

    public Pagination getSystemCompanyList(String companyName, int pageNo, int pageSize);

    public Pagination getOperCompanyList(String companyName,int pageNo,int pageSize,String operid);

    public TCompany getCompanyByName(String companyName);

    public boolean saveCompany(TCompany bean);

    public TCompany getCompanyAllStatusById(String companyId);

    public boolean updateCompany(TCompany bean);

    public List<TOperator> getOperByCompanyId(String companyId);

    public TCompany getCompanyByNameAndId(String companyName,String companyId);

    public Pagination getCheckCompanyList(String companyName,int pageNo,int pageSize);

    public TCompany getCheckCompanyById(String companyId);

    public List<TCompany> getValidCompanyList();

    public TModifyCompany getModifyCompanyById(String companyId);

    public boolean saveModifyCompany(TModifyCompany bean);

    public TModifyCompany getModifyCompanyByNameAndId(String companyName,String companyId);

    public boolean updateModifyCompany(TModifyCompany bean);
}
