package com.supwisdom.dlpay.system.dao;

import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.system.domain.TDept;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface DeptDao extends JpaRepository<TDept, String> {

  @Query("from TDept t where t.status='normal' ")
  List<TDept> findNormalDept();

  @Query("from TDept t order by deptcode")
  List<TDept> findAllOrderByDeptcode();

  Page<TDept> findAllByDeptnameContainingOrDeptnoContainingOrderByDeptcode(String name,String deptno, Pageable pageable);

  @Query("select count(t.deptno) from TDept t where t.deptno=?1 ")
  long checkDeptnoExists(String deptno);

  List<TDept> findByDeptno(String deptno);

  int countByFdeptcode(String fdeptcode);

}
