package com.supwisdom.dlpay.system.dao;

import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.page.Pagination;

import java.util.List;

public interface RegionDao {
    public Pagination getSystemRegionList(String regionname, int pageNo, int pageSize);

    public Pagination getOperatorRegionList(String regionname,String regionid,int pageNo,int pageSize);

    //根据id修改指定区域状态flag为0
    public boolean updateRegionFlag(String regionid);

    public TRegion getRegionById(String regionid);

    public TRegion getRegionAllFlagById(String regionid);

    public List<TRegion> getRegionListById(String regionid);

    public List<TRegion> getLowRegionListById(String regionid);

    public List<TRegion> getRegionListByLevel(int level);

    public List<TRegion> getOperRegionListByLevel(int level,String regionid);

    public List<TRegion> getAllRegions();

    public TRegion getRegionByName(String regionname);

    public boolean saveRegion(TRegion bean);

    public TRegion getRegionByNameAndId(String regionname,String regionid);

    public boolean updateRegion(TRegion bean);

    public boolean updateParentnameById(String regionid,String parentname);

}
