package com.supwisdom.dlpay.system.dao.impl;

import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.system.bean.AllotBuildingBean;
import com.supwisdom.dlpay.system.dao.BuildingDao;
import com.supwisdom.dlpay.system.domain.TOperbuilding;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;
@Repository
public class BuildingDaoImpl implements BuildingDao {
    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public List<TBuilding> getBuildingByRegionId(String regionid) {
        String sql = "select bean.buildingid,bean.buildingname,bean.synctime,bean.updtime,bean.flag,bean.buildingdesc,bean.regionid" +
                " from T_Building bean where bean.flag='A' "+
                "and bean.regionid in  " +
                "( with recursive tmp as  ( select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid ) " +
                "  select regionid from tmp  )";

        Query query = entityManager.createNativeQuery(sql, TBuilding.class);
        query.setParameter("regionid", regionid);
        List<TBuilding> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list;
        }
        return null;
    }

    @Transactional
    @Override
    public Pagination getSystemBuildingList(String regionid, String buildingname, int pageNo, int pageSize) {
        String sql = "select bean.buildingid,bean.buildingname,bean.synctime,bean.updtime,case when bean.flag='A' then '有效' else '注销' end flag,bean.buildingdesc,bean.regionid " +
                " from T_Building bean where 1>0 ";
        if (!StringUtil.isEmpty(regionid)){
            sql += "and bean.regionid in  " +
                    "( with recursive tmp as  ( select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                    " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid ) " +
                    "  select regionid from tmp  )";
        }

        if (!StringUtil.isEmpty(buildingname)){
           sql += " and bean.buildingname like :buildingname";
        }
        sql += " order by bean.buildingid";

        Query query = entityManager.createNativeQuery(sql, TBuilding.class);
        if (!StringUtil.isEmpty(regionid)){
            query.setParameter("regionid", regionid );
        }
        if (!StringUtil.isEmpty(buildingname)){
            query.setParameter("buildingname", "%"+buildingname+"%");
        }

        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TBuilding> list = query.getResultList();
        page.setList(list);
        int totalCount = getSystemBuildingListCount(regionid,buildingname);
        page.setTotalCount(totalCount);
        return page;
    }



    private int getSystemBuildingListCount(String regionid,String buildingname){
        String sql = "select count(*) from T_Building bean where 1>0 ";
        if (!StringUtil.isEmpty(regionid)){
            sql += "and bean.regionid in  " +
                    "(with recursive tmp as  (select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                    " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  " +
                    " ) select regionid from tmp  )";
        }

        if (!StringUtil.isEmpty(buildingname)){
            sql += " and bean.buildingname like :buildingname";
        }
        Query query = entityManager.createNativeQuery(sql);
        if (!StringUtil.isEmpty(regionid)){
            query.setParameter("regionid", regionid );
        }
        if (!StringUtil.isEmpty(buildingname)){
            query.setParameter("buildingname", "%"+buildingname+"%");
        }
        int cnt=0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public Pagination getOperatorBuildingList(String operRegionid, String regionid, String buildingname, int pageNo, int pageSize) {
        String sql = "select bean.buildingid,bean.buildingname,bean.synctime,bean.updtime,case when bean.flag='A' then '有效' else '注销' end flag,bean.buildingdesc,bean.regionid " +
                " from T_Building bean where 1>0 ";

            sql += "and bean.regionid in  " +
                    "( with recursive tmp as  ( select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                    " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid ) " +
                    "  select regionid from tmp  )";


        if (!StringUtil.isEmpty(buildingname)){
            sql += " and bean.buildingname like :buildingname";
        }
        sql += " order by bean.buildingid";

        Query query = entityManager.createNativeQuery(sql, TBuilding.class);
        if (!StringUtil.isEmpty(regionid)){
            query.setParameter("regionid", regionid );
        }else {
            query.setParameter("regionid", operRegionid);
        }
        if (!StringUtil.isEmpty(buildingname)){
            query.setParameter("buildingname", "%"+buildingname+"%");
        }

        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TBuilding> list = query.getResultList();
        page.setList(list);
        int totalCount = getOperatorBuildingListCount(operRegionid,regionid,buildingname);
        page.setTotalCount(totalCount);
        return page;
    }

    private int getOperatorBuildingListCount(String operRegionid, String regionid, String buildingname){
        String sql = "select count(*) from T_Building bean where 1>0 ";

            sql += "and bean.regionid in  " +
                    "(with recursive tmp as  (select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                    " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  " +
                    " ) select regionid from tmp  )";

        if (!StringUtil.isEmpty(buildingname)){
            sql += " and bean.buildingname like :buildingname";
        }
        Query query = entityManager.createNativeQuery(sql);
        if (!StringUtil.isEmpty(regionid)){
            query.setParameter("regionid", regionid );
        }else {
            query.setParameter("regionid", operRegionid);
        }
        if (!StringUtil.isEmpty(buildingname)){
            query.setParameter("buildingname", "%"+buildingname+"%");
        }
        int cnt=0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public Pagination getBuildingOperBuildingList(String regionid, String buildingname, String operid, int pageNo, int pageSize) {
        // 楼栋管理员regionid为空
        String sql = "select bean.buildingid,bean.buildingname,bean.synctime,bean.updtime,case when bean.flag='A' then '有效' else '注销' end flag,bean.buildingdesc,bean.regionid "+
                " from T_Building bean left join T_operbuilding a on a.buildingid=bean.buildingid " +
                " where 1>0 and a.operid= :operid";
        if (!StringUtil.isEmpty(buildingname)){
            sql += " and bean.buildingname like :buildingname";
        }
        Query query = entityManager.createNativeQuery(sql, TBuilding.class);
        query.setParameter("operid", operid);
        if (!StringUtil.isEmpty(buildingname)){
            query.setParameter("buildingname", "%"+buildingname+"%");
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TBuilding> list = query.getResultList();
        page.setList(list);
        int totalCount = getBuildingOperBuildingListCount(operid,buildingname);
        page.setTotalCount(totalCount);
        return page;
    }

    private int getBuildingOperBuildingListCount(String operid,String buildingname){
        String sql = "select count(*) from T_BUILDING bean left join T_operbuilding a on a.buildingid=bean.buildingid "+
                "where 1>0 and a.operid= :operid";
        if (!StringUtil.isEmpty(buildingname)){
            sql += " and bean.buildingname like :buildingname";
        }
        Query query = entityManager.createNativeQuery(sql);
        query.setParameter("operid", operid);
        if (!StringUtil.isEmpty(buildingname)){
            query.setParameter("buildingname", "%"+buildingname+"%");
        }
        int cnt=0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public TBuilding getBuildingById(String buildingid) {
        String sql = "select bean from TBuilding bean where  bean.buildingid=:buildingid";
        TypedQuery<TBuilding> query = entityManager.createQuery(sql, TBuilding.class);
        query.setParameter("buildingid" , buildingid);
        List<TBuilding> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public TBuilding getBuildingByName(String buildingname) {
        String sql = "select bean from TBuilding bean where  bean.buildingname=:buildingname";
        TypedQuery<TBuilding> query = entityManager.createQuery(sql, TBuilding.class);
        query.setParameter("buildingname", buildingname);
        List<TBuilding> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean saveBuilding(TBuilding bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            throw e;
        }
        return flag;
    }

    @Transactional
    @Override
    public TBuilding getBuildingByNameAndId(String buildingname, String buildingid) {
        String sql = "select bean from TBuilding bean where bean.buildingname=:buildingname and bean.buildingid <> :buildingid ";
        TypedQuery<TBuilding> query = entityManager.createQuery(sql, TBuilding.class);
        query.setParameter("buildingname" ,buildingname );
        query.setParameter("buildingid" ,buildingid );
        List<TBuilding> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateBuilding(TBuilding bean) {
        boolean flag = false;
        try {
            entityManager.merge(bean);
            flag = true;
        } catch (Exception e) {
            throw  e;
        }
        return flag;
    }

    @Transactional
    @Override
    public boolean updateBuildingFlag(String buildingid) {
        boolean flag = false;
        try {
            String sql = "update t_building set flag = 'D',UPDTIME=to_char(current_timestamp, 'YYYYMMDDHH24MISS') where buildingid = ?1 ";
            Query query = entityManager.createNativeQuery(sql);
            query.setParameter(1, buildingid);
            query.executeUpdate();
            flag = true;
        }catch (Exception e){
            throw e;
        }
        return flag;
    }

    @Transactional
    @Override
    public List<AllotBuildingBean> findSystemAllotBuildingList() {
        String sql = "select a.buildingid,a.buildingname,a.regionid,b.regionname from t_building a " +
                " left join tb_region b on a.regionid=b.regionid ";
        Query query = entityManager.createNativeQuery(sql, AllotBuildingBean.class);
        List<AllotBuildingBean> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public List<AllotBuildingBean> findOperatorAllotBuildingList(String operRegionid) {
        String sql = "select a.buildingid,a.buildingname,a.regionid,b.regionname from t_building a " +
                " left join tb_region b on a.regionid=b.regionid " +
                " where b.regionid in(with recursive tmp as  (select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                " where regionid= :operRegionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  " +
                "                    ) select regionid from tmp  )";
        Query query = entityManager.createNativeQuery(sql, AllotBuildingBean.class);
        query.setParameter("operRegionid", operRegionid);
        List<AllotBuildingBean> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public List<AllotBuildingBean> findBuildingInOper(String operid) {
        String sql = "select a.buildingid,a.buildingname,a.regionid,b.regionname from t_building a " +
                " left join tb_region b on a.regionid = b.regionid " +
                " where a.buildingid in " +
                " (select c.buildingid from t_operbuilding c where operid = ?1)";
        Query query = entityManager.createNativeQuery(sql, AllotBuildingBean.class);
        query.setParameter(1, operid);
        List<AllotBuildingBean> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public boolean deleteOperBuildingByOperid(String operid) {
        boolean flag = false;
        try {
            String sql = "delete from t_operbuilding where operid = ?1";
            Query query = entityManager.createNativeQuery(sql);
            query.setParameter(1, operid);
            query.executeUpdate();
            flag = true;
        }catch (Exception e){
            throw e;
        }
        return flag;
    }

    @Transactional
    @Override
    public boolean saveOperBuilding(TOperbuilding bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            throw e;
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TBuilding> getAllBuildings() {
        String sql = "select bean from TBuilding bean where bean.flag = 'A' ";
        TypedQuery<TBuilding> query = entityManager.createQuery(sql, TBuilding.class);
        List<TBuilding> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public List<TBuilding> getOperatorBuildings(String regionid) {
        String sql = "select a.buildingid,a.buildingname,a.synctime,a.updtime,a.flag,a.buildingdesc,a.regionid from t_building a " +
                " left join tb_region b on a.regionid=b.regionid " +
                " where a.flag = 'A' and b.regionid in(with recursive tmp as  (select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                " where regionid= :operRegionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  " +
                "                    ) select regionid from tmp  )";
        Query query = entityManager.createNativeQuery(sql, TBuilding.class);
        query.setParameter("operRegionid", regionid);
        List<TBuilding> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public List<TBuilding> getBuildingOperBuildings(String operid) {
        String sql = "select bean.buildingid,bean.buildingname,bean.synctime,bean.updtime,bean.flag,bean.buildingdesc,bean.regionid " +
                " from T_Building bean " +
                " where 1>0 and bean.flag='A' and bean.buildingid in (select a.buildingid from t_operbuilding a where a.operid =?1)";
        Query query = entityManager.createNativeQuery(sql, TBuilding.class);
        query.setParameter(1, operid);
        List<TBuilding> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public List<TBuilding> getOperatorBuildingByRegionId(String regionid, String operRegionid) {
        String sql = "select bean.buildingid,bean.buildingname,bean.synctime,bean.updtime,bean.flag,bean.buildingdesc,bean.regionid" +
                " from T_Building bean where bean.flag='A' "+
                "and bean.regionid in  " +
                "( with recursive tmp as  ( select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid ) " +
                "  select regionid from tmp  )";

        Query query = entityManager.createNativeQuery(sql, TBuilding.class);
        if (!StringUtil.isEmpty(regionid)) {
            query.setParameter("regionid", regionid);
        }else {
            query.setParameter( "regionid", operRegionid);
        }
        List<TBuilding> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list;
        }
        return null;
    }

    @Transactional
    @Override
    public List<TBuilding> getBuildingOperBuildingByRegionId(String regionid,String operid) {
        String sql = "select bean.buildingid,bean.buildingname,bean.synctime,bean.updtime,bean.flag,bean.buildingdesc,bean.regionid" +
                " from T_Building bean where bean.flag='A' "+
                "and bean.regionid in  " +
                "( with recursive tmp as  ( select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid ) " +
                "  select regionid from tmp  ) and bean.buildingid in (select c.buildingid from t_operbuilding c where c.operid = :operid)";
        Query query = entityManager.createNativeQuery(sql, TBuilding.class);
        query.setParameter("regionid", regionid);
        query.setParameter("operid", operid);
        List list = query.getResultList();
        return list;
    }
}
