package com.supwisdom.dlpay.system.dao.impl;

import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.dao.CompanyDao;
import com.supwisdom.dlpay.system.domain.TCompany;
import com.supwisdom.dlpay.system.domain.TModifyCompany;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class CompanyDaoImpl implements CompanyDao {

    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public Pagination getSystemCompanyList(String companyName, int pageNo, int pageSize) {
        String sql = " select a.companyid,a.companyname,a.licenseid,a.companyaddress,a.legalpeople,a.legalpeoplecardtype," +
                " a.legalpeoplecardid,a.companyphone,case when a.status='1' then '有效' when a.status='2' then '待定' else '注销' end status,a.remarks, " +
                " case when a.checkstatus='0' then '待审核' when a.checkstatus='1' then '审核通过' else '审核驳回' end checkstatus," +
                " a.checkmessage,a.checkoperid,a.checkflag " +
                " from tb_company a where 1>0 ";
        if (!StringUtil.isEmpty(companyName)){
            sql += " and a.companyName like :companyName ";
        }

        sql += " order by a.companyid";

        Query query = entityManager.createNativeQuery(sql, TCompany.class);
        if(!StringUtil.isEmpty(companyName)){
            query.setParameter("companyName", "%"+companyName+"%" );
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TCompany> list = query.getResultList();
        page.setList(list);
        int totalCount = getSystemCompanyListCount(companyName);
        page.setTotalCount(totalCount);
        return page;
    }

    private int getSystemCompanyListCount(String companyName){
        String sql = "select count(*) from TB_Company where 1>0 ";
        if (!StringUtil.isEmpty(companyName)){
            sql += " and companyName like :companyName ";
        }
        Query query = entityManager.createNativeQuery(sql);
        if(!StringUtil.isEmpty(companyName)){
            query.setParameter("companyName", "%"+companyName+"%" );
        }
        int cnt=0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public Pagination getOperCompanyList(String companyName, int pageNo, int pageSize, String operid) {
        String sql = " select a.companyid,a.companyname,a.licenseid,a.companyaddress,a.legalpeople,a.legalpeoplecardtype, " +
                " a.legalpeoplecardid,a.companyphone,case when a.status='1' then '有效' when a.status='2' then '待定' else '注销' end status,a.remarks, " +
                " case when a.checkstatus='0' then '待审核' when a.checkstatus='1' then '审核通过' else '审核驳回' end checkstatus," +
                " a.checkmessage,a.checkoperid,a.checkflag " +
                " from tb_company a,tb_operator b where a.companyid = b.companyid and b.operid = :operid ";
        if (!StringUtil.isEmpty(companyName)){
            sql += " and a.companyName like :companyName ";
        }

        sql += " order by a.companyid";

        Query query = entityManager.createNativeQuery(sql, TCompany.class);
        query.setParameter("operid", operid);
        if(!StringUtil.isEmpty(companyName)){
            query.setParameter("companyName", "%"+companyName+"%" );
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TCompany> list = query.getResultList();
        page.setList(list);
        int totalCount = getOperCompanyListCount(companyName,operid);
        page.setTotalCount(totalCount);
        return page;
    }

    private int getOperCompanyListCount(String companyName,String operid){
        String sql = "select count(*) from tb_company a,tb_operator b where a.companyid = b.companyid and b.operid = :operid ";
        if (!StringUtil.isEmpty(companyName)){
            sql += " and companyName like :companyName ";
        }
        Query query = entityManager.createNativeQuery(sql);
        query.setParameter("operid", operid);
        if(!StringUtil.isEmpty(companyName)){
            query.setParameter("companyName", "%"+companyName+"%" );
        }
        int cnt=0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public TCompany getCompanyByName(String companyName) {
        String sql = "select a from TCompany a where a.companyName = :companyName ";
        TypedQuery<TCompany> query = entityManager.createQuery(sql, TCompany.class);
        query.setParameter("companyName", companyName );
        List<TCompany> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean saveCompany(TCompany bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public TCompany getCompanyAllStatusById(String companyId) {
        String sql = "select a from TCompany a where a.companyId = :companyId ";
        TypedQuery<TCompany> query = entityManager.createQuery(sql, TCompany.class);
        query.setParameter("companyId", companyId);
        List<TCompany> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateCompany(TCompany bean) {
        boolean flag = false;
        try {
            entityManager.merge(bean);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TOperator> getOperByCompanyId(String companyId) {
        String sql = "select a from TOperator a where a.status='normal' and a.companyId = :companyId ";
        TypedQuery<TOperator> query = entityManager.createQuery(sql, TOperator.class);
        query.setParameter("companyId", companyId);
        List<TOperator> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list;
        }
        return null;
    }

    @Transactional
    @Override
    public TCompany getCompanyByNameAndId(String companyName, String companyId) {
        String sql = "select a from TCompany a where a.companyName = :companyName and a.companyId <>:companyId";
        TypedQuery<TCompany> query = entityManager.createQuery(sql, TCompany.class);
        query.setParameter("companyName", companyName );
        query.setParameter("companyId",  companyId);
        List<TCompany> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public Pagination getCheckCompanyList(String companyName, int pageNo, int pageSize) {
        String sql = " select a.companyid,a.companyname,a.licenseid,a.companyaddress,a.legalpeople,a.legalpeoplecardtype," +
                " a.legalpeoplecardid,a.companyphone,a.status,a.remarks,a.checkstatus,a.checkmessage,a.checkoperid," +
                " case when a.checkflag='0' then '注册' when a.checkflag='1' then '修改' when a.checkflag='2' then '删除' else '无' end checkflag " +
                " from tb_company a where a.checkstatus='0' ";
        if (!StringUtil.isEmpty(companyName)){
            sql += " and a.companyName like :companyName ";
        }

        sql += " order by a.companyid";

        Query query = entityManager.createNativeQuery(sql, TCompany.class);
        if(!StringUtil.isEmpty(companyName)){
            query.setParameter("companyName", "%"+companyName+"%" );
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TCompany> list = query.getResultList();
        page.setList(list);
        int totalCount = getCheckCompanyListCount(companyName);
        page.setTotalCount(totalCount);
        return page;
    }

    private int getCheckCompanyListCount(String companyName){
        String sql = "select count(*) from TB_Company a where a.checkstatus='0' ";
        if (!StringUtil.isEmpty(companyName)){
            sql += " and companyName like :companyName ";
        }
        Query query = entityManager.createNativeQuery(sql);
        if(!StringUtil.isEmpty(companyName)){
            query.setParameter("companyName", "%"+companyName+"%" );
        }
        int cnt=0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public TCompany getCheckCompanyById(String companyId) {
        String sql = "select a from TCompany a where a.companyId=:companyId and a.checkStatus='0' ";
        TypedQuery<TCompany> query = entityManager.createQuery(sql, TCompany.class);
        query.setParameter("companyId", companyId);
        List<TCompany> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public List<TCompany> getValidCompanyList() {
        String sql = " select a from TCompany a where a.status='1' and a.checkStatus <> '0' ";
        TypedQuery<TCompany> query = entityManager.createQuery(sql, TCompany.class);
        List<TCompany> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list;
        }
        return null;
    }

    @Transactional
    @Override
    public TModifyCompany getModifyCompanyById(String companyId) {
        String sql = " select a from TModifyCompany a where a.companyId = :companyId";
        TypedQuery<TModifyCompany> query = entityManager.createQuery(sql, TModifyCompany.class);
        query.setParameter("companyId", companyId);
        List<TModifyCompany> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean saveModifyCompany(TModifyCompany bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public TModifyCompany getModifyCompanyByNameAndId(String companyName, String companyId) {
        String sql = "select a from TModifyCompany a where a.companyName = :companyName and a.companyId <>:companyId and a.status='1' ";
        TypedQuery<TModifyCompany> query = entityManager.createQuery(sql, TModifyCompany.class);
        query.setParameter("companyName", companyName );
        query.setParameter("companyId",  companyId);
        List<TModifyCompany> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateModifyCompany(TModifyCompany bean) {
        boolean flag = false;
        try {
            entityManager.merge(bean);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
}
