package com.supwisdom.dlpay.system.dao.impl;

import com.supwisdom.dlpay.system.dao.SystemParamDao;
import com.supwisdom.dlpay.system.domain.TSystemParam;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class SystemParamDaoImpl implements SystemParamDao {
    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public TSystemParam getSystemParamByKey(String paramKey) {
        String sql = "select bean from TSystemParam bean where bean.paramKey=:paramkey";
        TypedQuery<TSystemParam> query = entityManager.createQuery(sql, TSystemParam.class);
        query.setParameter("paramkey", paramKey);
        List<TSystemParam> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateSystemParamValueByKey(String paramKey, String paramValue) {
        boolean flag = false;
        try {
            String sql = "update Tb_systemparam  set param_value=:paramvalue where param_key=:paramkey";
            Query query = entityManager.createNativeQuery(sql);
            query.setParameter("paramkey", paramKey);
            query.setParameter("paramvalue", paramValue);
            query.executeUpdate();
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public boolean saveSystemParam(TSystemParam bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }
}
