package com.supwisdom.dlpay.system.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

@Entity
@Table(name = "TB_DEPT",
    indexes = {@Index(name = "UK_DEPT_DEPTCODE", unique = true, columnList = "DEPTCODE")})
public class TDept {
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name="DEPTCODE", nullable = false, length = 32)
  private String deptcode; //ID

  @Column(name="DEPTNO", nullable = false, length = 20)
  private String deptno;  //部门编号,可能会要修改，不能为主键，唯一索引

  @Column(name="DEPTNAME", precision = 600)
  private String deptname; //部门名称

  @Column(name="FDEPTCODE", nullable = false, length = 32)
  private String fdeptcode; //上级部门

  @Column(name="ENAME", precision = 600)
  private String ename; //部门英文名称

  @Column(name="STATUS", nullable = false, precision = 600)
  private String status; //normal-正常；closed-删除

  @Column(name="LASTSAVED", length = 20)
  private String lastsaved; //最后更新时间

  public String getDeptcode() {
    return deptcode;
  }

  public void setDeptcode(String deptcode) {
    this.deptcode = deptcode;
  }

  public String getDeptno() {
    return deptno;
  }

  public void setDeptno(String deptno) {
    this.deptno = deptno;
  }

  public String getDeptname() {
    return deptname;
  }

  public void setDeptname(String deptname) {
    this.deptname = deptname;
  }

  public String getFdeptcode() {
    return fdeptcode;
  }

  public void setFdeptcode(String fdeptcode) {
    this.fdeptcode = fdeptcode;
  }

  public String getEname() {
    return ename;
  }

  public void setEname(String ename) {
    this.ename = ename;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getLastsaved() {
    return lastsaved;
  }

  public void setLastsaved(String lastsaved) {
    this.lastsaved = lastsaved;
  }
}
