package com.supwisdom.dlpay.system.service;

import com.supwisdom.dlpay.framework.domain.TOperLog;
import com.supwisdom.dlpay.framework.domain.TOperRole;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.system.bean.LogBean;
import com.supwisdom.dlpay.system.bean.OperatorSearchBean;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface OperatorService {
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
    PageResult<TOperator> getOperatorsByPage(int pageNo, int pageSize, OperatorSearchBean searchBean);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
    boolean checkOpercodeExists(String opercode, String operid);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    boolean saveOperator(TOperator operator,String roles);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
    TOperator getOperatorByCode(String opercode);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
    List<TOperRole> getOperRoleByOperId(String operid);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    boolean resetPwd(String operid);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    boolean updateState(String operid,String state);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    boolean saveOperLog(TOperLog log);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class, readOnly = true)
    PageResult<TOperLog> getOperLogs(LogBean param);

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    boolean saveOperator(TOperator operator);
}
