package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.system.dao.CompanyDao;
import com.supwisdom.dlpay.system.domain.TCompany;
import com.supwisdom.dlpay.system.domain.TModifyCompany;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.CompanyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CompanyServiceImpl implements CompanyService {

    @Autowired
    CompanyDao companyDao;

    @Override
    public Pagination getSystemCompanyList(String companyName, int pageNo, int pageSize) {
        return companyDao.getSystemCompanyList(companyName, pageNo, pageSize);
    }

    @Override
    public Pagination getOperCompanyList(String companyName, int pageNo, int pageSize, String operid) {
        return companyDao.getOperCompanyList(companyName, pageNo, pageSize, operid);
    }

    @Override
    public TCompany getCompanyByName(String companyName) {
        return companyDao.getCompanyByName(companyName);
    }

    @Override
    public boolean saveCompany(TCompany bean) {
        return companyDao.saveCompany(bean);
    }

    @Override
    public TCompany getCompanyAllStatusById(String companyId) {
        return companyDao.getCompanyAllStatusById(companyId);
    }

    @Override
    public boolean updateCompany(TCompany bean) {
        return companyDao.updateCompany(bean);
    }

    @Override
    public List<TOperator> getOperByCompanyId(String companyId) {
        return companyDao.getOperByCompanyId(companyId);
    }

    @Override
    public TCompany getCompanyByNameAndId(String companyName, String companyId) {
        return companyDao.getCompanyByNameAndId(companyName, companyId);
    }

    @Override
    public Pagination getCheckCompanyList(String companyName, int pageNo, int pageSize) {
        return companyDao.getCheckCompanyList(companyName, pageNo, pageSize);
    }

    @Override
    public TCompany getCheckCompanyById(String companyId) {
        return companyDao.getCheckCompanyById(companyId);
    }

    @Override
    public List<TCompany> getValidCompanyList() {
        return companyDao.getValidCompanyList();
    }

    @Override
    public TModifyCompany getModifyCompanyById(String companyId) {
        return companyDao.getModifyCompanyById(companyId);
    }

    @Override
    public boolean saveModifyCompany(TModifyCompany bean) {
        return companyDao.saveModifyCompany(bean);
    }

    @Override
    public TModifyCompany getModifyCompanyByNameAndId(String companyName, String companyId) {
        return companyDao.getModifyCompanyByNameAndId(companyName, companyId);
    }

    @Override
    public boolean updateModifyCompany(TModifyCompany bean) {
        return companyDao.updateModifyCompany(bean);
    }
}
