package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.framework.domain.TOperRole;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.domain.TRole;
import com.supwisdom.dlpay.system.dao.ManagerDao;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.ManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagerServiceImpl implements ManagerService {
    @Autowired
    ManagerDao managerDao;

    @Override
    public Pagination getOperatorList(String operid, String realname, int pageNo, int pageSize) {
        return managerDao.getOperatorList(operid, realname, pageNo, pageSize);
    }

    @Override
    public Pagination getOperOperatorList(String operatorOperid, String operid, String realname, int pageNo, int pageSize) {
        return managerDao.getOperOperatorList(operatorOperid, operid, realname, pageNo, pageSize);
    }


    @Override
    public boolean deleteOperatorById(String operid) {
        return managerDao.updateOperatorStatusById(operid);
    }

    @Override
    public TOperator getOperatorById(String operid) {
        return managerDao.getOperatorById(operid);
    }

    @Override
    public TOperator getOperatorByOpercode(String opercode) {
        return managerDao.getOperatorByOpercode(opercode);
    }

    @Override
    public TRole getOperRoleById(String operid) {
        return managerDao.getOperRoleById(operid);
    }

    @Override
    public boolean saveOperator(TOperator bean) {
        return managerDao.saveOperator(bean);
    }

    @Override
    public boolean updateOperator(TOperator bean) {
        return managerDao.updateOperator(bean);
    }

    @Override
    public boolean saveOperRole(TOperRole bean) {
        return managerDao.saveOperRole(bean);
    }

    @Override
    public TOperRole getTOperRoleByOperid(String operid) {
        return managerDao.getTOperRoleByOperid(operid);
    }

    @Override
    public boolean updateTOperRole(TOperRole bean) {
        return managerDao.updateTOperRole(bean);
    }
}
