package com.supwisdom.dlpay.util;

import com.google.gson.Gson;
import com.supwisdom.dlpay.hk.common.Resp;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.util.*;

public class HTTPSClientUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";
    public static String doPost(HttpClient httpClient, String url, Map<String, String> paramHeader,
                                Map<String, String> paramBody) throws Exception {
        return doPost(httpClient, url, paramHeader, paramBody, DEFAULT_CHARSET);
    }

    public static String doPost(HttpClient httpClient, String url, Map<String, String> paramHeader,
                                Map<String, String> paramBody, String charset) throws Exception {

        String result = null;
        HttpPost httpPost = new HttpPost(url);
        setHeader(httpPost, paramHeader);
        setBody(httpPost, paramBody, charset);
        HttpResponse response = httpClient.execute(httpPost);
        if (response != null) {
            HttpEntity resEntity = response.getEntity();
            if (resEntity != null) {
                result = EntityUtils.toString(resEntity, charset);
            }
        }

        return result;
    }

    public static String doGet(HttpClient httpClient, String url, Map<String, String> paramHeader,
                               Map<String, String> paramBody) throws Exception {
        return doGet(httpClient, url, paramHeader, paramBody, DEFAULT_CHARSET);
    }

    public static String doGet(HttpClient httpClient, String url, Map<String, String> paramHeader,
                               Map<String, String> paramBody, String charset) throws Exception {

        String result = null;
        HttpGet httpGet = new HttpGet(url);
        setHeader(httpGet, paramHeader);

        HttpResponse response = httpClient.execute(httpGet);
        if (response != null) {
            HttpEntity resEntity = response.getEntity();
            if (resEntity != null) {
                result = EntityUtils.toString(resEntity, charset);
            }
        }

        return result;
    }


    private static void setHeader(HttpRequestBase request, Map<String, String> paramHeader) {
        // 设置Header
        if (paramHeader != null) {
            Set<String> keySet = paramHeader.keySet();
            for (String key : keySet) {
                request.addHeader(key, paramHeader.get(key));
            }
        }
    }

    private static void setBody(HttpPost httpPost, Map<String, String> paramBody, String charset) throws Exception {
        // 设置参数
        if (paramBody != null) {
            List<NameValuePair> list = new ArrayList<NameValuePair>();
            Set<String> keySet = paramBody.keySet();
            for (String key : keySet) {
                list.add(new BasicNameValuePair(key, paramBody.get(key)));
            }

            if (list.size() > 0) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, charset);
                httpPost.setEntity(entity);
            }
        }
    }


    public static void main(String[] args) throws Exception {
        HttpClient httpClient = null;

        httpClient = new HTTPSTrustClient().init();
        //httpClient = new HTTPSCertifiedClient().init();

        //String url = "https://api2.hik-cloud.com/oauth/token";
        String url = "https://api2.hik-cloud.com/api/v1/estate/system/communities/actions/list?pageNo=1&pageSize=10";

        Map<String, String> paramHeader = new HashMap<>();
        paramHeader.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        paramHeader.put("Authorization", "bearer 913d06ca-7f08-4103-9d43-b906c168b19e");

        Map<String, String> paramBody = new HashMap<>();
        //paramBody.put("client_id", "f2a70c45594f44e7a7468a5fcd9d5b62");
        //paramBody.put("client_secret", "7f99dc28bcaa46aeb4596fe607ae95e1");
        //paramBody.put("grant_type", "client_credentials");
        //paramBody.put("scope", "app");
        //String result = doPost(httpClient, url, paramHeader, paramBody);

        String result = HTTPSClientUtil.doGet(httpClient, url, paramHeader, paramBody);

        System.out.println(result);

        Gson gson = new Gson();

        Resp resp = gson.fromJson(result, Resp.class);

        System.out.println(resp.getMessage());

    }
}