package com.supwisdom.dlpay.visitormanage.controller;


import com.google.gson.Gson;
import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.api.bean.QueryUserParam;
import com.supwisdom.dlpay.api.bean.UserInforResponse;
import com.supwisdom.dlpay.customer.bean.CustomerSearchBean;
import com.supwisdom.dlpay.doorlist.bean.CustomerListBean;
import com.supwisdom.dlpay.doorlist.bean.TCustomerInfo;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.paysdk.proxy.UserProxy;
import com.supwisdom.dlpay.system.bean.RegionBean;
import com.supwisdom.dlpay.system.domain.TCustType;
import com.supwisdom.dlpay.system.domain.TDept;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.service.SystemService;
import com.supwisdom.dlpay.util.RedisUtil;
import com.supwisdom.dlpay.visitormanage.domain.*;
import com.supwisdom.dlpay.visitormanage.service.VisitormanageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/visitor")
public class VisitorManageController {


    @Autowired
    private UserProxy userProxy;
    @Autowired
    private SystemService systemService;
    @Autowired
    private VisitormanageService visitormanageService;
    @Autowired
    private WebInterfaceService webInterfaceService;

    @RequestMapping("/index")
    public String indexView(ModelMap model) {
        List<TCustType> lst = systemService.findAllCusttype();
        List<TDept> dept=systemService.findAllDept();
        Gson gson = new Gson();
        String deptString = gson.toJson(dept);
        model.put("deptlist", deptString);
        String typeString = gson.toJson(lst);
        model.put("custtypelist", typeString);

        return "visitormanage/customer/index";
    }
    @RequestMapping("/showchecklist")
    public String showchecklist(ModelMap model) {
        List<TCustType> lst = systemService.findAllCusttype();
        List<TDept> dept=systemService.findAllDept();
        Gson gson = new Gson();
        String deptString = gson.toJson(dept);
        model.put("deptlist", deptString);
        String typeString = gson.toJson(lst);
        model.put("custtypelist", typeString);

        return "visitormanage/customer/visitorchecklist";
    }
    @RequestMapping("/checkin")
    public String visitorcheck(ModelMap model) {
        List<TCustType> lst = systemService.findAllCusttype();
        List<TDept> dept=systemService.findAllDept();
        Gson gson = new Gson();
        String deptString = gson.toJson(dept);
        model.put("deptlist", dept);
        String typeString = gson.toJson(lst);
        model.put("custtypelist", lst);

        return "visitormanage/addVisitorCheck";
    }

    @RequestMapping("/list")
    @ResponseBody
    public PageResult<EVisitorDtl> getDataList(@RequestParam("page") Integer pageNo,
                                                   @RequestParam("limit") Integer pageSize,
                                                   @RequestParam(value = "searchkey", required = false) String searchKey,
                                                   @RequestParam(value = "inoutflag", required = false) String inoutflag,
                                                   @RequestParam(value = "startdate", required = false) String startdate,
                                                   @RequestParam(value = "enddate", required = false) String enddate
    ) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            VisitorSearchBean searchBean = new VisitorSearchBean();
            if(startdate!=null){
                startdate=startdate.replace("-","");
            }if(enddate!=null){
                enddate=enddate.replace("-","");
            }
            searchBean.setPageNo(pageNo);
            searchBean.setNickname(searchKey);
            searchBean.setInoutflag(inoutflag);
            searchBean.setStartdate(startdate);
            searchBean.setEnddate(enddate);
            searchBean.setPageSize(pageSize);
            PageResult<EVisitorDtl> bean= visitormanageService.getVisitorInfoPage(searchBean);

            return bean;
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }
    @RequestMapping("/checklist")
    @ResponseBody
    public PageResult<VisitorShowBean> getCheckList(@RequestParam("page") Integer pageNo,
                                               @RequestParam("limit") Integer pageSize,
                                               @RequestParam(value = "searchkey", required = false) String searchKey,
                                               @RequestParam(value = "sex", required = false) String sex,
                                               @RequestParam(value = "startdate", required = false) String startdate,
                                               @RequestParam(value = "enddate", required = false) String enddate
    ) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            VisitorCheckSearchBean searchBean = new VisitorCheckSearchBean();
            if(startdate!=null){
                startdate=startdate.replace("-","");
            }if(enddate!=null){
                enddate=enddate.replace("-","");
            }
            searchBean.setPageNo(pageNo);
            searchBean.setVisitorname(searchKey);
            searchBean.setSex(sex);
            searchBean.setStartdate(startdate);
            searchBean.setEnddate(enddate);
            searchBean.setPageSize(pageSize);
            PageResult<VisitorShowBean> bean= visitormanageService.getCheckInfoPage(searchBean);

            return bean;
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }



    @ResponseBody
    @RequestMapping("/getcustlist")
    public Map loadAppDevList(@RequestParam(value = "deptcode",required = true,defaultValue = "")String deptcode){
        Map map = new HashMap();
        try{
            CustomerSearchBean searchBean = new CustomerSearchBean();
                searchBean.setDeptcode(deptcode);
            PageResult<TCustomerInfo> bean= webInterfaceService.getCustomerInfoPage(searchBean);
            List<TCustomerInfo> custlist = bean.getData();
            map.put("custlist",custlist);
        }catch (Exception e){
            e.printStackTrace();
        }
        return map;


    }@ResponseBody
    @RequestMapping("/getdeptlist")
    public Map loadDeptList(){
        Map map = new HashMap();
        try{
            List<TDept> deptlist=systemService.findAllDept();
            map.put("deptlist",deptlist);
        }catch (Exception e){
            e.printStackTrace();
        }
        return map;


    }
    /**
     * 访客登记
     * @param postData
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/addvisitorcheck", method = {RequestMethod.POST})
    public Map saveVisitorCheck (@RequestBody VisitorCheckBean postData){
        Map map = new HashMap();
        try{
            String time = DateUtil.getNow("yyyyMMddhhmmss");
            EVisitorCheckDtl eVisitorCheckDtl=new EVisitorCheckDtl();
            eVisitorCheckDtl.setCompany(postData.getCompany());
            eVisitorCheckDtl.setCustid(postData.getCustid());
            eVisitorCheckDtl.setDeptcode(postData.getDeptcode());
            eVisitorCheckDtl.setPhone(postData.getPhone());
            eVisitorCheckDtl.setRemarks(postData.getRemarks());
            eVisitorCheckDtl.setVisitorname(postData.getVisitorname());
            eVisitorCheckDtl.setTransdate(time.substring(0,8));
            eVisitorCheckDtl.setStatus(1);
            eVisitorCheckDtl.setIdno(postData.getIdno());
            eVisitorCheckDtl.setSex(postData.getSex());
            eVisitorCheckDtl.setTranstime(time.substring(8));

            boolean b = visitormanageService.saveVisitorCheck(eVisitorCheckDtl);
            if(b){
                map.put("errStr", "");
            }else {
                map.put("errStr", "保存失败");

            }
        }catch (Exception e){
            e.printStackTrace();
            map.put("errStr", "保存失败!");
        }
        return map;
    }


}
